/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkSampleLocationsInfoEXT;

public class VkAttachmentSampleLocationsEXT
extends Struct<VkAttachmentSampleLocationsEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ATTACHMENTINDEX;
    public static final int SAMPLELOCATIONSINFO;

    protected VkAttachmentSampleLocationsEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkAttachmentSampleLocationsEXT create(long address, @Nullable ByteBuffer container) {
        return new VkAttachmentSampleLocationsEXT(address, container);
    }

    public VkAttachmentSampleLocationsEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkAttachmentSampleLocationsEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int attachmentIndex() {
        return VkAttachmentSampleLocationsEXT.nattachmentIndex(this.address());
    }

    public VkSampleLocationsInfoEXT sampleLocationsInfo() {
        return VkAttachmentSampleLocationsEXT.nsampleLocationsInfo(this.address());
    }

    public VkAttachmentSampleLocationsEXT attachmentIndex(@NativeType(value="uint32_t") int value) {
        VkAttachmentSampleLocationsEXT.nattachmentIndex(this.address(), value);
        return this;
    }

    public VkAttachmentSampleLocationsEXT sampleLocationsInfo(VkSampleLocationsInfoEXT value) {
        VkAttachmentSampleLocationsEXT.nsampleLocationsInfo(this.address(), value);
        return this;
    }

    public VkAttachmentSampleLocationsEXT sampleLocationsInfo(Consumer<VkSampleLocationsInfoEXT> consumer) {
        consumer.accept(this.sampleLocationsInfo());
        return this;
    }

    public VkAttachmentSampleLocationsEXT set(int attachmentIndex, VkSampleLocationsInfoEXT sampleLocationsInfo) {
        this.attachmentIndex(attachmentIndex);
        this.sampleLocationsInfo(sampleLocationsInfo);
        return this;
    }

    public VkAttachmentSampleLocationsEXT set(VkAttachmentSampleLocationsEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkAttachmentSampleLocationsEXT malloc() {
        return new VkAttachmentSampleLocationsEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkAttachmentSampleLocationsEXT calloc() {
        return new VkAttachmentSampleLocationsEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkAttachmentSampleLocationsEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkAttachmentSampleLocationsEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkAttachmentSampleLocationsEXT create(long address) {
        return new VkAttachmentSampleLocationsEXT(address, null);
    }

    public static @Nullable VkAttachmentSampleLocationsEXT createSafe(long address) {
        return address == 0L ? null : new VkAttachmentSampleLocationsEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkAttachmentSampleLocationsEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkAttachmentSampleLocationsEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkAttachmentSampleLocationsEXT mallocStack() {
        return VkAttachmentSampleLocationsEXT.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkAttachmentSampleLocationsEXT callocStack() {
        return VkAttachmentSampleLocationsEXT.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkAttachmentSampleLocationsEXT mallocStack(MemoryStack stack) {
        return VkAttachmentSampleLocationsEXT.malloc(stack);
    }

    @Deprecated
    public static VkAttachmentSampleLocationsEXT callocStack(MemoryStack stack) {
        return VkAttachmentSampleLocationsEXT.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkAttachmentSampleLocationsEXT.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkAttachmentSampleLocationsEXT.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkAttachmentSampleLocationsEXT.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkAttachmentSampleLocationsEXT.calloc(capacity, stack);
    }

    public static VkAttachmentSampleLocationsEXT malloc(MemoryStack stack) {
        return new VkAttachmentSampleLocationsEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkAttachmentSampleLocationsEXT calloc(MemoryStack stack) {
        return new VkAttachmentSampleLocationsEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nattachmentIndex(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)ATTACHMENTINDEX));
    }

    public static VkSampleLocationsInfoEXT nsampleLocationsInfo(long struct) {
        return VkSampleLocationsInfoEXT.create(struct + (long)SAMPLELOCATIONSINFO);
    }

    public static void nattachmentIndex(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)ATTACHMENTINDEX), (int)value);
    }

    public static void nsampleLocationsInfo(long struct, VkSampleLocationsInfoEXT value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SAMPLELOCATIONSINFO), (long)VkSampleLocationsInfoEXT.SIZEOF);
    }

    public static void validate(long struct) {
        VkSampleLocationsInfoEXT.validate(struct + (long)SAMPLELOCATIONSINFO);
    }

    static {
        Struct.Layout layout = VkAttachmentSampleLocationsEXT.__struct((Struct.Member[])new Struct.Member[]{VkAttachmentSampleLocationsEXT.__member((int)4), VkAttachmentSampleLocationsEXT.__member((int)VkSampleLocationsInfoEXT.SIZEOF, (int)VkSampleLocationsInfoEXT.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ATTACHMENTINDEX = layout.offsetof(0);
        SAMPLELOCATIONSINFO = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkAttachmentSampleLocationsEXT, Buffer>
    implements NativeResource {
        private static final VkAttachmentSampleLocationsEXT ELEMENT_FACTORY = VkAttachmentSampleLocationsEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkAttachmentSampleLocationsEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int attachmentIndex() {
            return VkAttachmentSampleLocationsEXT.nattachmentIndex(this.address());
        }

        public VkSampleLocationsInfoEXT sampleLocationsInfo() {
            return VkAttachmentSampleLocationsEXT.nsampleLocationsInfo(this.address());
        }

        public Buffer attachmentIndex(@NativeType(value="uint32_t") int value) {
            VkAttachmentSampleLocationsEXT.nattachmentIndex(this.address(), value);
            return this;
        }

        public Buffer sampleLocationsInfo(VkSampleLocationsInfoEXT value) {
            VkAttachmentSampleLocationsEXT.nsampleLocationsInfo(this.address(), value);
            return this;
        }

        public Buffer sampleLocationsInfo(Consumer<VkSampleLocationsInfoEXT> consumer) {
            consumer.accept(this.sampleLocationsInfo());
            return this;
        }
    }
}

