/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkBindBufferMemoryInfo;

public class VkBindBufferMemoryInfoKHR
extends VkBindBufferMemoryInfo {
    protected VkBindBufferMemoryInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkBindBufferMemoryInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkBindBufferMemoryInfoKHR(address, container);
    }

    public VkBindBufferMemoryInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkBindBufferMemoryInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkBindBufferMemoryInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkBindBufferMemoryInfoKHR sType$Default() {
        return this.sType(1000157000);
    }

    @Override
    public VkBindBufferMemoryInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkBindBufferMemoryInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkBindBufferMemoryInfoKHR buffer(@NativeType(value="VkBuffer") long value) {
        VkBindBufferMemoryInfoKHR.nbuffer(this.address(), value);
        return this;
    }

    @Override
    public VkBindBufferMemoryInfoKHR memory(@NativeType(value="VkDeviceMemory") long value) {
        VkBindBufferMemoryInfoKHR.nmemory(this.address(), value);
        return this;
    }

    @Override
    public VkBindBufferMemoryInfoKHR memoryOffset(@NativeType(value="VkDeviceSize") long value) {
        VkBindBufferMemoryInfoKHR.nmemoryOffset(this.address(), value);
        return this;
    }

    @Override
    public VkBindBufferMemoryInfoKHR set(int sType, long pNext, long buffer, long memory, long memoryOffset) {
        this.sType(sType);
        this.pNext(pNext);
        this.buffer(buffer);
        this.memory(memory);
        this.memoryOffset(memoryOffset);
        return this;
    }

    public VkBindBufferMemoryInfoKHR set(VkBindBufferMemoryInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkBindBufferMemoryInfoKHR malloc() {
        return new VkBindBufferMemoryInfoKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkBindBufferMemoryInfoKHR calloc() {
        return new VkBindBufferMemoryInfoKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkBindBufferMemoryInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkBindBufferMemoryInfoKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkBindBufferMemoryInfoKHR create(long address) {
        return new VkBindBufferMemoryInfoKHR(address, null);
    }

    public static @Nullable VkBindBufferMemoryInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkBindBufferMemoryInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkBindBufferMemoryInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBindBufferMemoryInfoKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkBindBufferMemoryInfoKHR mallocStack() {
        return VkBindBufferMemoryInfoKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBindBufferMemoryInfoKHR callocStack() {
        return VkBindBufferMemoryInfoKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBindBufferMemoryInfoKHR mallocStack(MemoryStack stack) {
        return VkBindBufferMemoryInfoKHR.malloc(stack);
    }

    @Deprecated
    public static VkBindBufferMemoryInfoKHR callocStack(MemoryStack stack) {
        return VkBindBufferMemoryInfoKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkBindBufferMemoryInfoKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkBindBufferMemoryInfoKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBindBufferMemoryInfoKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBindBufferMemoryInfoKHR.calloc(capacity, stack);
    }

    public static VkBindBufferMemoryInfoKHR malloc(MemoryStack stack) {
        return new VkBindBufferMemoryInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkBindBufferMemoryInfoKHR calloc(MemoryStack stack) {
        return new VkBindBufferMemoryInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkBindBufferMemoryInfo.Buffer {
        private static final VkBindBufferMemoryInfoKHR ELEMENT_FACTORY = VkBindBufferMemoryInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkBindBufferMemoryInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBindBufferMemoryInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000157000);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBindBufferMemoryInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer buffer(@NativeType(value="VkBuffer") long value) {
            VkBindBufferMemoryInfoKHR.nbuffer(this.address(), value);
            return this;
        }

        @Override
        public Buffer memory(@NativeType(value="VkDeviceMemory") long value) {
            VkBindBufferMemoryInfoKHR.nmemory(this.address(), value);
            return this;
        }

        @Override
        public Buffer memoryOffset(@NativeType(value="VkDeviceSize") long value) {
            VkBindBufferMemoryInfoKHR.nmemoryOffset(this.address(), value);
            return this;
        }
    }
}

