/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBindIndexBufferIndirectCommandEXT
extends Struct<VkBindIndexBufferIndirectCommandEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUFFERADDRESS;
    public static final int SIZE;
    public static final int INDEXTYPE;

    protected VkBindIndexBufferIndirectCommandEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkBindIndexBufferIndirectCommandEXT create(long address, @Nullable ByteBuffer container) {
        return new VkBindIndexBufferIndirectCommandEXT(address, container);
    }

    public VkBindIndexBufferIndirectCommandEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkBindIndexBufferIndirectCommandEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceAddress")
    public long bufferAddress() {
        return VkBindIndexBufferIndirectCommandEXT.nbufferAddress(this.address());
    }

    @NativeType(value="uint32_t")
    public int size() {
        return VkBindIndexBufferIndirectCommandEXT.nsize(this.address());
    }

    @NativeType(value="VkIndexType")
    public int indexType() {
        return VkBindIndexBufferIndirectCommandEXT.nindexType(this.address());
    }

    public VkBindIndexBufferIndirectCommandEXT bufferAddress(@NativeType(value="VkDeviceAddress") long value) {
        VkBindIndexBufferIndirectCommandEXT.nbufferAddress(this.address(), value);
        return this;
    }

    public VkBindIndexBufferIndirectCommandEXT size(@NativeType(value="uint32_t") int value) {
        VkBindIndexBufferIndirectCommandEXT.nsize(this.address(), value);
        return this;
    }

    public VkBindIndexBufferIndirectCommandEXT indexType(@NativeType(value="VkIndexType") int value) {
        VkBindIndexBufferIndirectCommandEXT.nindexType(this.address(), value);
        return this;
    }

    public VkBindIndexBufferIndirectCommandEXT set(long bufferAddress, int size, int indexType) {
        this.bufferAddress(bufferAddress);
        this.size(size);
        this.indexType(indexType);
        return this;
    }

    public VkBindIndexBufferIndirectCommandEXT set(VkBindIndexBufferIndirectCommandEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkBindIndexBufferIndirectCommandEXT malloc() {
        return new VkBindIndexBufferIndirectCommandEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkBindIndexBufferIndirectCommandEXT calloc() {
        return new VkBindIndexBufferIndirectCommandEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkBindIndexBufferIndirectCommandEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkBindIndexBufferIndirectCommandEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkBindIndexBufferIndirectCommandEXT create(long address) {
        return new VkBindIndexBufferIndirectCommandEXT(address, null);
    }

    public static @Nullable VkBindIndexBufferIndirectCommandEXT createSafe(long address) {
        return address == 0L ? null : new VkBindIndexBufferIndirectCommandEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkBindIndexBufferIndirectCommandEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBindIndexBufferIndirectCommandEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkBindIndexBufferIndirectCommandEXT malloc(MemoryStack stack) {
        return new VkBindIndexBufferIndirectCommandEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkBindIndexBufferIndirectCommandEXT calloc(MemoryStack stack) {
        return new VkBindIndexBufferIndirectCommandEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nbufferAddress(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)BUFFERADDRESS));
    }

    public static int nsize(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SIZE));
    }

    public static int nindexType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)INDEXTYPE));
    }

    public static void nbufferAddress(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)BUFFERADDRESS), (long)value);
    }

    public static void nsize(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SIZE), (int)value);
    }

    public static void nindexType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)INDEXTYPE), (int)value);
    }

    static {
        Struct.Layout layout = VkBindIndexBufferIndirectCommandEXT.__struct((Struct.Member[])new Struct.Member[]{VkBindIndexBufferIndirectCommandEXT.__member((int)8), VkBindIndexBufferIndirectCommandEXT.__member((int)4), VkBindIndexBufferIndirectCommandEXT.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BUFFERADDRESS = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        INDEXTYPE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkBindIndexBufferIndirectCommandEXT, Buffer>
    implements NativeResource {
        private static final VkBindIndexBufferIndirectCommandEXT ELEMENT_FACTORY = VkBindIndexBufferIndirectCommandEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkBindIndexBufferIndirectCommandEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceAddress")
        public long bufferAddress() {
            return VkBindIndexBufferIndirectCommandEXT.nbufferAddress(this.address());
        }

        @NativeType(value="uint32_t")
        public int size() {
            return VkBindIndexBufferIndirectCommandEXT.nsize(this.address());
        }

        @NativeType(value="VkIndexType")
        public int indexType() {
            return VkBindIndexBufferIndirectCommandEXT.nindexType(this.address());
        }

        public Buffer bufferAddress(@NativeType(value="VkDeviceAddress") long value) {
            VkBindIndexBufferIndirectCommandEXT.nbufferAddress(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="uint32_t") int value) {
            VkBindIndexBufferIndirectCommandEXT.nsize(this.address(), value);
            return this;
        }

        public Buffer indexType(@NativeType(value="VkIndexType") int value) {
            VkBindIndexBufferIndirectCommandEXT.nindexType(this.address(), value);
            return this;
        }
    }
}

