/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBufferCopy
extends Struct<VkBufferCopy>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SRCOFFSET;
    public static final int DSTOFFSET;
    public static final int SIZE;

    protected VkBufferCopy(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkBufferCopy create(long address, @Nullable ByteBuffer container) {
        return new VkBufferCopy(address, container);
    }

    public VkBufferCopy(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkBufferCopy.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceSize")
    public long srcOffset() {
        return VkBufferCopy.nsrcOffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long dstOffset() {
        return VkBufferCopy.ndstOffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VkBufferCopy.nsize(this.address());
    }

    public VkBufferCopy srcOffset(@NativeType(value="VkDeviceSize") long value) {
        VkBufferCopy.nsrcOffset(this.address(), value);
        return this;
    }

    public VkBufferCopy dstOffset(@NativeType(value="VkDeviceSize") long value) {
        VkBufferCopy.ndstOffset(this.address(), value);
        return this;
    }

    public VkBufferCopy size(@NativeType(value="VkDeviceSize") long value) {
        VkBufferCopy.nsize(this.address(), value);
        return this;
    }

    public VkBufferCopy set(long srcOffset, long dstOffset, long size) {
        this.srcOffset(srcOffset);
        this.dstOffset(dstOffset);
        this.size(size);
        return this;
    }

    public VkBufferCopy set(VkBufferCopy src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkBufferCopy malloc() {
        return new VkBufferCopy(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkBufferCopy calloc() {
        return new VkBufferCopy(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkBufferCopy create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkBufferCopy(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkBufferCopy create(long address) {
        return new VkBufferCopy(address, null);
    }

    public static @Nullable VkBufferCopy createSafe(long address) {
        return address == 0L ? null : new VkBufferCopy(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkBufferCopy.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBufferCopy.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkBufferCopy mallocStack() {
        return VkBufferCopy.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBufferCopy callocStack() {
        return VkBufferCopy.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBufferCopy mallocStack(MemoryStack stack) {
        return VkBufferCopy.malloc(stack);
    }

    @Deprecated
    public static VkBufferCopy callocStack(MemoryStack stack) {
        return VkBufferCopy.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkBufferCopy.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkBufferCopy.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBufferCopy.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBufferCopy.calloc(capacity, stack);
    }

    public static VkBufferCopy malloc(MemoryStack stack) {
        return new VkBufferCopy(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkBufferCopy calloc(MemoryStack stack) {
        return new VkBufferCopy(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nsrcOffset(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)SRCOFFSET));
    }

    public static long ndstOffset(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)DSTOFFSET));
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)SIZE));
    }

    public static void nsrcOffset(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)SRCOFFSET), (long)value);
    }

    public static void ndstOffset(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)DSTOFFSET), (long)value);
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)SIZE), (long)value);
    }

    static {
        Struct.Layout layout = VkBufferCopy.__struct((Struct.Member[])new Struct.Member[]{VkBufferCopy.__member((int)8), VkBufferCopy.__member((int)8), VkBufferCopy.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SRCOFFSET = layout.offsetof(0);
        DSTOFFSET = layout.offsetof(1);
        SIZE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkBufferCopy, Buffer>
    implements NativeResource {
        private static final VkBufferCopy ELEMENT_FACTORY = VkBufferCopy.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkBufferCopy getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceSize")
        public long srcOffset() {
            return VkBufferCopy.nsrcOffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long dstOffset() {
            return VkBufferCopy.ndstOffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VkBufferCopy.nsize(this.address());
        }

        public Buffer srcOffset(@NativeType(value="VkDeviceSize") long value) {
            VkBufferCopy.nsrcOffset(this.address(), value);
            return this;
        }

        public Buffer dstOffset(@NativeType(value="VkDeviceSize") long value) {
            VkBufferCopy.ndstOffset(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="VkDeviceSize") long value) {
            VkBufferCopy.nsize(this.address(), value);
            return this;
        }
    }
}

