/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkBufferDeviceAddressInfo;

public class VkBufferDeviceAddressInfoEXT
extends VkBufferDeviceAddressInfo {
    protected VkBufferDeviceAddressInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkBufferDeviceAddressInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkBufferDeviceAddressInfoEXT(address, container);
    }

    public VkBufferDeviceAddressInfoEXT(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkBufferDeviceAddressInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkBufferDeviceAddressInfoEXT.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkBufferDeviceAddressInfoEXT sType$Default() {
        return this.sType(1000244001);
    }

    @Override
    public VkBufferDeviceAddressInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkBufferDeviceAddressInfoEXT.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkBufferDeviceAddressInfoEXT buffer(@NativeType(value="VkBuffer") long value) {
        VkBufferDeviceAddressInfoEXT.nbuffer(this.address(), value);
        return this;
    }

    @Override
    public VkBufferDeviceAddressInfoEXT set(int sType, long pNext, long buffer) {
        this.sType(sType);
        this.pNext(pNext);
        this.buffer(buffer);
        return this;
    }

    public VkBufferDeviceAddressInfoEXT set(VkBufferDeviceAddressInfoEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkBufferDeviceAddressInfoEXT malloc() {
        return new VkBufferDeviceAddressInfoEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkBufferDeviceAddressInfoEXT calloc() {
        return new VkBufferDeviceAddressInfoEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkBufferDeviceAddressInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkBufferDeviceAddressInfoEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkBufferDeviceAddressInfoEXT create(long address) {
        return new VkBufferDeviceAddressInfoEXT(address, null);
    }

    public static @Nullable VkBufferDeviceAddressInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkBufferDeviceAddressInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkBufferDeviceAddressInfoEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBufferDeviceAddressInfoEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkBufferDeviceAddressInfoEXT mallocStack() {
        return VkBufferDeviceAddressInfoEXT.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBufferDeviceAddressInfoEXT callocStack() {
        return VkBufferDeviceAddressInfoEXT.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBufferDeviceAddressInfoEXT mallocStack(MemoryStack stack) {
        return VkBufferDeviceAddressInfoEXT.malloc(stack);
    }

    @Deprecated
    public static VkBufferDeviceAddressInfoEXT callocStack(MemoryStack stack) {
        return VkBufferDeviceAddressInfoEXT.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkBufferDeviceAddressInfoEXT.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkBufferDeviceAddressInfoEXT.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBufferDeviceAddressInfoEXT.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBufferDeviceAddressInfoEXT.calloc(capacity, stack);
    }

    public static VkBufferDeviceAddressInfoEXT malloc(MemoryStack stack) {
        return new VkBufferDeviceAddressInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkBufferDeviceAddressInfoEXT calloc(MemoryStack stack) {
        return new VkBufferDeviceAddressInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkBufferDeviceAddressInfo.Buffer {
        private static final VkBufferDeviceAddressInfoEXT ELEMENT_FACTORY = VkBufferDeviceAddressInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkBufferDeviceAddressInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBufferDeviceAddressInfoEXT.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000244001);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBufferDeviceAddressInfoEXT.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer buffer(@NativeType(value="VkBuffer") long value) {
            VkBufferDeviceAddressInfoEXT.nbuffer(this.address(), value);
            return this;
        }
    }
}

