/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExternalMemoryAcquireUnmodifiedEXT;

public class VkBufferMemoryBarrier2
extends Struct<VkBufferMemoryBarrier2>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SRCSTAGEMASK;
    public static final int SRCACCESSMASK;
    public static final int DSTSTAGEMASK;
    public static final int DSTACCESSMASK;
    public static final int SRCQUEUEFAMILYINDEX;
    public static final int DSTQUEUEFAMILYINDEX;
    public static final int BUFFER;
    public static final int OFFSET;
    public static final int SIZE;

    protected VkBufferMemoryBarrier2(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkBufferMemoryBarrier2 create(long address, @Nullable ByteBuffer container) {
        return new VkBufferMemoryBarrier2(address, container);
    }

    public VkBufferMemoryBarrier2(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkBufferMemoryBarrier2.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkBufferMemoryBarrier2.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkBufferMemoryBarrier2.npNext(this.address());
    }

    @NativeType(value="VkPipelineStageFlags2")
    public long srcStageMask() {
        return VkBufferMemoryBarrier2.nsrcStageMask(this.address());
    }

    @NativeType(value="VkAccessFlags2")
    public long srcAccessMask() {
        return VkBufferMemoryBarrier2.nsrcAccessMask(this.address());
    }

    @NativeType(value="VkPipelineStageFlags2")
    public long dstStageMask() {
        return VkBufferMemoryBarrier2.ndstStageMask(this.address());
    }

    @NativeType(value="VkAccessFlags2")
    public long dstAccessMask() {
        return VkBufferMemoryBarrier2.ndstAccessMask(this.address());
    }

    @NativeType(value="uint32_t")
    public int srcQueueFamilyIndex() {
        return VkBufferMemoryBarrier2.nsrcQueueFamilyIndex(this.address());
    }

    @NativeType(value="uint32_t")
    public int dstQueueFamilyIndex() {
        return VkBufferMemoryBarrier2.ndstQueueFamilyIndex(this.address());
    }

    @NativeType(value="VkBuffer")
    public long buffer() {
        return VkBufferMemoryBarrier2.nbuffer(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long offset() {
        return VkBufferMemoryBarrier2.noffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VkBufferMemoryBarrier2.nsize(this.address());
    }

    public VkBufferMemoryBarrier2 sType(@NativeType(value="VkStructureType") int value) {
        VkBufferMemoryBarrier2.nsType(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier2 sType$Default() {
        return this.sType(1000314001);
    }

    public VkBufferMemoryBarrier2 pNext(@NativeType(value="void const *") long value) {
        VkBufferMemoryBarrier2.npNext(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier2 pNext(VkExternalMemoryAcquireUnmodifiedEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkBufferMemoryBarrier2 srcStageMask(@NativeType(value="VkPipelineStageFlags2") long value) {
        VkBufferMemoryBarrier2.nsrcStageMask(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier2 srcAccessMask(@NativeType(value="VkAccessFlags2") long value) {
        VkBufferMemoryBarrier2.nsrcAccessMask(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier2 dstStageMask(@NativeType(value="VkPipelineStageFlags2") long value) {
        VkBufferMemoryBarrier2.ndstStageMask(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier2 dstAccessMask(@NativeType(value="VkAccessFlags2") long value) {
        VkBufferMemoryBarrier2.ndstAccessMask(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier2 srcQueueFamilyIndex(@NativeType(value="uint32_t") int value) {
        VkBufferMemoryBarrier2.nsrcQueueFamilyIndex(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier2 dstQueueFamilyIndex(@NativeType(value="uint32_t") int value) {
        VkBufferMemoryBarrier2.ndstQueueFamilyIndex(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier2 buffer(@NativeType(value="VkBuffer") long value) {
        VkBufferMemoryBarrier2.nbuffer(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier2 offset(@NativeType(value="VkDeviceSize") long value) {
        VkBufferMemoryBarrier2.noffset(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier2 size(@NativeType(value="VkDeviceSize") long value) {
        VkBufferMemoryBarrier2.nsize(this.address(), value);
        return this;
    }

    public VkBufferMemoryBarrier2 set(int sType, long pNext, long srcStageMask, long srcAccessMask, long dstStageMask, long dstAccessMask, int srcQueueFamilyIndex, int dstQueueFamilyIndex, long buffer, long offset, long size) {
        this.sType(sType);
        this.pNext(pNext);
        this.srcStageMask(srcStageMask);
        this.srcAccessMask(srcAccessMask);
        this.dstStageMask(dstStageMask);
        this.dstAccessMask(dstAccessMask);
        this.srcQueueFamilyIndex(srcQueueFamilyIndex);
        this.dstQueueFamilyIndex(dstQueueFamilyIndex);
        this.buffer(buffer);
        this.offset(offset);
        this.size(size);
        return this;
    }

    public VkBufferMemoryBarrier2 set(VkBufferMemoryBarrier2 src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkBufferMemoryBarrier2 malloc() {
        return new VkBufferMemoryBarrier2(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkBufferMemoryBarrier2 calloc() {
        return new VkBufferMemoryBarrier2(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkBufferMemoryBarrier2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkBufferMemoryBarrier2(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkBufferMemoryBarrier2 create(long address) {
        return new VkBufferMemoryBarrier2(address, null);
    }

    public static @Nullable VkBufferMemoryBarrier2 createSafe(long address) {
        return address == 0L ? null : new VkBufferMemoryBarrier2(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkBufferMemoryBarrier2.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBufferMemoryBarrier2.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkBufferMemoryBarrier2 malloc(MemoryStack stack) {
        return new VkBufferMemoryBarrier2(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkBufferMemoryBarrier2 calloc(MemoryStack stack) {
        return new VkBufferMemoryBarrier2(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long nsrcStageMask(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)SRCSTAGEMASK));
    }

    public static long nsrcAccessMask(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)SRCACCESSMASK));
    }

    public static long ndstStageMask(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)DSTSTAGEMASK));
    }

    public static long ndstAccessMask(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)DSTACCESSMASK));
    }

    public static int nsrcQueueFamilyIndex(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SRCQUEUEFAMILYINDEX));
    }

    public static int ndstQueueFamilyIndex(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DSTQUEUEFAMILYINDEX));
    }

    public static long nbuffer(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)BUFFER));
    }

    public static long noffset(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)OFFSET));
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)SIZE));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nsrcStageMask(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)SRCSTAGEMASK), (long)value);
    }

    public static void nsrcAccessMask(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)SRCACCESSMASK), (long)value);
    }

    public static void ndstStageMask(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)DSTSTAGEMASK), (long)value);
    }

    public static void ndstAccessMask(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)DSTACCESSMASK), (long)value);
    }

    public static void nsrcQueueFamilyIndex(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SRCQUEUEFAMILYINDEX), (int)value);
    }

    public static void ndstQueueFamilyIndex(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)DSTQUEUEFAMILYINDEX), (int)value);
    }

    public static void nbuffer(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)BUFFER), (long)value);
    }

    public static void noffset(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)OFFSET), (long)value);
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)SIZE), (long)value);
    }

    static {
        Struct.Layout layout = VkBufferMemoryBarrier2.__struct((Struct.Member[])new Struct.Member[]{VkBufferMemoryBarrier2.__member((int)4), VkBufferMemoryBarrier2.__member((int)POINTER_SIZE), VkBufferMemoryBarrier2.__member((int)8), VkBufferMemoryBarrier2.__member((int)8), VkBufferMemoryBarrier2.__member((int)8), VkBufferMemoryBarrier2.__member((int)8), VkBufferMemoryBarrier2.__member((int)4), VkBufferMemoryBarrier2.__member((int)4), VkBufferMemoryBarrier2.__member((int)8), VkBufferMemoryBarrier2.__member((int)8), VkBufferMemoryBarrier2.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SRCSTAGEMASK = layout.offsetof(2);
        SRCACCESSMASK = layout.offsetof(3);
        DSTSTAGEMASK = layout.offsetof(4);
        DSTACCESSMASK = layout.offsetof(5);
        SRCQUEUEFAMILYINDEX = layout.offsetof(6);
        DSTQUEUEFAMILYINDEX = layout.offsetof(7);
        BUFFER = layout.offsetof(8);
        OFFSET = layout.offsetof(9);
        SIZE = layout.offsetof(10);
    }

    public static class Buffer
    extends StructBuffer<VkBufferMemoryBarrier2, Buffer>
    implements NativeResource {
        private static final VkBufferMemoryBarrier2 ELEMENT_FACTORY = VkBufferMemoryBarrier2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkBufferMemoryBarrier2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkBufferMemoryBarrier2.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkBufferMemoryBarrier2.npNext(this.address());
        }

        @NativeType(value="VkPipelineStageFlags2")
        public long srcStageMask() {
            return VkBufferMemoryBarrier2.nsrcStageMask(this.address());
        }

        @NativeType(value="VkAccessFlags2")
        public long srcAccessMask() {
            return VkBufferMemoryBarrier2.nsrcAccessMask(this.address());
        }

        @NativeType(value="VkPipelineStageFlags2")
        public long dstStageMask() {
            return VkBufferMemoryBarrier2.ndstStageMask(this.address());
        }

        @NativeType(value="VkAccessFlags2")
        public long dstAccessMask() {
            return VkBufferMemoryBarrier2.ndstAccessMask(this.address());
        }

        @NativeType(value="uint32_t")
        public int srcQueueFamilyIndex() {
            return VkBufferMemoryBarrier2.nsrcQueueFamilyIndex(this.address());
        }

        @NativeType(value="uint32_t")
        public int dstQueueFamilyIndex() {
            return VkBufferMemoryBarrier2.ndstQueueFamilyIndex(this.address());
        }

        @NativeType(value="VkBuffer")
        public long buffer() {
            return VkBufferMemoryBarrier2.nbuffer(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long offset() {
            return VkBufferMemoryBarrier2.noffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VkBufferMemoryBarrier2.nsize(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBufferMemoryBarrier2.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000314001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBufferMemoryBarrier2.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkExternalMemoryAcquireUnmodifiedEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer srcStageMask(@NativeType(value="VkPipelineStageFlags2") long value) {
            VkBufferMemoryBarrier2.nsrcStageMask(this.address(), value);
            return this;
        }

        public Buffer srcAccessMask(@NativeType(value="VkAccessFlags2") long value) {
            VkBufferMemoryBarrier2.nsrcAccessMask(this.address(), value);
            return this;
        }

        public Buffer dstStageMask(@NativeType(value="VkPipelineStageFlags2") long value) {
            VkBufferMemoryBarrier2.ndstStageMask(this.address(), value);
            return this;
        }

        public Buffer dstAccessMask(@NativeType(value="VkAccessFlags2") long value) {
            VkBufferMemoryBarrier2.ndstAccessMask(this.address(), value);
            return this;
        }

        public Buffer srcQueueFamilyIndex(@NativeType(value="uint32_t") int value) {
            VkBufferMemoryBarrier2.nsrcQueueFamilyIndex(this.address(), value);
            return this;
        }

        public Buffer dstQueueFamilyIndex(@NativeType(value="uint32_t") int value) {
            VkBufferMemoryBarrier2.ndstQueueFamilyIndex(this.address(), value);
            return this;
        }

        public Buffer buffer(@NativeType(value="VkBuffer") long value) {
            VkBufferMemoryBarrier2.nbuffer(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="VkDeviceSize") long value) {
            VkBufferMemoryBarrier2.noffset(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="VkDeviceSize") long value) {
            VkBufferMemoryBarrier2.nsize(this.address(), value);
            return this;
        }
    }
}

