/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkClearValue;

public class VkClearAttachment
extends Struct<VkClearAttachment>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ASPECTMASK;
    public static final int COLORATTACHMENT;
    public static final int CLEARVALUE;

    protected VkClearAttachment(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkClearAttachment create(long address, @Nullable ByteBuffer container) {
        return new VkClearAttachment(address, container);
    }

    public VkClearAttachment(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkClearAttachment.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkImageAspectFlags")
    public int aspectMask() {
        return VkClearAttachment.naspectMask(this.address());
    }

    @NativeType(value="uint32_t")
    public int colorAttachment() {
        return VkClearAttachment.ncolorAttachment(this.address());
    }

    public VkClearValue clearValue() {
        return VkClearAttachment.nclearValue(this.address());
    }

    public VkClearAttachment aspectMask(@NativeType(value="VkImageAspectFlags") int value) {
        VkClearAttachment.naspectMask(this.address(), value);
        return this;
    }

    public VkClearAttachment colorAttachment(@NativeType(value="uint32_t") int value) {
        VkClearAttachment.ncolorAttachment(this.address(), value);
        return this;
    }

    public VkClearAttachment clearValue(VkClearValue value) {
        VkClearAttachment.nclearValue(this.address(), value);
        return this;
    }

    public VkClearAttachment clearValue(Consumer<VkClearValue> consumer) {
        consumer.accept(this.clearValue());
        return this;
    }

    public VkClearAttachment set(int aspectMask, int colorAttachment, VkClearValue clearValue) {
        this.aspectMask(aspectMask);
        this.colorAttachment(colorAttachment);
        this.clearValue(clearValue);
        return this;
    }

    public VkClearAttachment set(VkClearAttachment src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkClearAttachment malloc() {
        return new VkClearAttachment(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkClearAttachment calloc() {
        return new VkClearAttachment(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkClearAttachment create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkClearAttachment(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkClearAttachment create(long address) {
        return new VkClearAttachment(address, null);
    }

    public static @Nullable VkClearAttachment createSafe(long address) {
        return address == 0L ? null : new VkClearAttachment(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkClearAttachment.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkClearAttachment.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkClearAttachment mallocStack() {
        return VkClearAttachment.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkClearAttachment callocStack() {
        return VkClearAttachment.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkClearAttachment mallocStack(MemoryStack stack) {
        return VkClearAttachment.malloc(stack);
    }

    @Deprecated
    public static VkClearAttachment callocStack(MemoryStack stack) {
        return VkClearAttachment.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkClearAttachment.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkClearAttachment.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkClearAttachment.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkClearAttachment.calloc(capacity, stack);
    }

    public static VkClearAttachment malloc(MemoryStack stack) {
        return new VkClearAttachment(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkClearAttachment calloc(MemoryStack stack) {
        return new VkClearAttachment(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int naspectMask(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)ASPECTMASK));
    }

    public static int ncolorAttachment(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)COLORATTACHMENT));
    }

    public static VkClearValue nclearValue(long struct) {
        return VkClearValue.create(struct + (long)CLEARVALUE);
    }

    public static void naspectMask(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)ASPECTMASK), (int)value);
    }

    public static void ncolorAttachment(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)COLORATTACHMENT), (int)value);
    }

    public static void nclearValue(long struct, VkClearValue value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CLEARVALUE), (long)VkClearValue.SIZEOF);
    }

    static {
        Struct.Layout layout = VkClearAttachment.__struct((Struct.Member[])new Struct.Member[]{VkClearAttachment.__member((int)4), VkClearAttachment.__member((int)4), VkClearAttachment.__member((int)VkClearValue.SIZEOF, (int)VkClearValue.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ASPECTMASK = layout.offsetof(0);
        COLORATTACHMENT = layout.offsetof(1);
        CLEARVALUE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkClearAttachment, Buffer>
    implements NativeResource {
        private static final VkClearAttachment ELEMENT_FACTORY = VkClearAttachment.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkClearAttachment getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkImageAspectFlags")
        public int aspectMask() {
            return VkClearAttachment.naspectMask(this.address());
        }

        @NativeType(value="uint32_t")
        public int colorAttachment() {
            return VkClearAttachment.ncolorAttachment(this.address());
        }

        public VkClearValue clearValue() {
            return VkClearAttachment.nclearValue(this.address());
        }

        public Buffer aspectMask(@NativeType(value="VkImageAspectFlags") int value) {
            VkClearAttachment.naspectMask(this.address(), value);
            return this;
        }

        public Buffer colorAttachment(@NativeType(value="uint32_t") int value) {
            VkClearAttachment.ncolorAttachment(this.address(), value);
            return this;
        }

        public Buffer clearValue(VkClearValue value) {
            VkClearAttachment.nclearValue(this.address(), value);
            return this;
        }

        public Buffer clearValue(Consumer<VkClearValue> consumer) {
            consumer.accept(this.clearValue());
            return this;
        }
    }
}

