/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkCoarseSampleLocationNV
extends Struct<VkCoarseSampleLocationNV>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PIXELX;
    public static final int PIXELY;
    public static final int SAMPLE;

    protected VkCoarseSampleLocationNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkCoarseSampleLocationNV create(long address, @Nullable ByteBuffer container) {
        return new VkCoarseSampleLocationNV(address, container);
    }

    public VkCoarseSampleLocationNV(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkCoarseSampleLocationNV.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int pixelX() {
        return VkCoarseSampleLocationNV.npixelX(this.address());
    }

    @NativeType(value="uint32_t")
    public int pixelY() {
        return VkCoarseSampleLocationNV.npixelY(this.address());
    }

    @NativeType(value="uint32_t")
    public int sample() {
        return VkCoarseSampleLocationNV.nsample(this.address());
    }

    public VkCoarseSampleLocationNV pixelX(@NativeType(value="uint32_t") int value) {
        VkCoarseSampleLocationNV.npixelX(this.address(), value);
        return this;
    }

    public VkCoarseSampleLocationNV pixelY(@NativeType(value="uint32_t") int value) {
        VkCoarseSampleLocationNV.npixelY(this.address(), value);
        return this;
    }

    public VkCoarseSampleLocationNV sample(@NativeType(value="uint32_t") int value) {
        VkCoarseSampleLocationNV.nsample(this.address(), value);
        return this;
    }

    public VkCoarseSampleLocationNV set(int pixelX, int pixelY, int sample) {
        this.pixelX(pixelX);
        this.pixelY(pixelY);
        this.sample(sample);
        return this;
    }

    public VkCoarseSampleLocationNV set(VkCoarseSampleLocationNV src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkCoarseSampleLocationNV malloc() {
        return new VkCoarseSampleLocationNV(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkCoarseSampleLocationNV calloc() {
        return new VkCoarseSampleLocationNV(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkCoarseSampleLocationNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkCoarseSampleLocationNV(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkCoarseSampleLocationNV create(long address) {
        return new VkCoarseSampleLocationNV(address, null);
    }

    public static @Nullable VkCoarseSampleLocationNV createSafe(long address) {
        return address == 0L ? null : new VkCoarseSampleLocationNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkCoarseSampleLocationNV.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCoarseSampleLocationNV.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkCoarseSampleLocationNV mallocStack() {
        return VkCoarseSampleLocationNV.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkCoarseSampleLocationNV callocStack() {
        return VkCoarseSampleLocationNV.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkCoarseSampleLocationNV mallocStack(MemoryStack stack) {
        return VkCoarseSampleLocationNV.malloc(stack);
    }

    @Deprecated
    public static VkCoarseSampleLocationNV callocStack(MemoryStack stack) {
        return VkCoarseSampleLocationNV.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkCoarseSampleLocationNV.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkCoarseSampleLocationNV.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkCoarseSampleLocationNV.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkCoarseSampleLocationNV.calloc(capacity, stack);
    }

    public static VkCoarseSampleLocationNV malloc(MemoryStack stack) {
        return new VkCoarseSampleLocationNV(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkCoarseSampleLocationNV calloc(MemoryStack stack) {
        return new VkCoarseSampleLocationNV(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int npixelX(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)PIXELX));
    }

    public static int npixelY(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)PIXELY));
    }

    public static int nsample(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SAMPLE));
    }

    public static void npixelX(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)PIXELX), (int)value);
    }

    public static void npixelY(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)PIXELY), (int)value);
    }

    public static void nsample(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SAMPLE), (int)value);
    }

    static {
        Struct.Layout layout = VkCoarseSampleLocationNV.__struct((Struct.Member[])new Struct.Member[]{VkCoarseSampleLocationNV.__member((int)4), VkCoarseSampleLocationNV.__member((int)4), VkCoarseSampleLocationNV.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PIXELX = layout.offsetof(0);
        PIXELY = layout.offsetof(1);
        SAMPLE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkCoarseSampleLocationNV, Buffer>
    implements NativeResource {
        private static final VkCoarseSampleLocationNV ELEMENT_FACTORY = VkCoarseSampleLocationNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkCoarseSampleLocationNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int pixelX() {
            return VkCoarseSampleLocationNV.npixelX(this.address());
        }

        @NativeType(value="uint32_t")
        public int pixelY() {
            return VkCoarseSampleLocationNV.npixelY(this.address());
        }

        @NativeType(value="uint32_t")
        public int sample() {
            return VkCoarseSampleLocationNV.nsample(this.address());
        }

        public Buffer pixelX(@NativeType(value="uint32_t") int value) {
            VkCoarseSampleLocationNV.npixelX(this.address(), value);
            return this;
        }

        public Buffer pixelY(@NativeType(value="uint32_t") int value) {
            VkCoarseSampleLocationNV.npixelY(this.address(), value);
            return this;
        }

        public Buffer sample(@NativeType(value="uint32_t") int value) {
            VkCoarseSampleLocationNV.nsample(this.address(), value);
            return this;
        }
    }
}

