/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkBufferImageCopy2;

public class VkCopyBufferToImageInfo2
extends Struct<VkCopyBufferToImageInfo2>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SRCBUFFER;
    public static final int DSTIMAGE;
    public static final int DSTIMAGELAYOUT;
    public static final int REGIONCOUNT;
    public static final int PREGIONS;

    protected VkCopyBufferToImageInfo2(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkCopyBufferToImageInfo2 create(long address, @Nullable ByteBuffer container) {
        return new VkCopyBufferToImageInfo2(address, container);
    }

    public VkCopyBufferToImageInfo2(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkCopyBufferToImageInfo2.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkCopyBufferToImageInfo2.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkCopyBufferToImageInfo2.npNext(this.address());
    }

    @NativeType(value="VkBuffer")
    public long srcBuffer() {
        return VkCopyBufferToImageInfo2.nsrcBuffer(this.address());
    }

    @NativeType(value="VkImage")
    public long dstImage() {
        return VkCopyBufferToImageInfo2.ndstImage(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int dstImageLayout() {
        return VkCopyBufferToImageInfo2.ndstImageLayout(this.address());
    }

    @NativeType(value="uint32_t")
    public int regionCount() {
        return VkCopyBufferToImageInfo2.nregionCount(this.address());
    }

    @NativeType(value="VkBufferImageCopy2 const *")
    public VkBufferImageCopy2.Buffer pRegions() {
        return VkCopyBufferToImageInfo2.npRegions(this.address());
    }

    public VkCopyBufferToImageInfo2 sType(@NativeType(value="VkStructureType") int value) {
        VkCopyBufferToImageInfo2.nsType(this.address(), value);
        return this;
    }

    public VkCopyBufferToImageInfo2 sType$Default() {
        return this.sType(1000337002);
    }

    public VkCopyBufferToImageInfo2 pNext(@NativeType(value="void const *") long value) {
        VkCopyBufferToImageInfo2.npNext(this.address(), value);
        return this;
    }

    public VkCopyBufferToImageInfo2 srcBuffer(@NativeType(value="VkBuffer") long value) {
        VkCopyBufferToImageInfo2.nsrcBuffer(this.address(), value);
        return this;
    }

    public VkCopyBufferToImageInfo2 dstImage(@NativeType(value="VkImage") long value) {
        VkCopyBufferToImageInfo2.ndstImage(this.address(), value);
        return this;
    }

    public VkCopyBufferToImageInfo2 dstImageLayout(@NativeType(value="VkImageLayout") int value) {
        VkCopyBufferToImageInfo2.ndstImageLayout(this.address(), value);
        return this;
    }

    public VkCopyBufferToImageInfo2 pRegions(@NativeType(value="VkBufferImageCopy2 const *") VkBufferImageCopy2.Buffer value) {
        VkCopyBufferToImageInfo2.npRegions(this.address(), value);
        return this;
    }

    public VkCopyBufferToImageInfo2 set(int sType, long pNext, long srcBuffer, long dstImage, int dstImageLayout, VkBufferImageCopy2.Buffer pRegions) {
        this.sType(sType);
        this.pNext(pNext);
        this.srcBuffer(srcBuffer);
        this.dstImage(dstImage);
        this.dstImageLayout(dstImageLayout);
        this.pRegions(pRegions);
        return this;
    }

    public VkCopyBufferToImageInfo2 set(VkCopyBufferToImageInfo2 src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkCopyBufferToImageInfo2 malloc() {
        return new VkCopyBufferToImageInfo2(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkCopyBufferToImageInfo2 calloc() {
        return new VkCopyBufferToImageInfo2(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkCopyBufferToImageInfo2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkCopyBufferToImageInfo2(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkCopyBufferToImageInfo2 create(long address) {
        return new VkCopyBufferToImageInfo2(address, null);
    }

    public static @Nullable VkCopyBufferToImageInfo2 createSafe(long address) {
        return address == 0L ? null : new VkCopyBufferToImageInfo2(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkCopyBufferToImageInfo2.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCopyBufferToImageInfo2.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkCopyBufferToImageInfo2 malloc(MemoryStack stack) {
        return new VkCopyBufferToImageInfo2(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkCopyBufferToImageInfo2 calloc(MemoryStack stack) {
        return new VkCopyBufferToImageInfo2(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long nsrcBuffer(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)SRCBUFFER));
    }

    public static long ndstImage(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)DSTIMAGE));
    }

    public static int ndstImageLayout(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DSTIMAGELAYOUT));
    }

    public static int nregionCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)REGIONCOUNT));
    }

    public static VkBufferImageCopy2.Buffer npRegions(long struct) {
        return VkBufferImageCopy2.create(MemoryUtil.memGetAddress((long)(struct + (long)PREGIONS)), VkCopyBufferToImageInfo2.nregionCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nsrcBuffer(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)SRCBUFFER), (long)value);
    }

    public static void ndstImage(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)DSTIMAGE), (long)value);
    }

    public static void ndstImageLayout(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)DSTIMAGELAYOUT), (int)value);
    }

    public static void nregionCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)REGIONCOUNT), (int)value);
    }

    public static void npRegions(long struct, VkBufferImageCopy2.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PREGIONS), (long)value.address());
        VkCopyBufferToImageInfo2.nregionCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PREGIONS)));
    }

    static {
        Struct.Layout layout = VkCopyBufferToImageInfo2.__struct((Struct.Member[])new Struct.Member[]{VkCopyBufferToImageInfo2.__member((int)4), VkCopyBufferToImageInfo2.__member((int)POINTER_SIZE), VkCopyBufferToImageInfo2.__member((int)8), VkCopyBufferToImageInfo2.__member((int)8), VkCopyBufferToImageInfo2.__member((int)4), VkCopyBufferToImageInfo2.__member((int)4), VkCopyBufferToImageInfo2.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SRCBUFFER = layout.offsetof(2);
        DSTIMAGE = layout.offsetof(3);
        DSTIMAGELAYOUT = layout.offsetof(4);
        REGIONCOUNT = layout.offsetof(5);
        PREGIONS = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkCopyBufferToImageInfo2, Buffer>
    implements NativeResource {
        private static final VkCopyBufferToImageInfo2 ELEMENT_FACTORY = VkCopyBufferToImageInfo2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkCopyBufferToImageInfo2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkCopyBufferToImageInfo2.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkCopyBufferToImageInfo2.npNext(this.address());
        }

        @NativeType(value="VkBuffer")
        public long srcBuffer() {
            return VkCopyBufferToImageInfo2.nsrcBuffer(this.address());
        }

        @NativeType(value="VkImage")
        public long dstImage() {
            return VkCopyBufferToImageInfo2.ndstImage(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int dstImageLayout() {
            return VkCopyBufferToImageInfo2.ndstImageLayout(this.address());
        }

        @NativeType(value="uint32_t")
        public int regionCount() {
            return VkCopyBufferToImageInfo2.nregionCount(this.address());
        }

        @NativeType(value="VkBufferImageCopy2 const *")
        public VkBufferImageCopy2.Buffer pRegions() {
            return VkCopyBufferToImageInfo2.npRegions(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCopyBufferToImageInfo2.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000337002);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkCopyBufferToImageInfo2.npNext(this.address(), value);
            return this;
        }

        public Buffer srcBuffer(@NativeType(value="VkBuffer") long value) {
            VkCopyBufferToImageInfo2.nsrcBuffer(this.address(), value);
            return this;
        }

        public Buffer dstImage(@NativeType(value="VkImage") long value) {
            VkCopyBufferToImageInfo2.ndstImage(this.address(), value);
            return this;
        }

        public Buffer dstImageLayout(@NativeType(value="VkImageLayout") int value) {
            VkCopyBufferToImageInfo2.ndstImageLayout(this.address(), value);
            return this;
        }

        public Buffer pRegions(@NativeType(value="VkBufferImageCopy2 const *") VkBufferImageCopy2.Buffer value) {
            VkCopyBufferToImageInfo2.npRegions(this.address(), value);
            return this;
        }
    }
}

