/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkMemoryToImageCopy;

public class VkCopyMemoryToImageInfo
extends Struct<VkCopyMemoryToImageInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int DSTIMAGE;
    public static final int DSTIMAGELAYOUT;
    public static final int REGIONCOUNT;
    public static final int PREGIONS;

    protected VkCopyMemoryToImageInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkCopyMemoryToImageInfo create(long address, @Nullable ByteBuffer container) {
        return new VkCopyMemoryToImageInfo(address, container);
    }

    public VkCopyMemoryToImageInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkCopyMemoryToImageInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkCopyMemoryToImageInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkCopyMemoryToImageInfo.npNext(this.address());
    }

    @NativeType(value="VkHostImageCopyFlags")
    public int flags() {
        return VkCopyMemoryToImageInfo.nflags(this.address());
    }

    @NativeType(value="VkImage")
    public long dstImage() {
        return VkCopyMemoryToImageInfo.ndstImage(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int dstImageLayout() {
        return VkCopyMemoryToImageInfo.ndstImageLayout(this.address());
    }

    @NativeType(value="uint32_t")
    public int regionCount() {
        return VkCopyMemoryToImageInfo.nregionCount(this.address());
    }

    @NativeType(value="VkMemoryToImageCopy const *")
    public VkMemoryToImageCopy.Buffer pRegions() {
        return VkCopyMemoryToImageInfo.npRegions(this.address());
    }

    public VkCopyMemoryToImageInfo sType(@NativeType(value="VkStructureType") int value) {
        VkCopyMemoryToImageInfo.nsType(this.address(), value);
        return this;
    }

    public VkCopyMemoryToImageInfo sType$Default() {
        return this.sType(1000270005);
    }

    public VkCopyMemoryToImageInfo pNext(@NativeType(value="void const *") long value) {
        VkCopyMemoryToImageInfo.npNext(this.address(), value);
        return this;
    }

    public VkCopyMemoryToImageInfo flags(@NativeType(value="VkHostImageCopyFlags") int value) {
        VkCopyMemoryToImageInfo.nflags(this.address(), value);
        return this;
    }

    public VkCopyMemoryToImageInfo dstImage(@NativeType(value="VkImage") long value) {
        VkCopyMemoryToImageInfo.ndstImage(this.address(), value);
        return this;
    }

    public VkCopyMemoryToImageInfo dstImageLayout(@NativeType(value="VkImageLayout") int value) {
        VkCopyMemoryToImageInfo.ndstImageLayout(this.address(), value);
        return this;
    }

    public VkCopyMemoryToImageInfo pRegions(@NativeType(value="VkMemoryToImageCopy const *") VkMemoryToImageCopy.Buffer value) {
        VkCopyMemoryToImageInfo.npRegions(this.address(), value);
        return this;
    }

    public VkCopyMemoryToImageInfo set(int sType, long pNext, int flags, long dstImage, int dstImageLayout, VkMemoryToImageCopy.Buffer pRegions) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.dstImage(dstImage);
        this.dstImageLayout(dstImageLayout);
        this.pRegions(pRegions);
        return this;
    }

    public VkCopyMemoryToImageInfo set(VkCopyMemoryToImageInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkCopyMemoryToImageInfo malloc() {
        return new VkCopyMemoryToImageInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkCopyMemoryToImageInfo calloc() {
        return new VkCopyMemoryToImageInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkCopyMemoryToImageInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkCopyMemoryToImageInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkCopyMemoryToImageInfo create(long address) {
        return new VkCopyMemoryToImageInfo(address, null);
    }

    public static @Nullable VkCopyMemoryToImageInfo createSafe(long address) {
        return address == 0L ? null : new VkCopyMemoryToImageInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkCopyMemoryToImageInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCopyMemoryToImageInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkCopyMemoryToImageInfo malloc(MemoryStack stack) {
        return new VkCopyMemoryToImageInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkCopyMemoryToImageInfo calloc(MemoryStack stack) {
        return new VkCopyMemoryToImageInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FLAGS));
    }

    public static long ndstImage(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)DSTIMAGE));
    }

    public static int ndstImageLayout(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DSTIMAGELAYOUT));
    }

    public static int nregionCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)REGIONCOUNT));
    }

    public static VkMemoryToImageCopy.Buffer npRegions(long struct) {
        return VkMemoryToImageCopy.create(MemoryUtil.memGetAddress((long)(struct + (long)PREGIONS)), VkCopyMemoryToImageInfo.nregionCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FLAGS), (int)value);
    }

    public static void ndstImage(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)DSTIMAGE), (long)value);
    }

    public static void ndstImageLayout(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)DSTIMAGELAYOUT), (int)value);
    }

    public static void nregionCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)REGIONCOUNT), (int)value);
    }

    public static void npRegions(long struct, VkMemoryToImageCopy.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PREGIONS), (long)value.address());
        VkCopyMemoryToImageInfo.nregionCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        int regionCount = VkCopyMemoryToImageInfo.nregionCount(struct);
        long pRegions = MemoryUtil.memGetAddress((long)(struct + (long)PREGIONS));
        Checks.check((long)pRegions);
        VkCopyMemoryToImageInfo.validate((long)pRegions, (int)regionCount, (int)VkMemoryToImageCopy.SIZEOF, VkMemoryToImageCopy::validate);
    }

    static {
        Struct.Layout layout = VkCopyMemoryToImageInfo.__struct((Struct.Member[])new Struct.Member[]{VkCopyMemoryToImageInfo.__member((int)4), VkCopyMemoryToImageInfo.__member((int)POINTER_SIZE), VkCopyMemoryToImageInfo.__member((int)4), VkCopyMemoryToImageInfo.__member((int)8), VkCopyMemoryToImageInfo.__member((int)4), VkCopyMemoryToImageInfo.__member((int)4), VkCopyMemoryToImageInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        DSTIMAGE = layout.offsetof(3);
        DSTIMAGELAYOUT = layout.offsetof(4);
        REGIONCOUNT = layout.offsetof(5);
        PREGIONS = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkCopyMemoryToImageInfo, Buffer>
    implements NativeResource {
        private static final VkCopyMemoryToImageInfo ELEMENT_FACTORY = VkCopyMemoryToImageInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkCopyMemoryToImageInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkCopyMemoryToImageInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkCopyMemoryToImageInfo.npNext(this.address());
        }

        @NativeType(value="VkHostImageCopyFlags")
        public int flags() {
            return VkCopyMemoryToImageInfo.nflags(this.address());
        }

        @NativeType(value="VkImage")
        public long dstImage() {
            return VkCopyMemoryToImageInfo.ndstImage(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int dstImageLayout() {
            return VkCopyMemoryToImageInfo.ndstImageLayout(this.address());
        }

        @NativeType(value="uint32_t")
        public int regionCount() {
            return VkCopyMemoryToImageInfo.nregionCount(this.address());
        }

        @NativeType(value="VkMemoryToImageCopy const *")
        public VkMemoryToImageCopy.Buffer pRegions() {
            return VkCopyMemoryToImageInfo.npRegions(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCopyMemoryToImageInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000270005);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkCopyMemoryToImageInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkHostImageCopyFlags") int value) {
            VkCopyMemoryToImageInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer dstImage(@NativeType(value="VkImage") long value) {
            VkCopyMemoryToImageInfo.ndstImage(this.address(), value);
            return this;
        }

        public Buffer dstImageLayout(@NativeType(value="VkImageLayout") int value) {
            VkCopyMemoryToImageInfo.ndstImageLayout(this.address(), value);
            return this;
        }

        public Buffer pRegions(@NativeType(value="VkMemoryToImageCopy const *") VkMemoryToImageCopy.Buffer value) {
            VkCopyMemoryToImageInfo.npRegions(this.address(), value);
            return this;
        }
    }
}

