/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDeviceOrHostAddressConstKHR;

public class VkCopyMemoryToMicromapInfoEXT
extends Struct<VkCopyMemoryToMicromapInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SRC;
    public static final int DST;
    public static final int MODE;

    protected VkCopyMemoryToMicromapInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkCopyMemoryToMicromapInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkCopyMemoryToMicromapInfoEXT(address, container);
    }

    public VkCopyMemoryToMicromapInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkCopyMemoryToMicromapInfoEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkCopyMemoryToMicromapInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkCopyMemoryToMicromapInfoEXT.npNext(this.address());
    }

    public VkDeviceOrHostAddressConstKHR src() {
        return VkCopyMemoryToMicromapInfoEXT.nsrc(this.address());
    }

    @NativeType(value="VkMicromapEXT")
    public long dst() {
        return VkCopyMemoryToMicromapInfoEXT.ndst(this.address());
    }

    @NativeType(value="VkCopyMicromapModeEXT")
    public int mode() {
        return VkCopyMemoryToMicromapInfoEXT.nmode(this.address());
    }

    public VkCopyMemoryToMicromapInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkCopyMemoryToMicromapInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkCopyMemoryToMicromapInfoEXT sType$Default() {
        return this.sType(1000396004);
    }

    public VkCopyMemoryToMicromapInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkCopyMemoryToMicromapInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkCopyMemoryToMicromapInfoEXT src(VkDeviceOrHostAddressConstKHR value) {
        VkCopyMemoryToMicromapInfoEXT.nsrc(this.address(), value);
        return this;
    }

    public VkCopyMemoryToMicromapInfoEXT src(Consumer<VkDeviceOrHostAddressConstKHR> consumer) {
        consumer.accept(this.src());
        return this;
    }

    public VkCopyMemoryToMicromapInfoEXT dst(@NativeType(value="VkMicromapEXT") long value) {
        VkCopyMemoryToMicromapInfoEXT.ndst(this.address(), value);
        return this;
    }

    public VkCopyMemoryToMicromapInfoEXT mode(@NativeType(value="VkCopyMicromapModeEXT") int value) {
        VkCopyMemoryToMicromapInfoEXT.nmode(this.address(), value);
        return this;
    }

    public VkCopyMemoryToMicromapInfoEXT set(int sType, long pNext, VkDeviceOrHostAddressConstKHR src, long dst, int mode) {
        this.sType(sType);
        this.pNext(pNext);
        this.src(src);
        this.dst(dst);
        this.mode(mode);
        return this;
    }

    public VkCopyMemoryToMicromapInfoEXT set(VkCopyMemoryToMicromapInfoEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkCopyMemoryToMicromapInfoEXT malloc() {
        return new VkCopyMemoryToMicromapInfoEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkCopyMemoryToMicromapInfoEXT calloc() {
        return new VkCopyMemoryToMicromapInfoEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkCopyMemoryToMicromapInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkCopyMemoryToMicromapInfoEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkCopyMemoryToMicromapInfoEXT create(long address) {
        return new VkCopyMemoryToMicromapInfoEXT(address, null);
    }

    public static @Nullable VkCopyMemoryToMicromapInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkCopyMemoryToMicromapInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkCopyMemoryToMicromapInfoEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCopyMemoryToMicromapInfoEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkCopyMemoryToMicromapInfoEXT malloc(MemoryStack stack) {
        return new VkCopyMemoryToMicromapInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkCopyMemoryToMicromapInfoEXT calloc(MemoryStack stack) {
        return new VkCopyMemoryToMicromapInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static VkDeviceOrHostAddressConstKHR nsrc(long struct) {
        return VkDeviceOrHostAddressConstKHR.create(struct + (long)SRC);
    }

    public static long ndst(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)DST));
    }

    public static int nmode(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MODE));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nsrc(long struct, VkDeviceOrHostAddressConstKHR value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SRC), (long)VkDeviceOrHostAddressConstKHR.SIZEOF);
    }

    public static void ndst(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)DST), (long)value);
    }

    public static void nmode(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MODE), (int)value);
    }

    static {
        Struct.Layout layout = VkCopyMemoryToMicromapInfoEXT.__struct((Struct.Member[])new Struct.Member[]{VkCopyMemoryToMicromapInfoEXT.__member((int)4), VkCopyMemoryToMicromapInfoEXT.__member((int)POINTER_SIZE), VkCopyMemoryToMicromapInfoEXT.__member((int)VkDeviceOrHostAddressConstKHR.SIZEOF, (int)VkDeviceOrHostAddressConstKHR.ALIGNOF), VkCopyMemoryToMicromapInfoEXT.__member((int)8), VkCopyMemoryToMicromapInfoEXT.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SRC = layout.offsetof(2);
        DST = layout.offsetof(3);
        MODE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkCopyMemoryToMicromapInfoEXT, Buffer>
    implements NativeResource {
        private static final VkCopyMemoryToMicromapInfoEXT ELEMENT_FACTORY = VkCopyMemoryToMicromapInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkCopyMemoryToMicromapInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkCopyMemoryToMicromapInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkCopyMemoryToMicromapInfoEXT.npNext(this.address());
        }

        public VkDeviceOrHostAddressConstKHR src() {
            return VkCopyMemoryToMicromapInfoEXT.nsrc(this.address());
        }

        @NativeType(value="VkMicromapEXT")
        public long dst() {
            return VkCopyMemoryToMicromapInfoEXT.ndst(this.address());
        }

        @NativeType(value="VkCopyMicromapModeEXT")
        public int mode() {
            return VkCopyMemoryToMicromapInfoEXT.nmode(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCopyMemoryToMicromapInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000396004);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkCopyMemoryToMicromapInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer src(VkDeviceOrHostAddressConstKHR value) {
            VkCopyMemoryToMicromapInfoEXT.nsrc(this.address(), value);
            return this;
        }

        public Buffer src(Consumer<VkDeviceOrHostAddressConstKHR> consumer) {
            consumer.accept(this.src());
            return this;
        }

        public Buffer dst(@NativeType(value="VkMicromapEXT") long value) {
            VkCopyMemoryToMicromapInfoEXT.ndst(this.address(), value);
            return this;
        }

        public Buffer mode(@NativeType(value="VkCopyMicromapModeEXT") int value) {
            VkCopyMemoryToMicromapInfoEXT.nmode(this.address(), value);
            return this;
        }
    }
}

