/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDeviceOrHostAddressKHR;

public class VkCopyMicromapToMemoryInfoEXT
extends Struct<VkCopyMicromapToMemoryInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SRC;
    public static final int DST;
    public static final int MODE;

    protected VkCopyMicromapToMemoryInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkCopyMicromapToMemoryInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkCopyMicromapToMemoryInfoEXT(address, container);
    }

    public VkCopyMicromapToMemoryInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkCopyMicromapToMemoryInfoEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkCopyMicromapToMemoryInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkCopyMicromapToMemoryInfoEXT.npNext(this.address());
    }

    @NativeType(value="VkMicromapEXT")
    public long src() {
        return VkCopyMicromapToMemoryInfoEXT.nsrc(this.address());
    }

    public VkDeviceOrHostAddressKHR dst() {
        return VkCopyMicromapToMemoryInfoEXT.ndst(this.address());
    }

    @NativeType(value="VkCopyMicromapModeEXT")
    public int mode() {
        return VkCopyMicromapToMemoryInfoEXT.nmode(this.address());
    }

    public VkCopyMicromapToMemoryInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkCopyMicromapToMemoryInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkCopyMicromapToMemoryInfoEXT sType$Default() {
        return this.sType(1000396003);
    }

    public VkCopyMicromapToMemoryInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkCopyMicromapToMemoryInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkCopyMicromapToMemoryInfoEXT src(@NativeType(value="VkMicromapEXT") long value) {
        VkCopyMicromapToMemoryInfoEXT.nsrc(this.address(), value);
        return this;
    }

    public VkCopyMicromapToMemoryInfoEXT dst(VkDeviceOrHostAddressKHR value) {
        VkCopyMicromapToMemoryInfoEXT.ndst(this.address(), value);
        return this;
    }

    public VkCopyMicromapToMemoryInfoEXT dst(Consumer<VkDeviceOrHostAddressKHR> consumer) {
        consumer.accept(this.dst());
        return this;
    }

    public VkCopyMicromapToMemoryInfoEXT mode(@NativeType(value="VkCopyMicromapModeEXT") int value) {
        VkCopyMicromapToMemoryInfoEXT.nmode(this.address(), value);
        return this;
    }

    public VkCopyMicromapToMemoryInfoEXT set(int sType, long pNext, long src, VkDeviceOrHostAddressKHR dst, int mode) {
        this.sType(sType);
        this.pNext(pNext);
        this.src(src);
        this.dst(dst);
        this.mode(mode);
        return this;
    }

    public VkCopyMicromapToMemoryInfoEXT set(VkCopyMicromapToMemoryInfoEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkCopyMicromapToMemoryInfoEXT malloc() {
        return new VkCopyMicromapToMemoryInfoEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkCopyMicromapToMemoryInfoEXT calloc() {
        return new VkCopyMicromapToMemoryInfoEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkCopyMicromapToMemoryInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkCopyMicromapToMemoryInfoEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkCopyMicromapToMemoryInfoEXT create(long address) {
        return new VkCopyMicromapToMemoryInfoEXT(address, null);
    }

    public static @Nullable VkCopyMicromapToMemoryInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkCopyMicromapToMemoryInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkCopyMicromapToMemoryInfoEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCopyMicromapToMemoryInfoEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkCopyMicromapToMemoryInfoEXT malloc(MemoryStack stack) {
        return new VkCopyMicromapToMemoryInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkCopyMicromapToMemoryInfoEXT calloc(MemoryStack stack) {
        return new VkCopyMicromapToMemoryInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long nsrc(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)SRC));
    }

    public static VkDeviceOrHostAddressKHR ndst(long struct) {
        return VkDeviceOrHostAddressKHR.create(struct + (long)DST);
    }

    public static int nmode(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MODE));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nsrc(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)SRC), (long)value);
    }

    public static void ndst(long struct, VkDeviceOrHostAddressKHR value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)DST), (long)VkDeviceOrHostAddressKHR.SIZEOF);
    }

    public static void nmode(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MODE), (int)value);
    }

    static {
        Struct.Layout layout = VkCopyMicromapToMemoryInfoEXT.__struct((Struct.Member[])new Struct.Member[]{VkCopyMicromapToMemoryInfoEXT.__member((int)4), VkCopyMicromapToMemoryInfoEXT.__member((int)POINTER_SIZE), VkCopyMicromapToMemoryInfoEXT.__member((int)8), VkCopyMicromapToMemoryInfoEXT.__member((int)VkDeviceOrHostAddressKHR.SIZEOF, (int)VkDeviceOrHostAddressKHR.ALIGNOF), VkCopyMicromapToMemoryInfoEXT.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SRC = layout.offsetof(2);
        DST = layout.offsetof(3);
        MODE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkCopyMicromapToMemoryInfoEXT, Buffer>
    implements NativeResource {
        private static final VkCopyMicromapToMemoryInfoEXT ELEMENT_FACTORY = VkCopyMicromapToMemoryInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkCopyMicromapToMemoryInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkCopyMicromapToMemoryInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkCopyMicromapToMemoryInfoEXT.npNext(this.address());
        }

        @NativeType(value="VkMicromapEXT")
        public long src() {
            return VkCopyMicromapToMemoryInfoEXT.nsrc(this.address());
        }

        public VkDeviceOrHostAddressKHR dst() {
            return VkCopyMicromapToMemoryInfoEXT.ndst(this.address());
        }

        @NativeType(value="VkCopyMicromapModeEXT")
        public int mode() {
            return VkCopyMicromapToMemoryInfoEXT.nmode(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCopyMicromapToMemoryInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000396003);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkCopyMicromapToMemoryInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer src(@NativeType(value="VkMicromapEXT") long value) {
            VkCopyMicromapToMemoryInfoEXT.nsrc(this.address(), value);
            return this;
        }

        public Buffer dst(VkDeviceOrHostAddressKHR value) {
            VkCopyMicromapToMemoryInfoEXT.ndst(this.address(), value);
            return this;
        }

        public Buffer dst(Consumer<VkDeviceOrHostAddressKHR> consumer) {
            consumer.accept(this.dst());
            return this;
        }

        public Buffer mode(@NativeType(value="VkCopyMicromapModeEXT") int value) {
            VkCopyMicromapToMemoryInfoEXT.nmode(this.address(), value);
            return this;
        }
    }
}

