/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkCuLaunchInfoNVX
extends Struct<VkCuLaunchInfoNVX>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FUNCTION;
    public static final int GRIDDIMX;
    public static final int GRIDDIMY;
    public static final int GRIDDIMZ;
    public static final int BLOCKDIMX;
    public static final int BLOCKDIMY;
    public static final int BLOCKDIMZ;
    public static final int SHAREDMEMBYTES;
    public static final int PARAMCOUNT;
    public static final int PPARAMS;
    public static final int EXTRACOUNT;
    public static final int PEXTRAS;

    protected VkCuLaunchInfoNVX(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkCuLaunchInfoNVX create(long address, @Nullable ByteBuffer container) {
        return new VkCuLaunchInfoNVX(address, container);
    }

    public VkCuLaunchInfoNVX(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkCuLaunchInfoNVX.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkCuLaunchInfoNVX.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkCuLaunchInfoNVX.npNext(this.address());
    }

    @NativeType(value="VkCuFunctionNVX")
    public long function() {
        return VkCuLaunchInfoNVX.nfunction(this.address());
    }

    @NativeType(value="uint32_t")
    public int gridDimX() {
        return VkCuLaunchInfoNVX.ngridDimX(this.address());
    }

    @NativeType(value="uint32_t")
    public int gridDimY() {
        return VkCuLaunchInfoNVX.ngridDimY(this.address());
    }

    @NativeType(value="uint32_t")
    public int gridDimZ() {
        return VkCuLaunchInfoNVX.ngridDimZ(this.address());
    }

    @NativeType(value="uint32_t")
    public int blockDimX() {
        return VkCuLaunchInfoNVX.nblockDimX(this.address());
    }

    @NativeType(value="uint32_t")
    public int blockDimY() {
        return VkCuLaunchInfoNVX.nblockDimY(this.address());
    }

    @NativeType(value="uint32_t")
    public int blockDimZ() {
        return VkCuLaunchInfoNVX.nblockDimZ(this.address());
    }

    @NativeType(value="uint32_t")
    public int sharedMemBytes() {
        return VkCuLaunchInfoNVX.nsharedMemBytes(this.address());
    }

    @NativeType(value="size_t")
    public long paramCount() {
        return VkCuLaunchInfoNVX.nparamCount(this.address());
    }

    @NativeType(value="void const * const *")
    public @Nullable PointerBuffer pParams() {
        return VkCuLaunchInfoNVX.npParams(this.address());
    }

    @NativeType(value="size_t")
    public long extraCount() {
        return VkCuLaunchInfoNVX.nextraCount(this.address());
    }

    @NativeType(value="void const * const *")
    public @Nullable PointerBuffer pExtras() {
        return VkCuLaunchInfoNVX.npExtras(this.address());
    }

    public VkCuLaunchInfoNVX sType(@NativeType(value="VkStructureType") int value) {
        VkCuLaunchInfoNVX.nsType(this.address(), value);
        return this;
    }

    public VkCuLaunchInfoNVX sType$Default() {
        return this.sType(1000029002);
    }

    public VkCuLaunchInfoNVX pNext(@NativeType(value="void const *") long value) {
        VkCuLaunchInfoNVX.npNext(this.address(), value);
        return this;
    }

    public VkCuLaunchInfoNVX function(@NativeType(value="VkCuFunctionNVX") long value) {
        VkCuLaunchInfoNVX.nfunction(this.address(), value);
        return this;
    }

    public VkCuLaunchInfoNVX gridDimX(@NativeType(value="uint32_t") int value) {
        VkCuLaunchInfoNVX.ngridDimX(this.address(), value);
        return this;
    }

    public VkCuLaunchInfoNVX gridDimY(@NativeType(value="uint32_t") int value) {
        VkCuLaunchInfoNVX.ngridDimY(this.address(), value);
        return this;
    }

    public VkCuLaunchInfoNVX gridDimZ(@NativeType(value="uint32_t") int value) {
        VkCuLaunchInfoNVX.ngridDimZ(this.address(), value);
        return this;
    }

    public VkCuLaunchInfoNVX blockDimX(@NativeType(value="uint32_t") int value) {
        VkCuLaunchInfoNVX.nblockDimX(this.address(), value);
        return this;
    }

    public VkCuLaunchInfoNVX blockDimY(@NativeType(value="uint32_t") int value) {
        VkCuLaunchInfoNVX.nblockDimY(this.address(), value);
        return this;
    }

    public VkCuLaunchInfoNVX blockDimZ(@NativeType(value="uint32_t") int value) {
        VkCuLaunchInfoNVX.nblockDimZ(this.address(), value);
        return this;
    }

    public VkCuLaunchInfoNVX sharedMemBytes(@NativeType(value="uint32_t") int value) {
        VkCuLaunchInfoNVX.nsharedMemBytes(this.address(), value);
        return this;
    }

    public VkCuLaunchInfoNVX pParams(@NativeType(value="void const * const *") @Nullable PointerBuffer value) {
        VkCuLaunchInfoNVX.npParams(this.address(), value);
        return this;
    }

    public VkCuLaunchInfoNVX pExtras(@NativeType(value="void const * const *") @Nullable PointerBuffer value) {
        VkCuLaunchInfoNVX.npExtras(this.address(), value);
        return this;
    }

    public VkCuLaunchInfoNVX set(int sType, long pNext, long function, int gridDimX, int gridDimY, int gridDimZ, int blockDimX, int blockDimY, int blockDimZ, int sharedMemBytes, @Nullable PointerBuffer pParams, @Nullable PointerBuffer pExtras) {
        this.sType(sType);
        this.pNext(pNext);
        this.function(function);
        this.gridDimX(gridDimX);
        this.gridDimY(gridDimY);
        this.gridDimZ(gridDimZ);
        this.blockDimX(blockDimX);
        this.blockDimY(blockDimY);
        this.blockDimZ(blockDimZ);
        this.sharedMemBytes(sharedMemBytes);
        this.pParams(pParams);
        this.pExtras(pExtras);
        return this;
    }

    public VkCuLaunchInfoNVX set(VkCuLaunchInfoNVX src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkCuLaunchInfoNVX malloc() {
        return new VkCuLaunchInfoNVX(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkCuLaunchInfoNVX calloc() {
        return new VkCuLaunchInfoNVX(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkCuLaunchInfoNVX create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkCuLaunchInfoNVX(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkCuLaunchInfoNVX create(long address) {
        return new VkCuLaunchInfoNVX(address, null);
    }

    public static @Nullable VkCuLaunchInfoNVX createSafe(long address) {
        return address == 0L ? null : new VkCuLaunchInfoNVX(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkCuLaunchInfoNVX.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCuLaunchInfoNVX.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkCuLaunchInfoNVX malloc(MemoryStack stack) {
        return new VkCuLaunchInfoNVX(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkCuLaunchInfoNVX calloc(MemoryStack stack) {
        return new VkCuLaunchInfoNVX(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long nfunction(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)FUNCTION));
    }

    public static int ngridDimX(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)GRIDDIMX));
    }

    public static int ngridDimY(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)GRIDDIMY));
    }

    public static int ngridDimZ(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)GRIDDIMZ));
    }

    public static int nblockDimX(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)BLOCKDIMX));
    }

    public static int nblockDimY(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)BLOCKDIMY));
    }

    public static int nblockDimZ(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)BLOCKDIMZ));
    }

    public static int nsharedMemBytes(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SHAREDMEMBYTES));
    }

    public static long nparamCount(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PARAMCOUNT));
    }

    public static @Nullable PointerBuffer npParams(long struct) {
        return MemoryUtil.memPointerBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PPARAMS)), (int)((int)VkCuLaunchInfoNVX.nparamCount(struct)));
    }

    public static long nextraCount(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)EXTRACOUNT));
    }

    public static @Nullable PointerBuffer npExtras(long struct) {
        return MemoryUtil.memPointerBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PEXTRAS)), (int)((int)VkCuLaunchInfoNVX.nextraCount(struct)));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nfunction(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)FUNCTION), (long)value);
    }

    public static void ngridDimX(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)GRIDDIMX), (int)value);
    }

    public static void ngridDimY(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)GRIDDIMY), (int)value);
    }

    public static void ngridDimZ(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)GRIDDIMZ), (int)value);
    }

    public static void nblockDimX(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)BLOCKDIMX), (int)value);
    }

    public static void nblockDimY(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)BLOCKDIMY), (int)value);
    }

    public static void nblockDimZ(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)BLOCKDIMZ), (int)value);
    }

    public static void nsharedMemBytes(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SHAREDMEMBYTES), (int)value);
    }

    public static void nparamCount(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PARAMCOUNT), (long)value);
    }

    public static void npParams(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PPARAMS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkCuLaunchInfoNVX.nparamCount(struct, value == null ? 0L : (long)value.remaining());
    }

    public static void nextraCount(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)EXTRACOUNT), (long)value);
    }

    public static void npExtras(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PEXTRAS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkCuLaunchInfoNVX.nextraCount(struct, value == null ? 0L : (long)value.remaining());
    }

    public static void validate(long struct) {
        if (VkCuLaunchInfoNVX.nparamCount(struct) != 0L) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PPARAMS)));
        }
        if (VkCuLaunchInfoNVX.nextraCount(struct) != 0L) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PEXTRAS)));
        }
    }

    static {
        Struct.Layout layout = VkCuLaunchInfoNVX.__struct((Struct.Member[])new Struct.Member[]{VkCuLaunchInfoNVX.__member((int)4), VkCuLaunchInfoNVX.__member((int)POINTER_SIZE), VkCuLaunchInfoNVX.__member((int)8), VkCuLaunchInfoNVX.__member((int)4), VkCuLaunchInfoNVX.__member((int)4), VkCuLaunchInfoNVX.__member((int)4), VkCuLaunchInfoNVX.__member((int)4), VkCuLaunchInfoNVX.__member((int)4), VkCuLaunchInfoNVX.__member((int)4), VkCuLaunchInfoNVX.__member((int)4), VkCuLaunchInfoNVX.__member((int)POINTER_SIZE), VkCuLaunchInfoNVX.__member((int)POINTER_SIZE), VkCuLaunchInfoNVX.__member((int)POINTER_SIZE), VkCuLaunchInfoNVX.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FUNCTION = layout.offsetof(2);
        GRIDDIMX = layout.offsetof(3);
        GRIDDIMY = layout.offsetof(4);
        GRIDDIMZ = layout.offsetof(5);
        BLOCKDIMX = layout.offsetof(6);
        BLOCKDIMY = layout.offsetof(7);
        BLOCKDIMZ = layout.offsetof(8);
        SHAREDMEMBYTES = layout.offsetof(9);
        PARAMCOUNT = layout.offsetof(10);
        PPARAMS = layout.offsetof(11);
        EXTRACOUNT = layout.offsetof(12);
        PEXTRAS = layout.offsetof(13);
    }

    public static class Buffer
    extends StructBuffer<VkCuLaunchInfoNVX, Buffer>
    implements NativeResource {
        private static final VkCuLaunchInfoNVX ELEMENT_FACTORY = VkCuLaunchInfoNVX.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkCuLaunchInfoNVX getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkCuLaunchInfoNVX.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkCuLaunchInfoNVX.npNext(this.address());
        }

        @NativeType(value="VkCuFunctionNVX")
        public long function() {
            return VkCuLaunchInfoNVX.nfunction(this.address());
        }

        @NativeType(value="uint32_t")
        public int gridDimX() {
            return VkCuLaunchInfoNVX.ngridDimX(this.address());
        }

        @NativeType(value="uint32_t")
        public int gridDimY() {
            return VkCuLaunchInfoNVX.ngridDimY(this.address());
        }

        @NativeType(value="uint32_t")
        public int gridDimZ() {
            return VkCuLaunchInfoNVX.ngridDimZ(this.address());
        }

        @NativeType(value="uint32_t")
        public int blockDimX() {
            return VkCuLaunchInfoNVX.nblockDimX(this.address());
        }

        @NativeType(value="uint32_t")
        public int blockDimY() {
            return VkCuLaunchInfoNVX.nblockDimY(this.address());
        }

        @NativeType(value="uint32_t")
        public int blockDimZ() {
            return VkCuLaunchInfoNVX.nblockDimZ(this.address());
        }

        @NativeType(value="uint32_t")
        public int sharedMemBytes() {
            return VkCuLaunchInfoNVX.nsharedMemBytes(this.address());
        }

        @NativeType(value="size_t")
        public long paramCount() {
            return VkCuLaunchInfoNVX.nparamCount(this.address());
        }

        @NativeType(value="void const * const *")
        public @Nullable PointerBuffer pParams() {
            return VkCuLaunchInfoNVX.npParams(this.address());
        }

        @NativeType(value="size_t")
        public long extraCount() {
            return VkCuLaunchInfoNVX.nextraCount(this.address());
        }

        @NativeType(value="void const * const *")
        public @Nullable PointerBuffer pExtras() {
            return VkCuLaunchInfoNVX.npExtras(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCuLaunchInfoNVX.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000029002);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkCuLaunchInfoNVX.npNext(this.address(), value);
            return this;
        }

        public Buffer function(@NativeType(value="VkCuFunctionNVX") long value) {
            VkCuLaunchInfoNVX.nfunction(this.address(), value);
            return this;
        }

        public Buffer gridDimX(@NativeType(value="uint32_t") int value) {
            VkCuLaunchInfoNVX.ngridDimX(this.address(), value);
            return this;
        }

        public Buffer gridDimY(@NativeType(value="uint32_t") int value) {
            VkCuLaunchInfoNVX.ngridDimY(this.address(), value);
            return this;
        }

        public Buffer gridDimZ(@NativeType(value="uint32_t") int value) {
            VkCuLaunchInfoNVX.ngridDimZ(this.address(), value);
            return this;
        }

        public Buffer blockDimX(@NativeType(value="uint32_t") int value) {
            VkCuLaunchInfoNVX.nblockDimX(this.address(), value);
            return this;
        }

        public Buffer blockDimY(@NativeType(value="uint32_t") int value) {
            VkCuLaunchInfoNVX.nblockDimY(this.address(), value);
            return this;
        }

        public Buffer blockDimZ(@NativeType(value="uint32_t") int value) {
            VkCuLaunchInfoNVX.nblockDimZ(this.address(), value);
            return this;
        }

        public Buffer sharedMemBytes(@NativeType(value="uint32_t") int value) {
            VkCuLaunchInfoNVX.nsharedMemBytes(this.address(), value);
            return this;
        }

        public Buffer pParams(@NativeType(value="void const * const *") @Nullable PointerBuffer value) {
            VkCuLaunchInfoNVX.npParams(this.address(), value);
            return this;
        }

        public Buffer pExtras(@NativeType(value="void const * const *") @Nullable PointerBuffer value) {
            VkCuLaunchInfoNVX.npExtras(this.address(), value);
            return this;
        }
    }
}

