/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkCudaFunctionCreateInfoNV
extends Struct<VkCudaFunctionCreateInfoNV>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int MODULE;
    public static final int PNAME;

    protected VkCudaFunctionCreateInfoNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkCudaFunctionCreateInfoNV create(long address, @Nullable ByteBuffer container) {
        return new VkCudaFunctionCreateInfoNV(address, container);
    }

    public VkCudaFunctionCreateInfoNV(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkCudaFunctionCreateInfoNV.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkCudaFunctionCreateInfoNV.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkCudaFunctionCreateInfoNV.npNext(this.address());
    }

    @NativeType(value="VkCudaModuleNV")
    public long module() {
        return VkCudaFunctionCreateInfoNV.nmodule(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer pName() {
        return VkCudaFunctionCreateInfoNV.npName(this.address());
    }

    @NativeType(value="char const *")
    public String pNameString() {
        return VkCudaFunctionCreateInfoNV.npNameString(this.address());
    }

    public VkCudaFunctionCreateInfoNV sType(@NativeType(value="VkStructureType") int value) {
        VkCudaFunctionCreateInfoNV.nsType(this.address(), value);
        return this;
    }

    public VkCudaFunctionCreateInfoNV sType$Default() {
        return this.sType(1000307001);
    }

    public VkCudaFunctionCreateInfoNV pNext(@NativeType(value="void const *") long value) {
        VkCudaFunctionCreateInfoNV.npNext(this.address(), value);
        return this;
    }

    public VkCudaFunctionCreateInfoNV module(@NativeType(value="VkCudaModuleNV") long value) {
        VkCudaFunctionCreateInfoNV.nmodule(this.address(), value);
        return this;
    }

    public VkCudaFunctionCreateInfoNV pName(@NativeType(value="char const *") ByteBuffer value) {
        VkCudaFunctionCreateInfoNV.npName(this.address(), value);
        return this;
    }

    public VkCudaFunctionCreateInfoNV set(int sType, long pNext, long module, ByteBuffer pName) {
        this.sType(sType);
        this.pNext(pNext);
        this.module(module);
        this.pName(pName);
        return this;
    }

    public VkCudaFunctionCreateInfoNV set(VkCudaFunctionCreateInfoNV src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkCudaFunctionCreateInfoNV malloc() {
        return new VkCudaFunctionCreateInfoNV(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkCudaFunctionCreateInfoNV calloc() {
        return new VkCudaFunctionCreateInfoNV(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkCudaFunctionCreateInfoNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkCudaFunctionCreateInfoNV(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkCudaFunctionCreateInfoNV create(long address) {
        return new VkCudaFunctionCreateInfoNV(address, null);
    }

    public static @Nullable VkCudaFunctionCreateInfoNV createSafe(long address) {
        return address == 0L ? null : new VkCudaFunctionCreateInfoNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkCudaFunctionCreateInfoNV.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCudaFunctionCreateInfoNV.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkCudaFunctionCreateInfoNV malloc(MemoryStack stack) {
        return new VkCudaFunctionCreateInfoNV(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkCudaFunctionCreateInfoNV calloc(MemoryStack stack) {
        return new VkCudaFunctionCreateInfoNV(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long nmodule(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)MODULE));
    }

    public static ByteBuffer npName(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)PNAME)));
    }

    public static String npNameString(long struct) {
        return MemoryUtil.memUTF8((long)MemoryUtil.memGetAddress((long)(struct + (long)PNAME)));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nmodule(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)MODULE), (long)value);
    }

    public static void npName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)PNAME), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PNAME)));
    }

    static {
        Struct.Layout layout = VkCudaFunctionCreateInfoNV.__struct((Struct.Member[])new Struct.Member[]{VkCudaFunctionCreateInfoNV.__member((int)4), VkCudaFunctionCreateInfoNV.__member((int)POINTER_SIZE), VkCudaFunctionCreateInfoNV.__member((int)8), VkCudaFunctionCreateInfoNV.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        MODULE = layout.offsetof(2);
        PNAME = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkCudaFunctionCreateInfoNV, Buffer>
    implements NativeResource {
        private static final VkCudaFunctionCreateInfoNV ELEMENT_FACTORY = VkCudaFunctionCreateInfoNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkCudaFunctionCreateInfoNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkCudaFunctionCreateInfoNV.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkCudaFunctionCreateInfoNV.npNext(this.address());
        }

        @NativeType(value="VkCudaModuleNV")
        public long module() {
            return VkCudaFunctionCreateInfoNV.nmodule(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer pName() {
            return VkCudaFunctionCreateInfoNV.npName(this.address());
        }

        @NativeType(value="char const *")
        public String pNameString() {
            return VkCudaFunctionCreateInfoNV.npNameString(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCudaFunctionCreateInfoNV.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000307001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkCudaFunctionCreateInfoNV.npNext(this.address(), value);
            return this;
        }

        public Buffer module(@NativeType(value="VkCudaModuleNV") long value) {
            VkCudaFunctionCreateInfoNV.nmodule(this.address(), value);
            return this;
        }

        public Buffer pName(@NativeType(value="char const *") ByteBuffer value) {
            VkCudaFunctionCreateInfoNV.npName(this.address(), value);
            return this;
        }
    }
}

