/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkCudaLaunchInfoNV
extends Struct<VkCudaLaunchInfoNV>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FUNCTION;
    public static final int GRIDDIMX;
    public static final int GRIDDIMY;
    public static final int GRIDDIMZ;
    public static final int BLOCKDIMX;
    public static final int BLOCKDIMY;
    public static final int BLOCKDIMZ;
    public static final int SHAREDMEMBYTES;
    public static final int PARAMCOUNT;
    public static final int PPARAMS;
    public static final int EXTRACOUNT;
    public static final int PEXTRAS;

    protected VkCudaLaunchInfoNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkCudaLaunchInfoNV create(long address, @Nullable ByteBuffer container) {
        return new VkCudaLaunchInfoNV(address, container);
    }

    public VkCudaLaunchInfoNV(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkCudaLaunchInfoNV.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkCudaLaunchInfoNV.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkCudaLaunchInfoNV.npNext(this.address());
    }

    @NativeType(value="VkCudaFunctionNV")
    public long function() {
        return VkCudaLaunchInfoNV.nfunction(this.address());
    }

    @NativeType(value="uint32_t")
    public int gridDimX() {
        return VkCudaLaunchInfoNV.ngridDimX(this.address());
    }

    @NativeType(value="uint32_t")
    public int gridDimY() {
        return VkCudaLaunchInfoNV.ngridDimY(this.address());
    }

    @NativeType(value="uint32_t")
    public int gridDimZ() {
        return VkCudaLaunchInfoNV.ngridDimZ(this.address());
    }

    @NativeType(value="uint32_t")
    public int blockDimX() {
        return VkCudaLaunchInfoNV.nblockDimX(this.address());
    }

    @NativeType(value="uint32_t")
    public int blockDimY() {
        return VkCudaLaunchInfoNV.nblockDimY(this.address());
    }

    @NativeType(value="uint32_t")
    public int blockDimZ() {
        return VkCudaLaunchInfoNV.nblockDimZ(this.address());
    }

    @NativeType(value="uint32_t")
    public int sharedMemBytes() {
        return VkCudaLaunchInfoNV.nsharedMemBytes(this.address());
    }

    @NativeType(value="size_t")
    public long paramCount() {
        return VkCudaLaunchInfoNV.nparamCount(this.address());
    }

    @NativeType(value="void const * const *")
    public @Nullable PointerBuffer pParams() {
        return VkCudaLaunchInfoNV.npParams(this.address());
    }

    @NativeType(value="size_t")
    public long extraCount() {
        return VkCudaLaunchInfoNV.nextraCount(this.address());
    }

    @NativeType(value="void const * const *")
    public @Nullable PointerBuffer pExtras() {
        return VkCudaLaunchInfoNV.npExtras(this.address());
    }

    public VkCudaLaunchInfoNV sType(@NativeType(value="VkStructureType") int value) {
        VkCudaLaunchInfoNV.nsType(this.address(), value);
        return this;
    }

    public VkCudaLaunchInfoNV sType$Default() {
        return this.sType(1000307002);
    }

    public VkCudaLaunchInfoNV pNext(@NativeType(value="void const *") long value) {
        VkCudaLaunchInfoNV.npNext(this.address(), value);
        return this;
    }

    public VkCudaLaunchInfoNV function(@NativeType(value="VkCudaFunctionNV") long value) {
        VkCudaLaunchInfoNV.nfunction(this.address(), value);
        return this;
    }

    public VkCudaLaunchInfoNV gridDimX(@NativeType(value="uint32_t") int value) {
        VkCudaLaunchInfoNV.ngridDimX(this.address(), value);
        return this;
    }

    public VkCudaLaunchInfoNV gridDimY(@NativeType(value="uint32_t") int value) {
        VkCudaLaunchInfoNV.ngridDimY(this.address(), value);
        return this;
    }

    public VkCudaLaunchInfoNV gridDimZ(@NativeType(value="uint32_t") int value) {
        VkCudaLaunchInfoNV.ngridDimZ(this.address(), value);
        return this;
    }

    public VkCudaLaunchInfoNV blockDimX(@NativeType(value="uint32_t") int value) {
        VkCudaLaunchInfoNV.nblockDimX(this.address(), value);
        return this;
    }

    public VkCudaLaunchInfoNV blockDimY(@NativeType(value="uint32_t") int value) {
        VkCudaLaunchInfoNV.nblockDimY(this.address(), value);
        return this;
    }

    public VkCudaLaunchInfoNV blockDimZ(@NativeType(value="uint32_t") int value) {
        VkCudaLaunchInfoNV.nblockDimZ(this.address(), value);
        return this;
    }

    public VkCudaLaunchInfoNV sharedMemBytes(@NativeType(value="uint32_t") int value) {
        VkCudaLaunchInfoNV.nsharedMemBytes(this.address(), value);
        return this;
    }

    public VkCudaLaunchInfoNV paramCount(@NativeType(value="size_t") long value) {
        VkCudaLaunchInfoNV.nparamCount(this.address(), value);
        return this;
    }

    public VkCudaLaunchInfoNV pParams(@NativeType(value="void const * const *") @Nullable PointerBuffer value) {
        VkCudaLaunchInfoNV.npParams(this.address(), value);
        return this;
    }

    public VkCudaLaunchInfoNV extraCount(@NativeType(value="size_t") long value) {
        VkCudaLaunchInfoNV.nextraCount(this.address(), value);
        return this;
    }

    public VkCudaLaunchInfoNV pExtras(@NativeType(value="void const * const *") @Nullable PointerBuffer value) {
        VkCudaLaunchInfoNV.npExtras(this.address(), value);
        return this;
    }

    public VkCudaLaunchInfoNV set(int sType, long pNext, long function, int gridDimX, int gridDimY, int gridDimZ, int blockDimX, int blockDimY, int blockDimZ, int sharedMemBytes, long paramCount, @Nullable PointerBuffer pParams, long extraCount, @Nullable PointerBuffer pExtras) {
        this.sType(sType);
        this.pNext(pNext);
        this.function(function);
        this.gridDimX(gridDimX);
        this.gridDimY(gridDimY);
        this.gridDimZ(gridDimZ);
        this.blockDimX(blockDimX);
        this.blockDimY(blockDimY);
        this.blockDimZ(blockDimZ);
        this.sharedMemBytes(sharedMemBytes);
        this.paramCount(paramCount);
        this.pParams(pParams);
        this.extraCount(extraCount);
        this.pExtras(pExtras);
        return this;
    }

    public VkCudaLaunchInfoNV set(VkCudaLaunchInfoNV src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkCudaLaunchInfoNV malloc() {
        return new VkCudaLaunchInfoNV(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkCudaLaunchInfoNV calloc() {
        return new VkCudaLaunchInfoNV(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkCudaLaunchInfoNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkCudaLaunchInfoNV(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkCudaLaunchInfoNV create(long address) {
        return new VkCudaLaunchInfoNV(address, null);
    }

    public static @Nullable VkCudaLaunchInfoNV createSafe(long address) {
        return address == 0L ? null : new VkCudaLaunchInfoNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkCudaLaunchInfoNV.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCudaLaunchInfoNV.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkCudaLaunchInfoNV malloc(MemoryStack stack) {
        return new VkCudaLaunchInfoNV(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkCudaLaunchInfoNV calloc(MemoryStack stack) {
        return new VkCudaLaunchInfoNV(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long nfunction(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)FUNCTION));
    }

    public static int ngridDimX(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)GRIDDIMX));
    }

    public static int ngridDimY(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)GRIDDIMY));
    }

    public static int ngridDimZ(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)GRIDDIMZ));
    }

    public static int nblockDimX(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)BLOCKDIMX));
    }

    public static int nblockDimY(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)BLOCKDIMY));
    }

    public static int nblockDimZ(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)BLOCKDIMZ));
    }

    public static int nsharedMemBytes(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SHAREDMEMBYTES));
    }

    public static long nparamCount(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PARAMCOUNT));
    }

    public static @Nullable PointerBuffer npParams(long struct) {
        return MemoryUtil.memPointerBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PPARAMS)), (int)((int)VkCudaLaunchInfoNV.nparamCount(struct)));
    }

    public static long nextraCount(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)EXTRACOUNT));
    }

    public static @Nullable PointerBuffer npExtras(long struct) {
        return MemoryUtil.memPointerBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PEXTRAS)), (int)((int)VkCudaLaunchInfoNV.nextraCount(struct)));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nfunction(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)FUNCTION), (long)value);
    }

    public static void ngridDimX(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)GRIDDIMX), (int)value);
    }

    public static void ngridDimY(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)GRIDDIMY), (int)value);
    }

    public static void ngridDimZ(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)GRIDDIMZ), (int)value);
    }

    public static void nblockDimX(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)BLOCKDIMX), (int)value);
    }

    public static void nblockDimY(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)BLOCKDIMY), (int)value);
    }

    public static void nblockDimZ(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)BLOCKDIMZ), (int)value);
    }

    public static void nsharedMemBytes(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SHAREDMEMBYTES), (int)value);
    }

    public static void nparamCount(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PARAMCOUNT), (long)value);
    }

    public static void npParams(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PPARAMS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        if (value != null) {
            VkCudaLaunchInfoNV.nparamCount(struct, value.remaining());
        }
    }

    public static void nextraCount(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)EXTRACOUNT), (long)value);
    }

    public static void npExtras(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PEXTRAS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        if (value != null) {
            VkCudaLaunchInfoNV.nextraCount(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = VkCudaLaunchInfoNV.__struct((Struct.Member[])new Struct.Member[]{VkCudaLaunchInfoNV.__member((int)4), VkCudaLaunchInfoNV.__member((int)POINTER_SIZE), VkCudaLaunchInfoNV.__member((int)8), VkCudaLaunchInfoNV.__member((int)4), VkCudaLaunchInfoNV.__member((int)4), VkCudaLaunchInfoNV.__member((int)4), VkCudaLaunchInfoNV.__member((int)4), VkCudaLaunchInfoNV.__member((int)4), VkCudaLaunchInfoNV.__member((int)4), VkCudaLaunchInfoNV.__member((int)4), VkCudaLaunchInfoNV.__member((int)POINTER_SIZE), VkCudaLaunchInfoNV.__member((int)POINTER_SIZE), VkCudaLaunchInfoNV.__member((int)POINTER_SIZE), VkCudaLaunchInfoNV.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FUNCTION = layout.offsetof(2);
        GRIDDIMX = layout.offsetof(3);
        GRIDDIMY = layout.offsetof(4);
        GRIDDIMZ = layout.offsetof(5);
        BLOCKDIMX = layout.offsetof(6);
        BLOCKDIMY = layout.offsetof(7);
        BLOCKDIMZ = layout.offsetof(8);
        SHAREDMEMBYTES = layout.offsetof(9);
        PARAMCOUNT = layout.offsetof(10);
        PPARAMS = layout.offsetof(11);
        EXTRACOUNT = layout.offsetof(12);
        PEXTRAS = layout.offsetof(13);
    }

    public static class Buffer
    extends StructBuffer<VkCudaLaunchInfoNV, Buffer>
    implements NativeResource {
        private static final VkCudaLaunchInfoNV ELEMENT_FACTORY = VkCudaLaunchInfoNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkCudaLaunchInfoNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkCudaLaunchInfoNV.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkCudaLaunchInfoNV.npNext(this.address());
        }

        @NativeType(value="VkCudaFunctionNV")
        public long function() {
            return VkCudaLaunchInfoNV.nfunction(this.address());
        }

        @NativeType(value="uint32_t")
        public int gridDimX() {
            return VkCudaLaunchInfoNV.ngridDimX(this.address());
        }

        @NativeType(value="uint32_t")
        public int gridDimY() {
            return VkCudaLaunchInfoNV.ngridDimY(this.address());
        }

        @NativeType(value="uint32_t")
        public int gridDimZ() {
            return VkCudaLaunchInfoNV.ngridDimZ(this.address());
        }

        @NativeType(value="uint32_t")
        public int blockDimX() {
            return VkCudaLaunchInfoNV.nblockDimX(this.address());
        }

        @NativeType(value="uint32_t")
        public int blockDimY() {
            return VkCudaLaunchInfoNV.nblockDimY(this.address());
        }

        @NativeType(value="uint32_t")
        public int blockDimZ() {
            return VkCudaLaunchInfoNV.nblockDimZ(this.address());
        }

        @NativeType(value="uint32_t")
        public int sharedMemBytes() {
            return VkCudaLaunchInfoNV.nsharedMemBytes(this.address());
        }

        @NativeType(value="size_t")
        public long paramCount() {
            return VkCudaLaunchInfoNV.nparamCount(this.address());
        }

        @NativeType(value="void const * const *")
        public @Nullable PointerBuffer pParams() {
            return VkCudaLaunchInfoNV.npParams(this.address());
        }

        @NativeType(value="size_t")
        public long extraCount() {
            return VkCudaLaunchInfoNV.nextraCount(this.address());
        }

        @NativeType(value="void const * const *")
        public @Nullable PointerBuffer pExtras() {
            return VkCudaLaunchInfoNV.npExtras(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCudaLaunchInfoNV.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000307002);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkCudaLaunchInfoNV.npNext(this.address(), value);
            return this;
        }

        public Buffer function(@NativeType(value="VkCudaFunctionNV") long value) {
            VkCudaLaunchInfoNV.nfunction(this.address(), value);
            return this;
        }

        public Buffer gridDimX(@NativeType(value="uint32_t") int value) {
            VkCudaLaunchInfoNV.ngridDimX(this.address(), value);
            return this;
        }

        public Buffer gridDimY(@NativeType(value="uint32_t") int value) {
            VkCudaLaunchInfoNV.ngridDimY(this.address(), value);
            return this;
        }

        public Buffer gridDimZ(@NativeType(value="uint32_t") int value) {
            VkCudaLaunchInfoNV.ngridDimZ(this.address(), value);
            return this;
        }

        public Buffer blockDimX(@NativeType(value="uint32_t") int value) {
            VkCudaLaunchInfoNV.nblockDimX(this.address(), value);
            return this;
        }

        public Buffer blockDimY(@NativeType(value="uint32_t") int value) {
            VkCudaLaunchInfoNV.nblockDimY(this.address(), value);
            return this;
        }

        public Buffer blockDimZ(@NativeType(value="uint32_t") int value) {
            VkCudaLaunchInfoNV.nblockDimZ(this.address(), value);
            return this;
        }

        public Buffer sharedMemBytes(@NativeType(value="uint32_t") int value) {
            VkCudaLaunchInfoNV.nsharedMemBytes(this.address(), value);
            return this;
        }

        public Buffer paramCount(@NativeType(value="size_t") long value) {
            VkCudaLaunchInfoNV.nparamCount(this.address(), value);
            return this;
        }

        public Buffer pParams(@NativeType(value="void const * const *") @Nullable PointerBuffer value) {
            VkCudaLaunchInfoNV.npParams(this.address(), value);
            return this;
        }

        public Buffer extraCount(@NativeType(value="size_t") long value) {
            VkCudaLaunchInfoNV.nextraCount(this.address(), value);
            return this;
        }

        public Buffer pExtras(@NativeType(value="void const * const *") @Nullable PointerBuffer value) {
            VkCudaLaunchInfoNV.npExtras(this.address(), value);
            return this;
        }
    }
}

