/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDepthClampRangeEXT
extends Struct<VkDepthClampRangeEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MINDEPTHCLAMP;
    public static final int MAXDEPTHCLAMP;

    protected VkDepthClampRangeEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkDepthClampRangeEXT create(long address, @Nullable ByteBuffer container) {
        return new VkDepthClampRangeEXT(address, container);
    }

    public VkDepthClampRangeEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDepthClampRangeEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float minDepthClamp() {
        return VkDepthClampRangeEXT.nminDepthClamp(this.address());
    }

    public float maxDepthClamp() {
        return VkDepthClampRangeEXT.nmaxDepthClamp(this.address());
    }

    public VkDepthClampRangeEXT minDepthClamp(float value) {
        VkDepthClampRangeEXT.nminDepthClamp(this.address(), value);
        return this;
    }

    public VkDepthClampRangeEXT maxDepthClamp(float value) {
        VkDepthClampRangeEXT.nmaxDepthClamp(this.address(), value);
        return this;
    }

    public VkDepthClampRangeEXT set(float minDepthClamp, float maxDepthClamp) {
        this.minDepthClamp(minDepthClamp);
        this.maxDepthClamp(maxDepthClamp);
        return this;
    }

    public VkDepthClampRangeEXT set(VkDepthClampRangeEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDepthClampRangeEXT malloc() {
        return new VkDepthClampRangeEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkDepthClampRangeEXT calloc() {
        return new VkDepthClampRangeEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkDepthClampRangeEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkDepthClampRangeEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkDepthClampRangeEXT create(long address) {
        return new VkDepthClampRangeEXT(address, null);
    }

    public static @Nullable VkDepthClampRangeEXT createSafe(long address) {
        return address == 0L ? null : new VkDepthClampRangeEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkDepthClampRangeEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDepthClampRangeEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkDepthClampRangeEXT malloc(MemoryStack stack) {
        return new VkDepthClampRangeEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDepthClampRangeEXT calloc(MemoryStack stack) {
        return new VkDepthClampRangeEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nminDepthClamp(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)MINDEPTHCLAMP));
    }

    public static float nmaxDepthClamp(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)MAXDEPTHCLAMP));
    }

    public static void nminDepthClamp(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)MINDEPTHCLAMP), (float)value);
    }

    public static void nmaxDepthClamp(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)MAXDEPTHCLAMP), (float)value);
    }

    static {
        Struct.Layout layout = VkDepthClampRangeEXT.__struct((Struct.Member[])new Struct.Member[]{VkDepthClampRangeEXT.__member((int)4), VkDepthClampRangeEXT.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MINDEPTHCLAMP = layout.offsetof(0);
        MAXDEPTHCLAMP = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkDepthClampRangeEXT, Buffer>
    implements NativeResource {
        private static final VkDepthClampRangeEXT ELEMENT_FACTORY = VkDepthClampRangeEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkDepthClampRangeEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float minDepthClamp() {
            return VkDepthClampRangeEXT.nminDepthClamp(this.address());
        }

        public float maxDepthClamp() {
            return VkDepthClampRangeEXT.nmaxDepthClamp(this.address());
        }

        public Buffer minDepthClamp(float value) {
            VkDepthClampRangeEXT.nminDepthClamp(this.address(), value);
            return this;
        }

        public Buffer maxDepthClamp(float value) {
            VkDepthClampRangeEXT.nmaxDepthClamp(this.address(), value);
            return this;
        }
    }
}

