/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDescriptorPoolInlineUniformBlockCreateInfo;
import org.lwjgl.vulkan.VkDescriptorPoolInlineUniformBlockCreateInfoEXT;
import org.lwjgl.vulkan.VkDescriptorPoolSize;
import org.lwjgl.vulkan.VkMutableDescriptorTypeCreateInfoEXT;
import org.lwjgl.vulkan.VkMutableDescriptorTypeCreateInfoVALVE;

public class VkDescriptorPoolCreateInfo
extends Struct<VkDescriptorPoolCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int MAXSETS;
    public static final int POOLSIZECOUNT;
    public static final int PPOOLSIZES;

    protected VkDescriptorPoolCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkDescriptorPoolCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new VkDescriptorPoolCreateInfo(address, container);
    }

    public VkDescriptorPoolCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDescriptorPoolCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDescriptorPoolCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDescriptorPoolCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkDescriptorPoolCreateFlags")
    public int flags() {
        return VkDescriptorPoolCreateInfo.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxSets() {
        return VkDescriptorPoolCreateInfo.nmaxSets(this.address());
    }

    @NativeType(value="uint32_t")
    public int poolSizeCount() {
        return VkDescriptorPoolCreateInfo.npoolSizeCount(this.address());
    }

    @NativeType(value="VkDescriptorPoolSize const *")
    public @Nullable VkDescriptorPoolSize.Buffer pPoolSizes() {
        return VkDescriptorPoolCreateInfo.npPoolSizes(this.address());
    }

    public VkDescriptorPoolCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkDescriptorPoolCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkDescriptorPoolCreateInfo sType$Default() {
        return this.sType(33);
    }

    public VkDescriptorPoolCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkDescriptorPoolCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkDescriptorPoolCreateInfo pNext(VkDescriptorPoolInlineUniformBlockCreateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkDescriptorPoolCreateInfo pNext(VkDescriptorPoolInlineUniformBlockCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkDescriptorPoolCreateInfo pNext(VkMutableDescriptorTypeCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkDescriptorPoolCreateInfo pNext(VkMutableDescriptorTypeCreateInfoVALVE value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkDescriptorPoolCreateInfo flags(@NativeType(value="VkDescriptorPoolCreateFlags") int value) {
        VkDescriptorPoolCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkDescriptorPoolCreateInfo maxSets(@NativeType(value="uint32_t") int value) {
        VkDescriptorPoolCreateInfo.nmaxSets(this.address(), value);
        return this;
    }

    public VkDescriptorPoolCreateInfo pPoolSizes(@NativeType(value="VkDescriptorPoolSize const *") @Nullable VkDescriptorPoolSize.Buffer value) {
        VkDescriptorPoolCreateInfo.npPoolSizes(this.address(), value);
        return this;
    }

    public VkDescriptorPoolCreateInfo set(int sType, long pNext, int flags, int maxSets, @Nullable VkDescriptorPoolSize.Buffer pPoolSizes) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.maxSets(maxSets);
        this.pPoolSizes(pPoolSizes);
        return this;
    }

    public VkDescriptorPoolCreateInfo set(VkDescriptorPoolCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDescriptorPoolCreateInfo malloc() {
        return new VkDescriptorPoolCreateInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkDescriptorPoolCreateInfo calloc() {
        return new VkDescriptorPoolCreateInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkDescriptorPoolCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkDescriptorPoolCreateInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkDescriptorPoolCreateInfo create(long address) {
        return new VkDescriptorPoolCreateInfo(address, null);
    }

    public static @Nullable VkDescriptorPoolCreateInfo createSafe(long address) {
        return address == 0L ? null : new VkDescriptorPoolCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkDescriptorPoolCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDescriptorPoolCreateInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkDescriptorPoolCreateInfo mallocStack() {
        return VkDescriptorPoolCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDescriptorPoolCreateInfo callocStack() {
        return VkDescriptorPoolCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDescriptorPoolCreateInfo mallocStack(MemoryStack stack) {
        return VkDescriptorPoolCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VkDescriptorPoolCreateInfo callocStack(MemoryStack stack) {
        return VkDescriptorPoolCreateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDescriptorPoolCreateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDescriptorPoolCreateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDescriptorPoolCreateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDescriptorPoolCreateInfo.calloc(capacity, stack);
    }

    public static VkDescriptorPoolCreateInfo malloc(MemoryStack stack) {
        return new VkDescriptorPoolCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDescriptorPoolCreateInfo calloc(MemoryStack stack) {
        return new VkDescriptorPoolCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FLAGS));
    }

    public static int nmaxSets(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MAXSETS));
    }

    public static int npoolSizeCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)POOLSIZECOUNT));
    }

    public static @Nullable VkDescriptorPoolSize.Buffer npPoolSizes(long struct) {
        return VkDescriptorPoolSize.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PPOOLSIZES)), VkDescriptorPoolCreateInfo.npoolSizeCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FLAGS), (int)value);
    }

    public static void nmaxSets(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MAXSETS), (int)value);
    }

    public static void npoolSizeCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)POOLSIZECOUNT), (int)value);
    }

    public static void npPoolSizes(long struct, @Nullable VkDescriptorPoolSize.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PPOOLSIZES), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkDescriptorPoolCreateInfo.npoolSizeCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkDescriptorPoolCreateInfo.npoolSizeCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PPOOLSIZES)));
        }
    }

    static {
        Struct.Layout layout = VkDescriptorPoolCreateInfo.__struct((Struct.Member[])new Struct.Member[]{VkDescriptorPoolCreateInfo.__member((int)4), VkDescriptorPoolCreateInfo.__member((int)POINTER_SIZE), VkDescriptorPoolCreateInfo.__member((int)4), VkDescriptorPoolCreateInfo.__member((int)4), VkDescriptorPoolCreateInfo.__member((int)4), VkDescriptorPoolCreateInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        MAXSETS = layout.offsetof(3);
        POOLSIZECOUNT = layout.offsetof(4);
        PPOOLSIZES = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkDescriptorPoolCreateInfo, Buffer>
    implements NativeResource {
        private static final VkDescriptorPoolCreateInfo ELEMENT_FACTORY = VkDescriptorPoolCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkDescriptorPoolCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDescriptorPoolCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDescriptorPoolCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkDescriptorPoolCreateFlags")
        public int flags() {
            return VkDescriptorPoolCreateInfo.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxSets() {
            return VkDescriptorPoolCreateInfo.nmaxSets(this.address());
        }

        @NativeType(value="uint32_t")
        public int poolSizeCount() {
            return VkDescriptorPoolCreateInfo.npoolSizeCount(this.address());
        }

        @NativeType(value="VkDescriptorPoolSize const *")
        public @Nullable VkDescriptorPoolSize.Buffer pPoolSizes() {
            return VkDescriptorPoolCreateInfo.npPoolSizes(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDescriptorPoolCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(33);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDescriptorPoolCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkDescriptorPoolInlineUniformBlockCreateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkDescriptorPoolInlineUniformBlockCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkMutableDescriptorTypeCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkMutableDescriptorTypeCreateInfoVALVE value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkDescriptorPoolCreateFlags") int value) {
            VkDescriptorPoolCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer maxSets(@NativeType(value="uint32_t") int value) {
            VkDescriptorPoolCreateInfo.nmaxSets(this.address(), value);
            return this;
        }

        public Buffer pPoolSizes(@NativeType(value="VkDescriptorPoolSize const *") @Nullable VkDescriptorPoolSize.Buffer value) {
            VkDescriptorPoolCreateInfo.npPoolSizes(this.address(), value);
            return this;
        }
    }
}

