/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDeviceGroupBindSparseInfo
extends Struct<VkDeviceGroupBindSparseInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int RESOURCEDEVICEINDEX;
    public static final int MEMORYDEVICEINDEX;

    protected VkDeviceGroupBindSparseInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkDeviceGroupBindSparseInfo create(long address, @Nullable ByteBuffer container) {
        return new VkDeviceGroupBindSparseInfo(address, container);
    }

    public VkDeviceGroupBindSparseInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDeviceGroupBindSparseInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDeviceGroupBindSparseInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDeviceGroupBindSparseInfo.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int resourceDeviceIndex() {
        return VkDeviceGroupBindSparseInfo.nresourceDeviceIndex(this.address());
    }

    @NativeType(value="uint32_t")
    public int memoryDeviceIndex() {
        return VkDeviceGroupBindSparseInfo.nmemoryDeviceIndex(this.address());
    }

    public VkDeviceGroupBindSparseInfo sType(@NativeType(value="VkStructureType") int value) {
        VkDeviceGroupBindSparseInfo.nsType(this.address(), value);
        return this;
    }

    public VkDeviceGroupBindSparseInfo sType$Default() {
        return this.sType(1000060006);
    }

    public VkDeviceGroupBindSparseInfo pNext(@NativeType(value="void const *") long value) {
        VkDeviceGroupBindSparseInfo.npNext(this.address(), value);
        return this;
    }

    public VkDeviceGroupBindSparseInfo resourceDeviceIndex(@NativeType(value="uint32_t") int value) {
        VkDeviceGroupBindSparseInfo.nresourceDeviceIndex(this.address(), value);
        return this;
    }

    public VkDeviceGroupBindSparseInfo memoryDeviceIndex(@NativeType(value="uint32_t") int value) {
        VkDeviceGroupBindSparseInfo.nmemoryDeviceIndex(this.address(), value);
        return this;
    }

    public VkDeviceGroupBindSparseInfo set(int sType, long pNext, int resourceDeviceIndex, int memoryDeviceIndex) {
        this.sType(sType);
        this.pNext(pNext);
        this.resourceDeviceIndex(resourceDeviceIndex);
        this.memoryDeviceIndex(memoryDeviceIndex);
        return this;
    }

    public VkDeviceGroupBindSparseInfo set(VkDeviceGroupBindSparseInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDeviceGroupBindSparseInfo malloc() {
        return new VkDeviceGroupBindSparseInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkDeviceGroupBindSparseInfo calloc() {
        return new VkDeviceGroupBindSparseInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkDeviceGroupBindSparseInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkDeviceGroupBindSparseInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkDeviceGroupBindSparseInfo create(long address) {
        return new VkDeviceGroupBindSparseInfo(address, null);
    }

    public static @Nullable VkDeviceGroupBindSparseInfo createSafe(long address) {
        return address == 0L ? null : new VkDeviceGroupBindSparseInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkDeviceGroupBindSparseInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDeviceGroupBindSparseInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkDeviceGroupBindSparseInfo mallocStack() {
        return VkDeviceGroupBindSparseInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDeviceGroupBindSparseInfo callocStack() {
        return VkDeviceGroupBindSparseInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDeviceGroupBindSparseInfo mallocStack(MemoryStack stack) {
        return VkDeviceGroupBindSparseInfo.malloc(stack);
    }

    @Deprecated
    public static VkDeviceGroupBindSparseInfo callocStack(MemoryStack stack) {
        return VkDeviceGroupBindSparseInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDeviceGroupBindSparseInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDeviceGroupBindSparseInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupBindSparseInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupBindSparseInfo.calloc(capacity, stack);
    }

    public static VkDeviceGroupBindSparseInfo malloc(MemoryStack stack) {
        return new VkDeviceGroupBindSparseInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDeviceGroupBindSparseInfo calloc(MemoryStack stack) {
        return new VkDeviceGroupBindSparseInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nresourceDeviceIndex(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)RESOURCEDEVICEINDEX));
    }

    public static int nmemoryDeviceIndex(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MEMORYDEVICEINDEX));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nresourceDeviceIndex(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)RESOURCEDEVICEINDEX), (int)value);
    }

    public static void nmemoryDeviceIndex(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MEMORYDEVICEINDEX), (int)value);
    }

    static {
        Struct.Layout layout = VkDeviceGroupBindSparseInfo.__struct((Struct.Member[])new Struct.Member[]{VkDeviceGroupBindSparseInfo.__member((int)4), VkDeviceGroupBindSparseInfo.__member((int)POINTER_SIZE), VkDeviceGroupBindSparseInfo.__member((int)4), VkDeviceGroupBindSparseInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        RESOURCEDEVICEINDEX = layout.offsetof(2);
        MEMORYDEVICEINDEX = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceGroupBindSparseInfo, Buffer>
    implements NativeResource {
        private static final VkDeviceGroupBindSparseInfo ELEMENT_FACTORY = VkDeviceGroupBindSparseInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkDeviceGroupBindSparseInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDeviceGroupBindSparseInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDeviceGroupBindSparseInfo.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int resourceDeviceIndex() {
            return VkDeviceGroupBindSparseInfo.nresourceDeviceIndex(this.address());
        }

        @NativeType(value="uint32_t")
        public int memoryDeviceIndex() {
            return VkDeviceGroupBindSparseInfo.nmemoryDeviceIndex(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDeviceGroupBindSparseInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000060006);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDeviceGroupBindSparseInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer resourceDeviceIndex(@NativeType(value="uint32_t") int value) {
            VkDeviceGroupBindSparseInfo.nresourceDeviceIndex(this.address(), value);
            return this;
        }

        public Buffer memoryDeviceIndex(@NativeType(value="uint32_t") int value) {
            VkDeviceGroupBindSparseInfo.nmemoryDeviceIndex(this.address(), value);
            return this;
        }
    }
}

