/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkRect2D;

public class VkDeviceGroupRenderPassBeginInfo
extends Struct<VkDeviceGroupRenderPassBeginInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int DEVICEMASK;
    public static final int DEVICERENDERAREACOUNT;
    public static final int PDEVICERENDERAREAS;

    protected VkDeviceGroupRenderPassBeginInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkDeviceGroupRenderPassBeginInfo create(long address, @Nullable ByteBuffer container) {
        return new VkDeviceGroupRenderPassBeginInfo(address, container);
    }

    public VkDeviceGroupRenderPassBeginInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDeviceGroupRenderPassBeginInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDeviceGroupRenderPassBeginInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDeviceGroupRenderPassBeginInfo.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int deviceMask() {
        return VkDeviceGroupRenderPassBeginInfo.ndeviceMask(this.address());
    }

    @NativeType(value="uint32_t")
    public int deviceRenderAreaCount() {
        return VkDeviceGroupRenderPassBeginInfo.ndeviceRenderAreaCount(this.address());
    }

    @NativeType(value="VkRect2D const *")
    public @Nullable VkRect2D.Buffer pDeviceRenderAreas() {
        return VkDeviceGroupRenderPassBeginInfo.npDeviceRenderAreas(this.address());
    }

    public VkDeviceGroupRenderPassBeginInfo sType(@NativeType(value="VkStructureType") int value) {
        VkDeviceGroupRenderPassBeginInfo.nsType(this.address(), value);
        return this;
    }

    public VkDeviceGroupRenderPassBeginInfo sType$Default() {
        return this.sType(1000060003);
    }

    public VkDeviceGroupRenderPassBeginInfo pNext(@NativeType(value="void const *") long value) {
        VkDeviceGroupRenderPassBeginInfo.npNext(this.address(), value);
        return this;
    }

    public VkDeviceGroupRenderPassBeginInfo deviceMask(@NativeType(value="uint32_t") int value) {
        VkDeviceGroupRenderPassBeginInfo.ndeviceMask(this.address(), value);
        return this;
    }

    public VkDeviceGroupRenderPassBeginInfo pDeviceRenderAreas(@NativeType(value="VkRect2D const *") @Nullable VkRect2D.Buffer value) {
        VkDeviceGroupRenderPassBeginInfo.npDeviceRenderAreas(this.address(), value);
        return this;
    }

    public VkDeviceGroupRenderPassBeginInfo set(int sType, long pNext, int deviceMask, @Nullable VkRect2D.Buffer pDeviceRenderAreas) {
        this.sType(sType);
        this.pNext(pNext);
        this.deviceMask(deviceMask);
        this.pDeviceRenderAreas(pDeviceRenderAreas);
        return this;
    }

    public VkDeviceGroupRenderPassBeginInfo set(VkDeviceGroupRenderPassBeginInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDeviceGroupRenderPassBeginInfo malloc() {
        return new VkDeviceGroupRenderPassBeginInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkDeviceGroupRenderPassBeginInfo calloc() {
        return new VkDeviceGroupRenderPassBeginInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkDeviceGroupRenderPassBeginInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkDeviceGroupRenderPassBeginInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkDeviceGroupRenderPassBeginInfo create(long address) {
        return new VkDeviceGroupRenderPassBeginInfo(address, null);
    }

    public static @Nullable VkDeviceGroupRenderPassBeginInfo createSafe(long address) {
        return address == 0L ? null : new VkDeviceGroupRenderPassBeginInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkDeviceGroupRenderPassBeginInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDeviceGroupRenderPassBeginInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkDeviceGroupRenderPassBeginInfo mallocStack() {
        return VkDeviceGroupRenderPassBeginInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDeviceGroupRenderPassBeginInfo callocStack() {
        return VkDeviceGroupRenderPassBeginInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDeviceGroupRenderPassBeginInfo mallocStack(MemoryStack stack) {
        return VkDeviceGroupRenderPassBeginInfo.malloc(stack);
    }

    @Deprecated
    public static VkDeviceGroupRenderPassBeginInfo callocStack(MemoryStack stack) {
        return VkDeviceGroupRenderPassBeginInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDeviceGroupRenderPassBeginInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDeviceGroupRenderPassBeginInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupRenderPassBeginInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupRenderPassBeginInfo.calloc(capacity, stack);
    }

    public static VkDeviceGroupRenderPassBeginInfo malloc(MemoryStack stack) {
        return new VkDeviceGroupRenderPassBeginInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDeviceGroupRenderPassBeginInfo calloc(MemoryStack stack) {
        return new VkDeviceGroupRenderPassBeginInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int ndeviceMask(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DEVICEMASK));
    }

    public static int ndeviceRenderAreaCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DEVICERENDERAREACOUNT));
    }

    public static @Nullable VkRect2D.Buffer npDeviceRenderAreas(long struct) {
        return VkRect2D.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PDEVICERENDERAREAS)), VkDeviceGroupRenderPassBeginInfo.ndeviceRenderAreaCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void ndeviceMask(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)DEVICEMASK), (int)value);
    }

    public static void ndeviceRenderAreaCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)DEVICERENDERAREACOUNT), (int)value);
    }

    public static void npDeviceRenderAreas(long struct, @Nullable VkRect2D.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PDEVICERENDERAREAS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkDeviceGroupRenderPassBeginInfo.ndeviceRenderAreaCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkDeviceGroupRenderPassBeginInfo.ndeviceRenderAreaCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PDEVICERENDERAREAS)));
        }
    }

    static {
        Struct.Layout layout = VkDeviceGroupRenderPassBeginInfo.__struct((Struct.Member[])new Struct.Member[]{VkDeviceGroupRenderPassBeginInfo.__member((int)4), VkDeviceGroupRenderPassBeginInfo.__member((int)POINTER_SIZE), VkDeviceGroupRenderPassBeginInfo.__member((int)4), VkDeviceGroupRenderPassBeginInfo.__member((int)4), VkDeviceGroupRenderPassBeginInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        DEVICEMASK = layout.offsetof(2);
        DEVICERENDERAREACOUNT = layout.offsetof(3);
        PDEVICERENDERAREAS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceGroupRenderPassBeginInfo, Buffer>
    implements NativeResource {
        private static final VkDeviceGroupRenderPassBeginInfo ELEMENT_FACTORY = VkDeviceGroupRenderPassBeginInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkDeviceGroupRenderPassBeginInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDeviceGroupRenderPassBeginInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDeviceGroupRenderPassBeginInfo.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int deviceMask() {
            return VkDeviceGroupRenderPassBeginInfo.ndeviceMask(this.address());
        }

        @NativeType(value="uint32_t")
        public int deviceRenderAreaCount() {
            return VkDeviceGroupRenderPassBeginInfo.ndeviceRenderAreaCount(this.address());
        }

        @NativeType(value="VkRect2D const *")
        public @Nullable VkRect2D.Buffer pDeviceRenderAreas() {
            return VkDeviceGroupRenderPassBeginInfo.npDeviceRenderAreas(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDeviceGroupRenderPassBeginInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000060003);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDeviceGroupRenderPassBeginInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer deviceMask(@NativeType(value="uint32_t") int value) {
            VkDeviceGroupRenderPassBeginInfo.ndeviceMask(this.address(), value);
            return this;
        }

        public Buffer pDeviceRenderAreas(@NativeType(value="VkRect2D const *") @Nullable VkRect2D.Buffer value) {
            VkDeviceGroupRenderPassBeginInfo.npDeviceRenderAreas(this.address(), value);
            return this;
        }
    }
}

