/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkImageCreateInfo;
import org.lwjgl.vulkan.VkImageSubresource2;

public class VkDeviceImageSubresourceInfo
extends Struct<VkDeviceImageSubresourceInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PCREATEINFO;
    public static final int PSUBRESOURCE;

    protected VkDeviceImageSubresourceInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkDeviceImageSubresourceInfo create(long address, @Nullable ByteBuffer container) {
        return new VkDeviceImageSubresourceInfo(address, container);
    }

    public VkDeviceImageSubresourceInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDeviceImageSubresourceInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDeviceImageSubresourceInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDeviceImageSubresourceInfo.npNext(this.address());
    }

    @NativeType(value="VkImageCreateInfo const *")
    public VkImageCreateInfo pCreateInfo() {
        return VkDeviceImageSubresourceInfo.npCreateInfo(this.address());
    }

    @NativeType(value="VkImageSubresource2 const *")
    public VkImageSubresource2 pSubresource() {
        return VkDeviceImageSubresourceInfo.npSubresource(this.address());
    }

    public VkDeviceImageSubresourceInfo sType(@NativeType(value="VkStructureType") int value) {
        VkDeviceImageSubresourceInfo.nsType(this.address(), value);
        return this;
    }

    public VkDeviceImageSubresourceInfo sType$Default() {
        return this.sType(1000470004);
    }

    public VkDeviceImageSubresourceInfo pNext(@NativeType(value="void const *") long value) {
        VkDeviceImageSubresourceInfo.npNext(this.address(), value);
        return this;
    }

    public VkDeviceImageSubresourceInfo pCreateInfo(@NativeType(value="VkImageCreateInfo const *") VkImageCreateInfo value) {
        VkDeviceImageSubresourceInfo.npCreateInfo(this.address(), value);
        return this;
    }

    public VkDeviceImageSubresourceInfo pSubresource(@NativeType(value="VkImageSubresource2 const *") VkImageSubresource2 value) {
        VkDeviceImageSubresourceInfo.npSubresource(this.address(), value);
        return this;
    }

    public VkDeviceImageSubresourceInfo set(int sType, long pNext, VkImageCreateInfo pCreateInfo, VkImageSubresource2 pSubresource) {
        this.sType(sType);
        this.pNext(pNext);
        this.pCreateInfo(pCreateInfo);
        this.pSubresource(pSubresource);
        return this;
    }

    public VkDeviceImageSubresourceInfo set(VkDeviceImageSubresourceInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDeviceImageSubresourceInfo malloc() {
        return new VkDeviceImageSubresourceInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkDeviceImageSubresourceInfo calloc() {
        return new VkDeviceImageSubresourceInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkDeviceImageSubresourceInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkDeviceImageSubresourceInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkDeviceImageSubresourceInfo create(long address) {
        return new VkDeviceImageSubresourceInfo(address, null);
    }

    public static @Nullable VkDeviceImageSubresourceInfo createSafe(long address) {
        return address == 0L ? null : new VkDeviceImageSubresourceInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkDeviceImageSubresourceInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDeviceImageSubresourceInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkDeviceImageSubresourceInfo malloc(MemoryStack stack) {
        return new VkDeviceImageSubresourceInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDeviceImageSubresourceInfo calloc(MemoryStack stack) {
        return new VkDeviceImageSubresourceInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static VkImageCreateInfo npCreateInfo(long struct) {
        return VkImageCreateInfo.create(MemoryUtil.memGetAddress((long)(struct + (long)PCREATEINFO)));
    }

    public static VkImageSubresource2 npSubresource(long struct) {
        return VkImageSubresource2.create(MemoryUtil.memGetAddress((long)(struct + (long)PSUBRESOURCE)));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void npCreateInfo(long struct, VkImageCreateInfo value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PCREATEINFO), (long)value.address());
    }

    public static void npSubresource(long struct, VkImageSubresource2 value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PSUBRESOURCE), (long)value.address());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PCREATEINFO)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PSUBRESOURCE)));
    }

    static {
        Struct.Layout layout = VkDeviceImageSubresourceInfo.__struct((Struct.Member[])new Struct.Member[]{VkDeviceImageSubresourceInfo.__member((int)4), VkDeviceImageSubresourceInfo.__member((int)POINTER_SIZE), VkDeviceImageSubresourceInfo.__member((int)POINTER_SIZE), VkDeviceImageSubresourceInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PCREATEINFO = layout.offsetof(2);
        PSUBRESOURCE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceImageSubresourceInfo, Buffer>
    implements NativeResource {
        private static final VkDeviceImageSubresourceInfo ELEMENT_FACTORY = VkDeviceImageSubresourceInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkDeviceImageSubresourceInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDeviceImageSubresourceInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDeviceImageSubresourceInfo.npNext(this.address());
        }

        @NativeType(value="VkImageCreateInfo const *")
        public VkImageCreateInfo pCreateInfo() {
            return VkDeviceImageSubresourceInfo.npCreateInfo(this.address());
        }

        @NativeType(value="VkImageSubresource2 const *")
        public VkImageSubresource2 pSubresource() {
            return VkDeviceImageSubresourceInfo.npSubresource(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDeviceImageSubresourceInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000470004);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDeviceImageSubresourceInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pCreateInfo(@NativeType(value="VkImageCreateInfo const *") VkImageCreateInfo value) {
            VkDeviceImageSubresourceInfo.npCreateInfo(this.address(), value);
            return this;
        }

        public Buffer pSubresource(@NativeType(value="VkImageSubresource2 const *") VkImageSubresource2 value) {
            VkDeviceImageSubresourceInfo.npSubresource(this.address(), value);
            return this;
        }
    }
}

