/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDisplayModeParametersKHR;

public class VkDisplayModeCreateInfoKHR
extends Struct<VkDisplayModeCreateInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int PARAMETERS;

    protected VkDisplayModeCreateInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkDisplayModeCreateInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkDisplayModeCreateInfoKHR(address, container);
    }

    public VkDisplayModeCreateInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDisplayModeCreateInfoKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDisplayModeCreateInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDisplayModeCreateInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkDisplayModeCreateFlagsKHR")
    public int flags() {
        return VkDisplayModeCreateInfoKHR.nflags(this.address());
    }

    public VkDisplayModeParametersKHR parameters() {
        return VkDisplayModeCreateInfoKHR.nparameters(this.address());
    }

    public VkDisplayModeCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkDisplayModeCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkDisplayModeCreateInfoKHR sType$Default() {
        return this.sType(1000002000);
    }

    public VkDisplayModeCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkDisplayModeCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkDisplayModeCreateInfoKHR flags(@NativeType(value="VkDisplayModeCreateFlagsKHR") int value) {
        VkDisplayModeCreateInfoKHR.nflags(this.address(), value);
        return this;
    }

    public VkDisplayModeCreateInfoKHR parameters(VkDisplayModeParametersKHR value) {
        VkDisplayModeCreateInfoKHR.nparameters(this.address(), value);
        return this;
    }

    public VkDisplayModeCreateInfoKHR parameters(Consumer<VkDisplayModeParametersKHR> consumer) {
        consumer.accept(this.parameters());
        return this;
    }

    public VkDisplayModeCreateInfoKHR set(int sType, long pNext, int flags, VkDisplayModeParametersKHR parameters) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.parameters(parameters);
        return this;
    }

    public VkDisplayModeCreateInfoKHR set(VkDisplayModeCreateInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDisplayModeCreateInfoKHR malloc() {
        return new VkDisplayModeCreateInfoKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkDisplayModeCreateInfoKHR calloc() {
        return new VkDisplayModeCreateInfoKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkDisplayModeCreateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkDisplayModeCreateInfoKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkDisplayModeCreateInfoKHR create(long address) {
        return new VkDisplayModeCreateInfoKHR(address, null);
    }

    public static @Nullable VkDisplayModeCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkDisplayModeCreateInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkDisplayModeCreateInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDisplayModeCreateInfoKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkDisplayModeCreateInfoKHR mallocStack() {
        return VkDisplayModeCreateInfoKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDisplayModeCreateInfoKHR callocStack() {
        return VkDisplayModeCreateInfoKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDisplayModeCreateInfoKHR mallocStack(MemoryStack stack) {
        return VkDisplayModeCreateInfoKHR.malloc(stack);
    }

    @Deprecated
    public static VkDisplayModeCreateInfoKHR callocStack(MemoryStack stack) {
        return VkDisplayModeCreateInfoKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDisplayModeCreateInfoKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDisplayModeCreateInfoKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDisplayModeCreateInfoKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDisplayModeCreateInfoKHR.calloc(capacity, stack);
    }

    public static VkDisplayModeCreateInfoKHR malloc(MemoryStack stack) {
        return new VkDisplayModeCreateInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDisplayModeCreateInfoKHR calloc(MemoryStack stack) {
        return new VkDisplayModeCreateInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FLAGS));
    }

    public static VkDisplayModeParametersKHR nparameters(long struct) {
        return VkDisplayModeParametersKHR.create(struct + (long)PARAMETERS);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FLAGS), (int)value);
    }

    public static void nparameters(long struct, VkDisplayModeParametersKHR value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)PARAMETERS), (long)VkDisplayModeParametersKHR.SIZEOF);
    }

    static {
        Struct.Layout layout = VkDisplayModeCreateInfoKHR.__struct((Struct.Member[])new Struct.Member[]{VkDisplayModeCreateInfoKHR.__member((int)4), VkDisplayModeCreateInfoKHR.__member((int)POINTER_SIZE), VkDisplayModeCreateInfoKHR.__member((int)4), VkDisplayModeCreateInfoKHR.__member((int)VkDisplayModeParametersKHR.SIZEOF, (int)VkDisplayModeParametersKHR.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        PARAMETERS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkDisplayModeCreateInfoKHR, Buffer>
    implements NativeResource {
        private static final VkDisplayModeCreateInfoKHR ELEMENT_FACTORY = VkDisplayModeCreateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkDisplayModeCreateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDisplayModeCreateInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDisplayModeCreateInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkDisplayModeCreateFlagsKHR")
        public int flags() {
            return VkDisplayModeCreateInfoKHR.nflags(this.address());
        }

        public VkDisplayModeParametersKHR parameters() {
            return VkDisplayModeCreateInfoKHR.nparameters(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDisplayModeCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000002000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDisplayModeCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkDisplayModeCreateFlagsKHR") int value) {
            VkDisplayModeCreateInfoKHR.nflags(this.address(), value);
            return this;
        }

        public Buffer parameters(VkDisplayModeParametersKHR value) {
            VkDisplayModeCreateInfoKHR.nparameters(this.address(), value);
            return this;
        }

        public Buffer parameters(Consumer<VkDisplayModeParametersKHR> consumer) {
            consumer.accept(this.parameters());
            return this;
        }
    }
}

