/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent2D;

public class VkDisplayModeParametersKHR
extends Struct<VkDisplayModeParametersKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VISIBLEREGION;
    public static final int REFRESHRATE;

    protected VkDisplayModeParametersKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkDisplayModeParametersKHR create(long address, @Nullable ByteBuffer container) {
        return new VkDisplayModeParametersKHR(address, container);
    }

    public VkDisplayModeParametersKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDisplayModeParametersKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public VkExtent2D visibleRegion() {
        return VkDisplayModeParametersKHR.nvisibleRegion(this.address());
    }

    @NativeType(value="uint32_t")
    public int refreshRate() {
        return VkDisplayModeParametersKHR.nrefreshRate(this.address());
    }

    public VkDisplayModeParametersKHR visibleRegion(VkExtent2D value) {
        VkDisplayModeParametersKHR.nvisibleRegion(this.address(), value);
        return this;
    }

    public VkDisplayModeParametersKHR visibleRegion(Consumer<VkExtent2D> consumer) {
        consumer.accept(this.visibleRegion());
        return this;
    }

    public VkDisplayModeParametersKHR refreshRate(@NativeType(value="uint32_t") int value) {
        VkDisplayModeParametersKHR.nrefreshRate(this.address(), value);
        return this;
    }

    public VkDisplayModeParametersKHR set(VkExtent2D visibleRegion, int refreshRate) {
        this.visibleRegion(visibleRegion);
        this.refreshRate(refreshRate);
        return this;
    }

    public VkDisplayModeParametersKHR set(VkDisplayModeParametersKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDisplayModeParametersKHR malloc() {
        return new VkDisplayModeParametersKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkDisplayModeParametersKHR calloc() {
        return new VkDisplayModeParametersKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkDisplayModeParametersKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkDisplayModeParametersKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkDisplayModeParametersKHR create(long address) {
        return new VkDisplayModeParametersKHR(address, null);
    }

    public static @Nullable VkDisplayModeParametersKHR createSafe(long address) {
        return address == 0L ? null : new VkDisplayModeParametersKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkDisplayModeParametersKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDisplayModeParametersKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkDisplayModeParametersKHR mallocStack() {
        return VkDisplayModeParametersKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDisplayModeParametersKHR callocStack() {
        return VkDisplayModeParametersKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDisplayModeParametersKHR mallocStack(MemoryStack stack) {
        return VkDisplayModeParametersKHR.malloc(stack);
    }

    @Deprecated
    public static VkDisplayModeParametersKHR callocStack(MemoryStack stack) {
        return VkDisplayModeParametersKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDisplayModeParametersKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDisplayModeParametersKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDisplayModeParametersKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDisplayModeParametersKHR.calloc(capacity, stack);
    }

    public static VkDisplayModeParametersKHR malloc(MemoryStack stack) {
        return new VkDisplayModeParametersKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDisplayModeParametersKHR calloc(MemoryStack stack) {
        return new VkDisplayModeParametersKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VkExtent2D nvisibleRegion(long struct) {
        return VkExtent2D.create(struct + (long)VISIBLEREGION);
    }

    public static int nrefreshRate(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)REFRESHRATE));
    }

    public static void nvisibleRegion(long struct, VkExtent2D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)VISIBLEREGION), (long)VkExtent2D.SIZEOF);
    }

    public static void nrefreshRate(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)REFRESHRATE), (int)value);
    }

    static {
        Struct.Layout layout = VkDisplayModeParametersKHR.__struct((Struct.Member[])new Struct.Member[]{VkDisplayModeParametersKHR.__member((int)VkExtent2D.SIZEOF, (int)VkExtent2D.ALIGNOF), VkDisplayModeParametersKHR.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VISIBLEREGION = layout.offsetof(0);
        REFRESHRATE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkDisplayModeParametersKHR, Buffer>
    implements NativeResource {
        private static final VkDisplayModeParametersKHR ELEMENT_FACTORY = VkDisplayModeParametersKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkDisplayModeParametersKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public VkExtent2D visibleRegion() {
            return VkDisplayModeParametersKHR.nvisibleRegion(this.address());
        }

        @NativeType(value="uint32_t")
        public int refreshRate() {
            return VkDisplayModeParametersKHR.nrefreshRate(this.address());
        }

        public Buffer visibleRegion(VkExtent2D value) {
            VkDisplayModeParametersKHR.nvisibleRegion(this.address(), value);
            return this;
        }

        public Buffer visibleRegion(Consumer<VkExtent2D> consumer) {
            consumer.accept(this.visibleRegion());
            return this;
        }

        public Buffer refreshRate(@NativeType(value="uint32_t") int value) {
            VkDisplayModeParametersKHR.nrefreshRate(this.address(), value);
            return this;
        }
    }
}

