/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkExtent2D
extends Struct<VkExtent2D>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int WIDTH;
    public static final int HEIGHT;

    protected VkExtent2D(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkExtent2D create(long address, @Nullable ByteBuffer container) {
        return new VkExtent2D(address, container);
    }

    public VkExtent2D(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkExtent2D.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int width() {
        return VkExtent2D.nwidth(this.address());
    }

    @NativeType(value="uint32_t")
    public int height() {
        return VkExtent2D.nheight(this.address());
    }

    public VkExtent2D width(@NativeType(value="uint32_t") int value) {
        VkExtent2D.nwidth(this.address(), value);
        return this;
    }

    public VkExtent2D height(@NativeType(value="uint32_t") int value) {
        VkExtent2D.nheight(this.address(), value);
        return this;
    }

    public VkExtent2D set(int width, int height) {
        this.width(width);
        this.height(height);
        return this;
    }

    public VkExtent2D set(VkExtent2D src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkExtent2D malloc() {
        return new VkExtent2D(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkExtent2D calloc() {
        return new VkExtent2D(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkExtent2D create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkExtent2D(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkExtent2D create(long address) {
        return new VkExtent2D(address, null);
    }

    public static @Nullable VkExtent2D createSafe(long address) {
        return address == 0L ? null : new VkExtent2D(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkExtent2D.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkExtent2D.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkExtent2D mallocStack() {
        return VkExtent2D.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExtent2D callocStack() {
        return VkExtent2D.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExtent2D mallocStack(MemoryStack stack) {
        return VkExtent2D.malloc(stack);
    }

    @Deprecated
    public static VkExtent2D callocStack(MemoryStack stack) {
        return VkExtent2D.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkExtent2D.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkExtent2D.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExtent2D.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExtent2D.calloc(capacity, stack);
    }

    public static VkExtent2D malloc(MemoryStack stack) {
        return new VkExtent2D(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkExtent2D calloc(MemoryStack stack) {
        return new VkExtent2D(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nwidth(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)WIDTH));
    }

    public static int nheight(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)HEIGHT));
    }

    public static void nwidth(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)WIDTH), (int)value);
    }

    public static void nheight(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)HEIGHT), (int)value);
    }

    static {
        Struct.Layout layout = VkExtent2D.__struct((Struct.Member[])new Struct.Member[]{VkExtent2D.__member((int)4), VkExtent2D.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        WIDTH = layout.offsetof(0);
        HEIGHT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkExtent2D, Buffer>
    implements NativeResource {
        private static final VkExtent2D ELEMENT_FACTORY = VkExtent2D.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkExtent2D getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int width() {
            return VkExtent2D.nwidth(this.address());
        }

        @NativeType(value="uint32_t")
        public int height() {
            return VkExtent2D.nheight(this.address());
        }

        public Buffer width(@NativeType(value="uint32_t") int value) {
            VkExtent2D.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(@NativeType(value="uint32_t") int value) {
            VkExtent2D.nheight(this.address(), value);
            return this;
        }
    }
}

