/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkFrameBoundaryEXT
extends Struct<VkFrameBoundaryEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int FRAMEID;
    public static final int IMAGECOUNT;
    public static final int PIMAGES;
    public static final int BUFFERCOUNT;
    public static final int PBUFFERS;
    public static final int TAGNAME;
    public static final int TAGSIZE;
    public static final int PTAG;

    protected VkFrameBoundaryEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkFrameBoundaryEXT create(long address, @Nullable ByteBuffer container) {
        return new VkFrameBoundaryEXT(address, container);
    }

    public VkFrameBoundaryEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkFrameBoundaryEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkFrameBoundaryEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkFrameBoundaryEXT.npNext(this.address());
    }

    @NativeType(value="VkFrameBoundaryFlagsEXT")
    public int flags() {
        return VkFrameBoundaryEXT.nflags(this.address());
    }

    @NativeType(value="uint64_t")
    public long frameID() {
        return VkFrameBoundaryEXT.nframeID(this.address());
    }

    @NativeType(value="uint32_t")
    public int imageCount() {
        return VkFrameBoundaryEXT.nimageCount(this.address());
    }

    @NativeType(value="VkImage const *")
    public @Nullable LongBuffer pImages() {
        return VkFrameBoundaryEXT.npImages(this.address());
    }

    @NativeType(value="uint32_t")
    public int bufferCount() {
        return VkFrameBoundaryEXT.nbufferCount(this.address());
    }

    @NativeType(value="VkBuffer const *")
    public @Nullable LongBuffer pBuffers() {
        return VkFrameBoundaryEXT.npBuffers(this.address());
    }

    @NativeType(value="uint64_t")
    public long tagName() {
        return VkFrameBoundaryEXT.ntagName(this.address());
    }

    @NativeType(value="size_t")
    public long tagSize() {
        return VkFrameBoundaryEXT.ntagSize(this.address());
    }

    @NativeType(value="void const *")
    public @Nullable ByteBuffer pTag() {
        return VkFrameBoundaryEXT.npTag(this.address());
    }

    public VkFrameBoundaryEXT sType(@NativeType(value="VkStructureType") int value) {
        VkFrameBoundaryEXT.nsType(this.address(), value);
        return this;
    }

    public VkFrameBoundaryEXT sType$Default() {
        return this.sType(1000375001);
    }

    public VkFrameBoundaryEXT pNext(@NativeType(value="void const *") long value) {
        VkFrameBoundaryEXT.npNext(this.address(), value);
        return this;
    }

    public VkFrameBoundaryEXT flags(@NativeType(value="VkFrameBoundaryFlagsEXT") int value) {
        VkFrameBoundaryEXT.nflags(this.address(), value);
        return this;
    }

    public VkFrameBoundaryEXT frameID(@NativeType(value="uint64_t") long value) {
        VkFrameBoundaryEXT.nframeID(this.address(), value);
        return this;
    }

    public VkFrameBoundaryEXT imageCount(@NativeType(value="uint32_t") int value) {
        VkFrameBoundaryEXT.nimageCount(this.address(), value);
        return this;
    }

    public VkFrameBoundaryEXT pImages(@NativeType(value="VkImage const *") @Nullable LongBuffer value) {
        VkFrameBoundaryEXT.npImages(this.address(), value);
        return this;
    }

    public VkFrameBoundaryEXT bufferCount(@NativeType(value="uint32_t") int value) {
        VkFrameBoundaryEXT.nbufferCount(this.address(), value);
        return this;
    }

    public VkFrameBoundaryEXT pBuffers(@NativeType(value="VkBuffer const *") @Nullable LongBuffer value) {
        VkFrameBoundaryEXT.npBuffers(this.address(), value);
        return this;
    }

    public VkFrameBoundaryEXT tagName(@NativeType(value="uint64_t") long value) {
        VkFrameBoundaryEXT.ntagName(this.address(), value);
        return this;
    }

    public VkFrameBoundaryEXT tagSize(@NativeType(value="size_t") long value) {
        VkFrameBoundaryEXT.ntagSize(this.address(), value);
        return this;
    }

    public VkFrameBoundaryEXT pTag(@NativeType(value="void const *") @Nullable ByteBuffer value) {
        VkFrameBoundaryEXT.npTag(this.address(), value);
        return this;
    }

    public VkFrameBoundaryEXT set(int sType, long pNext, int flags, long frameID, int imageCount, @Nullable LongBuffer pImages, int bufferCount, @Nullable LongBuffer pBuffers, long tagName, long tagSize, @Nullable ByteBuffer pTag) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.frameID(frameID);
        this.imageCount(imageCount);
        this.pImages(pImages);
        this.bufferCount(bufferCount);
        this.pBuffers(pBuffers);
        this.tagName(tagName);
        this.tagSize(tagSize);
        this.pTag(pTag);
        return this;
    }

    public VkFrameBoundaryEXT set(VkFrameBoundaryEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkFrameBoundaryEXT malloc() {
        return new VkFrameBoundaryEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkFrameBoundaryEXT calloc() {
        return new VkFrameBoundaryEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkFrameBoundaryEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkFrameBoundaryEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkFrameBoundaryEXT create(long address) {
        return new VkFrameBoundaryEXT(address, null);
    }

    public static @Nullable VkFrameBoundaryEXT createSafe(long address) {
        return address == 0L ? null : new VkFrameBoundaryEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkFrameBoundaryEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkFrameBoundaryEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkFrameBoundaryEXT malloc(MemoryStack stack) {
        return new VkFrameBoundaryEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkFrameBoundaryEXT calloc(MemoryStack stack) {
        return new VkFrameBoundaryEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FLAGS));
    }

    public static long nframeID(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)FRAMEID));
    }

    public static int nimageCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)IMAGECOUNT));
    }

    public static @Nullable LongBuffer npImages(long struct) {
        return MemoryUtil.memLongBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PIMAGES)), (int)VkFrameBoundaryEXT.nimageCount(struct));
    }

    public static int nbufferCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)BUFFERCOUNT));
    }

    public static @Nullable LongBuffer npBuffers(long struct) {
        return MemoryUtil.memLongBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PBUFFERS)), (int)VkFrameBoundaryEXT.nbufferCount(struct));
    }

    public static long ntagName(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)TAGNAME));
    }

    public static long ntagSize(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)TAGSIZE));
    }

    public static @Nullable ByteBuffer npTag(long struct) {
        return MemoryUtil.memByteBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PTAG)), (int)((int)VkFrameBoundaryEXT.ntagSize(struct)));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FLAGS), (int)value);
    }

    public static void nframeID(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)FRAMEID), (long)value);
    }

    public static void nimageCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)IMAGECOUNT), (int)value);
    }

    public static void npImages(long struct, @Nullable LongBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PIMAGES), (long)MemoryUtil.memAddressSafe((LongBuffer)value));
        if (value != null) {
            VkFrameBoundaryEXT.nimageCount(struct, value.remaining());
        }
    }

    public static void nbufferCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)BUFFERCOUNT), (int)value);
    }

    public static void npBuffers(long struct, @Nullable LongBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PBUFFERS), (long)MemoryUtil.memAddressSafe((LongBuffer)value));
        if (value != null) {
            VkFrameBoundaryEXT.nbufferCount(struct, value.remaining());
        }
    }

    public static void ntagName(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)TAGNAME), (long)value);
    }

    public static void ntagSize(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)TAGSIZE), (long)value);
    }

    public static void npTag(long struct, @Nullable ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PTAG), (long)MemoryUtil.memAddressSafe((ByteBuffer)value));
        if (value != null) {
            VkFrameBoundaryEXT.ntagSize(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = VkFrameBoundaryEXT.__struct((Struct.Member[])new Struct.Member[]{VkFrameBoundaryEXT.__member((int)4), VkFrameBoundaryEXT.__member((int)POINTER_SIZE), VkFrameBoundaryEXT.__member((int)4), VkFrameBoundaryEXT.__member((int)8), VkFrameBoundaryEXT.__member((int)4), VkFrameBoundaryEXT.__member((int)POINTER_SIZE), VkFrameBoundaryEXT.__member((int)4), VkFrameBoundaryEXT.__member((int)POINTER_SIZE), VkFrameBoundaryEXT.__member((int)8), VkFrameBoundaryEXT.__member((int)POINTER_SIZE), VkFrameBoundaryEXT.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        FRAMEID = layout.offsetof(3);
        IMAGECOUNT = layout.offsetof(4);
        PIMAGES = layout.offsetof(5);
        BUFFERCOUNT = layout.offsetof(6);
        PBUFFERS = layout.offsetof(7);
        TAGNAME = layout.offsetof(8);
        TAGSIZE = layout.offsetof(9);
        PTAG = layout.offsetof(10);
    }

    public static class Buffer
    extends StructBuffer<VkFrameBoundaryEXT, Buffer>
    implements NativeResource {
        private static final VkFrameBoundaryEXT ELEMENT_FACTORY = VkFrameBoundaryEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkFrameBoundaryEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkFrameBoundaryEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkFrameBoundaryEXT.npNext(this.address());
        }

        @NativeType(value="VkFrameBoundaryFlagsEXT")
        public int flags() {
            return VkFrameBoundaryEXT.nflags(this.address());
        }

        @NativeType(value="uint64_t")
        public long frameID() {
            return VkFrameBoundaryEXT.nframeID(this.address());
        }

        @NativeType(value="uint32_t")
        public int imageCount() {
            return VkFrameBoundaryEXT.nimageCount(this.address());
        }

        @NativeType(value="VkImage const *")
        public @Nullable LongBuffer pImages() {
            return VkFrameBoundaryEXT.npImages(this.address());
        }

        @NativeType(value="uint32_t")
        public int bufferCount() {
            return VkFrameBoundaryEXT.nbufferCount(this.address());
        }

        @NativeType(value="VkBuffer const *")
        public @Nullable LongBuffer pBuffers() {
            return VkFrameBoundaryEXT.npBuffers(this.address());
        }

        @NativeType(value="uint64_t")
        public long tagName() {
            return VkFrameBoundaryEXT.ntagName(this.address());
        }

        @NativeType(value="size_t")
        public long tagSize() {
            return VkFrameBoundaryEXT.ntagSize(this.address());
        }

        @NativeType(value="void const *")
        public @Nullable ByteBuffer pTag() {
            return VkFrameBoundaryEXT.npTag(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkFrameBoundaryEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000375001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkFrameBoundaryEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkFrameBoundaryFlagsEXT") int value) {
            VkFrameBoundaryEXT.nflags(this.address(), value);
            return this;
        }

        public Buffer frameID(@NativeType(value="uint64_t") long value) {
            VkFrameBoundaryEXT.nframeID(this.address(), value);
            return this;
        }

        public Buffer imageCount(@NativeType(value="uint32_t") int value) {
            VkFrameBoundaryEXT.nimageCount(this.address(), value);
            return this;
        }

        public Buffer pImages(@NativeType(value="VkImage const *") @Nullable LongBuffer value) {
            VkFrameBoundaryEXT.npImages(this.address(), value);
            return this;
        }

        public Buffer bufferCount(@NativeType(value="uint32_t") int value) {
            VkFrameBoundaryEXT.nbufferCount(this.address(), value);
            return this;
        }

        public Buffer pBuffers(@NativeType(value="VkBuffer const *") @Nullable LongBuffer value) {
            VkFrameBoundaryEXT.npBuffers(this.address(), value);
            return this;
        }

        public Buffer tagName(@NativeType(value="uint64_t") long value) {
            VkFrameBoundaryEXT.ntagName(this.address(), value);
            return this;
        }

        public Buffer tagSize(@NativeType(value="size_t") long value) {
            VkFrameBoundaryEXT.ntagSize(this.address(), value);
            return this;
        }

        public Buffer pTag(@NativeType(value="void const *") @Nullable ByteBuffer value) {
            VkFrameBoundaryEXT.npTag(this.address(), value);
            return this;
        }
    }
}

