/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkHostImageLayoutTransitionInfo;
import org.lwjgl.vulkan.VkImageSubresourceRange;

public class VkHostImageLayoutTransitionInfoEXT
extends VkHostImageLayoutTransitionInfo {
    protected VkHostImageLayoutTransitionInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkHostImageLayoutTransitionInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkHostImageLayoutTransitionInfoEXT(address, container);
    }

    public VkHostImageLayoutTransitionInfoEXT(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkHostImageLayoutTransitionInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkHostImageLayoutTransitionInfoEXT.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkHostImageLayoutTransitionInfoEXT sType$Default() {
        return this.sType(1000270006);
    }

    @Override
    public VkHostImageLayoutTransitionInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkHostImageLayoutTransitionInfoEXT.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkHostImageLayoutTransitionInfoEXT image(@NativeType(value="VkImage") long value) {
        VkHostImageLayoutTransitionInfoEXT.nimage(this.address(), value);
        return this;
    }

    @Override
    public VkHostImageLayoutTransitionInfoEXT oldLayout(@NativeType(value="VkImageLayout") int value) {
        VkHostImageLayoutTransitionInfoEXT.noldLayout(this.address(), value);
        return this;
    }

    @Override
    public VkHostImageLayoutTransitionInfoEXT newLayout(@NativeType(value="VkImageLayout") int value) {
        VkHostImageLayoutTransitionInfoEXT.nnewLayout(this.address(), value);
        return this;
    }

    @Override
    public VkHostImageLayoutTransitionInfoEXT subresourceRange(VkImageSubresourceRange value) {
        VkHostImageLayoutTransitionInfoEXT.nsubresourceRange(this.address(), value);
        return this;
    }

    @Override
    public VkHostImageLayoutTransitionInfoEXT subresourceRange(Consumer<VkImageSubresourceRange> consumer) {
        consumer.accept(this.subresourceRange());
        return this;
    }

    @Override
    public VkHostImageLayoutTransitionInfoEXT set(int sType, long pNext, long image, int oldLayout, int newLayout, VkImageSubresourceRange subresourceRange) {
        this.sType(sType);
        this.pNext(pNext);
        this.image(image);
        this.oldLayout(oldLayout);
        this.newLayout(newLayout);
        this.subresourceRange(subresourceRange);
        return this;
    }

    public VkHostImageLayoutTransitionInfoEXT set(VkHostImageLayoutTransitionInfoEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkHostImageLayoutTransitionInfoEXT malloc() {
        return new VkHostImageLayoutTransitionInfoEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkHostImageLayoutTransitionInfoEXT calloc() {
        return new VkHostImageLayoutTransitionInfoEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkHostImageLayoutTransitionInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkHostImageLayoutTransitionInfoEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkHostImageLayoutTransitionInfoEXT create(long address) {
        return new VkHostImageLayoutTransitionInfoEXT(address, null);
    }

    public static @Nullable VkHostImageLayoutTransitionInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkHostImageLayoutTransitionInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkHostImageLayoutTransitionInfoEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkHostImageLayoutTransitionInfoEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkHostImageLayoutTransitionInfoEXT malloc(MemoryStack stack) {
        return new VkHostImageLayoutTransitionInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkHostImageLayoutTransitionInfoEXT calloc(MemoryStack stack) {
        return new VkHostImageLayoutTransitionInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkHostImageLayoutTransitionInfo.Buffer {
        private static final VkHostImageLayoutTransitionInfoEXT ELEMENT_FACTORY = VkHostImageLayoutTransitionInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkHostImageLayoutTransitionInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkHostImageLayoutTransitionInfoEXT.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000270006);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkHostImageLayoutTransitionInfoEXT.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer image(@NativeType(value="VkImage") long value) {
            VkHostImageLayoutTransitionInfoEXT.nimage(this.address(), value);
            return this;
        }

        @Override
        public Buffer oldLayout(@NativeType(value="VkImageLayout") int value) {
            VkHostImageLayoutTransitionInfoEXT.noldLayout(this.address(), value);
            return this;
        }

        @Override
        public Buffer newLayout(@NativeType(value="VkImageLayout") int value) {
            VkHostImageLayoutTransitionInfoEXT.nnewLayout(this.address(), value);
            return this;
        }

        @Override
        public Buffer subresourceRange(VkImageSubresourceRange value) {
            VkHostImageLayoutTransitionInfoEXT.nsubresourceRange(this.address(), value);
            return this;
        }

        @Override
        public Buffer subresourceRange(Consumer<VkImageSubresourceRange> consumer) {
            consumer.accept(this.subresourceRange());
            return this;
        }
    }
}

