/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkIndirectCommandsLayoutTokenEXT;
import org.lwjgl.vulkan.VkPipelineLayoutCreateInfo;

public class VkIndirectCommandsLayoutCreateInfoEXT
extends Struct<VkIndirectCommandsLayoutCreateInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int SHADERSTAGES;
    public static final int INDIRECTSTRIDE;
    public static final int PIPELINELAYOUT;
    public static final int TOKENCOUNT;
    public static final int PTOKENS;

    protected VkIndirectCommandsLayoutCreateInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkIndirectCommandsLayoutCreateInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkIndirectCommandsLayoutCreateInfoEXT(address, container);
    }

    public VkIndirectCommandsLayoutCreateInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkIndirectCommandsLayoutCreateInfoEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkIndirectCommandsLayoutCreateInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkIndirectCommandsLayoutCreateInfoEXT.npNext(this.address());
    }

    @NativeType(value="VkIndirectCommandsLayoutUsageFlagsEXT")
    public int flags() {
        return VkIndirectCommandsLayoutCreateInfoEXT.nflags(this.address());
    }

    @NativeType(value="VkShaderStageFlags")
    public int shaderStages() {
        return VkIndirectCommandsLayoutCreateInfoEXT.nshaderStages(this.address());
    }

    @NativeType(value="uint32_t")
    public int indirectStride() {
        return VkIndirectCommandsLayoutCreateInfoEXT.nindirectStride(this.address());
    }

    @NativeType(value="VkPipelineLayout")
    public long pipelineLayout() {
        return VkIndirectCommandsLayoutCreateInfoEXT.npipelineLayout(this.address());
    }

    @NativeType(value="uint32_t")
    public int tokenCount() {
        return VkIndirectCommandsLayoutCreateInfoEXT.ntokenCount(this.address());
    }

    @NativeType(value="VkIndirectCommandsLayoutTokenEXT const *")
    public VkIndirectCommandsLayoutTokenEXT.Buffer pTokens() {
        return VkIndirectCommandsLayoutCreateInfoEXT.npTokens(this.address());
    }

    public VkIndirectCommandsLayoutCreateInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkIndirectCommandsLayoutCreateInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutCreateInfoEXT sType$Default() {
        return this.sType(1000572006);
    }

    public VkIndirectCommandsLayoutCreateInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkIndirectCommandsLayoutCreateInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutCreateInfoEXT pNext(VkPipelineLayoutCreateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkIndirectCommandsLayoutCreateInfoEXT flags(@NativeType(value="VkIndirectCommandsLayoutUsageFlagsEXT") int value) {
        VkIndirectCommandsLayoutCreateInfoEXT.nflags(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutCreateInfoEXT shaderStages(@NativeType(value="VkShaderStageFlags") int value) {
        VkIndirectCommandsLayoutCreateInfoEXT.nshaderStages(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutCreateInfoEXT indirectStride(@NativeType(value="uint32_t") int value) {
        VkIndirectCommandsLayoutCreateInfoEXT.nindirectStride(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutCreateInfoEXT pipelineLayout(@NativeType(value="VkPipelineLayout") long value) {
        VkIndirectCommandsLayoutCreateInfoEXT.npipelineLayout(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutCreateInfoEXT pTokens(@NativeType(value="VkIndirectCommandsLayoutTokenEXT const *") VkIndirectCommandsLayoutTokenEXT.Buffer value) {
        VkIndirectCommandsLayoutCreateInfoEXT.npTokens(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutCreateInfoEXT set(int sType, long pNext, int flags, int shaderStages, int indirectStride, long pipelineLayout, VkIndirectCommandsLayoutTokenEXT.Buffer pTokens) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.shaderStages(shaderStages);
        this.indirectStride(indirectStride);
        this.pipelineLayout(pipelineLayout);
        this.pTokens(pTokens);
        return this;
    }

    public VkIndirectCommandsLayoutCreateInfoEXT set(VkIndirectCommandsLayoutCreateInfoEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkIndirectCommandsLayoutCreateInfoEXT malloc() {
        return new VkIndirectCommandsLayoutCreateInfoEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkIndirectCommandsLayoutCreateInfoEXT calloc() {
        return new VkIndirectCommandsLayoutCreateInfoEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkIndirectCommandsLayoutCreateInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkIndirectCommandsLayoutCreateInfoEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkIndirectCommandsLayoutCreateInfoEXT create(long address) {
        return new VkIndirectCommandsLayoutCreateInfoEXT(address, null);
    }

    public static @Nullable VkIndirectCommandsLayoutCreateInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkIndirectCommandsLayoutCreateInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkIndirectCommandsLayoutCreateInfoEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkIndirectCommandsLayoutCreateInfoEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkIndirectCommandsLayoutCreateInfoEXT malloc(MemoryStack stack) {
        return new VkIndirectCommandsLayoutCreateInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkIndirectCommandsLayoutCreateInfoEXT calloc(MemoryStack stack) {
        return new VkIndirectCommandsLayoutCreateInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FLAGS));
    }

    public static int nshaderStages(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SHADERSTAGES));
    }

    public static int nindirectStride(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)INDIRECTSTRIDE));
    }

    public static long npipelineLayout(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)PIPELINELAYOUT));
    }

    public static int ntokenCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TOKENCOUNT));
    }

    public static VkIndirectCommandsLayoutTokenEXT.Buffer npTokens(long struct) {
        return VkIndirectCommandsLayoutTokenEXT.create(MemoryUtil.memGetAddress((long)(struct + (long)PTOKENS)), VkIndirectCommandsLayoutCreateInfoEXT.ntokenCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FLAGS), (int)value);
    }

    public static void nshaderStages(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SHADERSTAGES), (int)value);
    }

    public static void nindirectStride(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)INDIRECTSTRIDE), (int)value);
    }

    public static void npipelineLayout(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)PIPELINELAYOUT), (long)value);
    }

    public static void ntokenCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TOKENCOUNT), (int)value);
    }

    public static void npTokens(long struct, VkIndirectCommandsLayoutTokenEXT.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PTOKENS), (long)value.address());
        VkIndirectCommandsLayoutCreateInfoEXT.ntokenCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PTOKENS)));
    }

    static {
        Struct.Layout layout = VkIndirectCommandsLayoutCreateInfoEXT.__struct((Struct.Member[])new Struct.Member[]{VkIndirectCommandsLayoutCreateInfoEXT.__member((int)4), VkIndirectCommandsLayoutCreateInfoEXT.__member((int)POINTER_SIZE), VkIndirectCommandsLayoutCreateInfoEXT.__member((int)4), VkIndirectCommandsLayoutCreateInfoEXT.__member((int)4), VkIndirectCommandsLayoutCreateInfoEXT.__member((int)4), VkIndirectCommandsLayoutCreateInfoEXT.__member((int)8), VkIndirectCommandsLayoutCreateInfoEXT.__member((int)4), VkIndirectCommandsLayoutCreateInfoEXT.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        SHADERSTAGES = layout.offsetof(3);
        INDIRECTSTRIDE = layout.offsetof(4);
        PIPELINELAYOUT = layout.offsetof(5);
        TOKENCOUNT = layout.offsetof(6);
        PTOKENS = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkIndirectCommandsLayoutCreateInfoEXT, Buffer>
    implements NativeResource {
        private static final VkIndirectCommandsLayoutCreateInfoEXT ELEMENT_FACTORY = VkIndirectCommandsLayoutCreateInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkIndirectCommandsLayoutCreateInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkIndirectCommandsLayoutCreateInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkIndirectCommandsLayoutCreateInfoEXT.npNext(this.address());
        }

        @NativeType(value="VkIndirectCommandsLayoutUsageFlagsEXT")
        public int flags() {
            return VkIndirectCommandsLayoutCreateInfoEXT.nflags(this.address());
        }

        @NativeType(value="VkShaderStageFlags")
        public int shaderStages() {
            return VkIndirectCommandsLayoutCreateInfoEXT.nshaderStages(this.address());
        }

        @NativeType(value="uint32_t")
        public int indirectStride() {
            return VkIndirectCommandsLayoutCreateInfoEXT.nindirectStride(this.address());
        }

        @NativeType(value="VkPipelineLayout")
        public long pipelineLayout() {
            return VkIndirectCommandsLayoutCreateInfoEXT.npipelineLayout(this.address());
        }

        @NativeType(value="uint32_t")
        public int tokenCount() {
            return VkIndirectCommandsLayoutCreateInfoEXT.ntokenCount(this.address());
        }

        @NativeType(value="VkIndirectCommandsLayoutTokenEXT const *")
        public VkIndirectCommandsLayoutTokenEXT.Buffer pTokens() {
            return VkIndirectCommandsLayoutCreateInfoEXT.npTokens(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkIndirectCommandsLayoutCreateInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000572006);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkIndirectCommandsLayoutCreateInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkPipelineLayoutCreateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkIndirectCommandsLayoutUsageFlagsEXT") int value) {
            VkIndirectCommandsLayoutCreateInfoEXT.nflags(this.address(), value);
            return this;
        }

        public Buffer shaderStages(@NativeType(value="VkShaderStageFlags") int value) {
            VkIndirectCommandsLayoutCreateInfoEXT.nshaderStages(this.address(), value);
            return this;
        }

        public Buffer indirectStride(@NativeType(value="uint32_t") int value) {
            VkIndirectCommandsLayoutCreateInfoEXT.nindirectStride(this.address(), value);
            return this;
        }

        public Buffer pipelineLayout(@NativeType(value="VkPipelineLayout") long value) {
            VkIndirectCommandsLayoutCreateInfoEXT.npipelineLayout(this.address(), value);
            return this;
        }

        public Buffer pTokens(@NativeType(value="VkIndirectCommandsLayoutTokenEXT const *") VkIndirectCommandsLayoutTokenEXT.Buffer value) {
            VkIndirectCommandsLayoutCreateInfoEXT.npTokens(this.address(), value);
            return this;
        }
    }
}

