/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkIndirectCommandsLayoutTokenNV;

public class VkIndirectCommandsLayoutCreateInfoNV
extends Struct<VkIndirectCommandsLayoutCreateInfoNV>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int PIPELINEBINDPOINT;
    public static final int TOKENCOUNT;
    public static final int PTOKENS;
    public static final int STREAMCOUNT;
    public static final int PSTREAMSTRIDES;

    protected VkIndirectCommandsLayoutCreateInfoNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkIndirectCommandsLayoutCreateInfoNV create(long address, @Nullable ByteBuffer container) {
        return new VkIndirectCommandsLayoutCreateInfoNV(address, container);
    }

    public VkIndirectCommandsLayoutCreateInfoNV(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkIndirectCommandsLayoutCreateInfoNV.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkIndirectCommandsLayoutCreateInfoNV.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkIndirectCommandsLayoutCreateInfoNV.npNext(this.address());
    }

    @NativeType(value="VkIndirectCommandsLayoutUsageFlagsNV")
    public int flags() {
        return VkIndirectCommandsLayoutCreateInfoNV.nflags(this.address());
    }

    @NativeType(value="VkPipelineBindPoint")
    public int pipelineBindPoint() {
        return VkIndirectCommandsLayoutCreateInfoNV.npipelineBindPoint(this.address());
    }

    @NativeType(value="uint32_t")
    public int tokenCount() {
        return VkIndirectCommandsLayoutCreateInfoNV.ntokenCount(this.address());
    }

    @NativeType(value="VkIndirectCommandsLayoutTokenNV const *")
    public VkIndirectCommandsLayoutTokenNV.Buffer pTokens() {
        return VkIndirectCommandsLayoutCreateInfoNV.npTokens(this.address());
    }

    @NativeType(value="uint32_t")
    public int streamCount() {
        return VkIndirectCommandsLayoutCreateInfoNV.nstreamCount(this.address());
    }

    @NativeType(value="uint32_t const *")
    public IntBuffer pStreamStrides() {
        return VkIndirectCommandsLayoutCreateInfoNV.npStreamStrides(this.address());
    }

    public VkIndirectCommandsLayoutCreateInfoNV sType(@NativeType(value="VkStructureType") int value) {
        VkIndirectCommandsLayoutCreateInfoNV.nsType(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutCreateInfoNV sType$Default() {
        return this.sType(1000277004);
    }

    public VkIndirectCommandsLayoutCreateInfoNV pNext(@NativeType(value="void const *") long value) {
        VkIndirectCommandsLayoutCreateInfoNV.npNext(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutCreateInfoNV flags(@NativeType(value="VkIndirectCommandsLayoutUsageFlagsNV") int value) {
        VkIndirectCommandsLayoutCreateInfoNV.nflags(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutCreateInfoNV pipelineBindPoint(@NativeType(value="VkPipelineBindPoint") int value) {
        VkIndirectCommandsLayoutCreateInfoNV.npipelineBindPoint(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutCreateInfoNV pTokens(@NativeType(value="VkIndirectCommandsLayoutTokenNV const *") VkIndirectCommandsLayoutTokenNV.Buffer value) {
        VkIndirectCommandsLayoutCreateInfoNV.npTokens(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutCreateInfoNV pStreamStrides(@NativeType(value="uint32_t const *") IntBuffer value) {
        VkIndirectCommandsLayoutCreateInfoNV.npStreamStrides(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutCreateInfoNV set(int sType, long pNext, int flags, int pipelineBindPoint, VkIndirectCommandsLayoutTokenNV.Buffer pTokens, IntBuffer pStreamStrides) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pipelineBindPoint(pipelineBindPoint);
        this.pTokens(pTokens);
        this.pStreamStrides(pStreamStrides);
        return this;
    }

    public VkIndirectCommandsLayoutCreateInfoNV set(VkIndirectCommandsLayoutCreateInfoNV src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkIndirectCommandsLayoutCreateInfoNV malloc() {
        return new VkIndirectCommandsLayoutCreateInfoNV(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkIndirectCommandsLayoutCreateInfoNV calloc() {
        return new VkIndirectCommandsLayoutCreateInfoNV(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkIndirectCommandsLayoutCreateInfoNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkIndirectCommandsLayoutCreateInfoNV(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkIndirectCommandsLayoutCreateInfoNV create(long address) {
        return new VkIndirectCommandsLayoutCreateInfoNV(address, null);
    }

    public static @Nullable VkIndirectCommandsLayoutCreateInfoNV createSafe(long address) {
        return address == 0L ? null : new VkIndirectCommandsLayoutCreateInfoNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkIndirectCommandsLayoutCreateInfoNV.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkIndirectCommandsLayoutCreateInfoNV.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkIndirectCommandsLayoutCreateInfoNV malloc(MemoryStack stack) {
        return new VkIndirectCommandsLayoutCreateInfoNV(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkIndirectCommandsLayoutCreateInfoNV calloc(MemoryStack stack) {
        return new VkIndirectCommandsLayoutCreateInfoNV(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FLAGS));
    }

    public static int npipelineBindPoint(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)PIPELINEBINDPOINT));
    }

    public static int ntokenCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TOKENCOUNT));
    }

    public static VkIndirectCommandsLayoutTokenNV.Buffer npTokens(long struct) {
        return VkIndirectCommandsLayoutTokenNV.create(MemoryUtil.memGetAddress((long)(struct + (long)PTOKENS)), VkIndirectCommandsLayoutCreateInfoNV.ntokenCount(struct));
    }

    public static int nstreamCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STREAMCOUNT));
    }

    public static IntBuffer npStreamStrides(long struct) {
        return MemoryUtil.memIntBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PSTREAMSTRIDES)), (int)VkIndirectCommandsLayoutCreateInfoNV.nstreamCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FLAGS), (int)value);
    }

    public static void npipelineBindPoint(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)PIPELINEBINDPOINT), (int)value);
    }

    public static void ntokenCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TOKENCOUNT), (int)value);
    }

    public static void npTokens(long struct, VkIndirectCommandsLayoutTokenNV.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PTOKENS), (long)value.address());
        VkIndirectCommandsLayoutCreateInfoNV.ntokenCount(struct, value.remaining());
    }

    public static void nstreamCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STREAMCOUNT), (int)value);
    }

    public static void npStreamStrides(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PSTREAMSTRIDES), (long)MemoryUtil.memAddress((IntBuffer)value));
        VkIndirectCommandsLayoutCreateInfoNV.nstreamCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        int tokenCount = VkIndirectCommandsLayoutCreateInfoNV.ntokenCount(struct);
        long pTokens = MemoryUtil.memGetAddress((long)(struct + (long)PTOKENS));
        Checks.check((long)pTokens);
        VkIndirectCommandsLayoutCreateInfoNV.validate((long)pTokens, (int)tokenCount, (int)VkIndirectCommandsLayoutTokenNV.SIZEOF, VkIndirectCommandsLayoutTokenNV::validate);
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PSTREAMSTRIDES)));
    }

    static {
        Struct.Layout layout = VkIndirectCommandsLayoutCreateInfoNV.__struct((Struct.Member[])new Struct.Member[]{VkIndirectCommandsLayoutCreateInfoNV.__member((int)4), VkIndirectCommandsLayoutCreateInfoNV.__member((int)POINTER_SIZE), VkIndirectCommandsLayoutCreateInfoNV.__member((int)4), VkIndirectCommandsLayoutCreateInfoNV.__member((int)4), VkIndirectCommandsLayoutCreateInfoNV.__member((int)4), VkIndirectCommandsLayoutCreateInfoNV.__member((int)POINTER_SIZE), VkIndirectCommandsLayoutCreateInfoNV.__member((int)4), VkIndirectCommandsLayoutCreateInfoNV.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        PIPELINEBINDPOINT = layout.offsetof(3);
        TOKENCOUNT = layout.offsetof(4);
        PTOKENS = layout.offsetof(5);
        STREAMCOUNT = layout.offsetof(6);
        PSTREAMSTRIDES = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkIndirectCommandsLayoutCreateInfoNV, Buffer>
    implements NativeResource {
        private static final VkIndirectCommandsLayoutCreateInfoNV ELEMENT_FACTORY = VkIndirectCommandsLayoutCreateInfoNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkIndirectCommandsLayoutCreateInfoNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkIndirectCommandsLayoutCreateInfoNV.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkIndirectCommandsLayoutCreateInfoNV.npNext(this.address());
        }

        @NativeType(value="VkIndirectCommandsLayoutUsageFlagsNV")
        public int flags() {
            return VkIndirectCommandsLayoutCreateInfoNV.nflags(this.address());
        }

        @NativeType(value="VkPipelineBindPoint")
        public int pipelineBindPoint() {
            return VkIndirectCommandsLayoutCreateInfoNV.npipelineBindPoint(this.address());
        }

        @NativeType(value="uint32_t")
        public int tokenCount() {
            return VkIndirectCommandsLayoutCreateInfoNV.ntokenCount(this.address());
        }

        @NativeType(value="VkIndirectCommandsLayoutTokenNV const *")
        public VkIndirectCommandsLayoutTokenNV.Buffer pTokens() {
            return VkIndirectCommandsLayoutCreateInfoNV.npTokens(this.address());
        }

        @NativeType(value="uint32_t")
        public int streamCount() {
            return VkIndirectCommandsLayoutCreateInfoNV.nstreamCount(this.address());
        }

        @NativeType(value="uint32_t const *")
        public IntBuffer pStreamStrides() {
            return VkIndirectCommandsLayoutCreateInfoNV.npStreamStrides(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkIndirectCommandsLayoutCreateInfoNV.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000277004);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkIndirectCommandsLayoutCreateInfoNV.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkIndirectCommandsLayoutUsageFlagsNV") int value) {
            VkIndirectCommandsLayoutCreateInfoNV.nflags(this.address(), value);
            return this;
        }

        public Buffer pipelineBindPoint(@NativeType(value="VkPipelineBindPoint") int value) {
            VkIndirectCommandsLayoutCreateInfoNV.npipelineBindPoint(this.address(), value);
            return this;
        }

        public Buffer pTokens(@NativeType(value="VkIndirectCommandsLayoutTokenNV const *") VkIndirectCommandsLayoutTokenNV.Buffer value) {
            VkIndirectCommandsLayoutCreateInfoNV.npTokens(this.address(), value);
            return this;
        }

        public Buffer pStreamStrides(@NativeType(value="uint32_t const *") IntBuffer value) {
            VkIndirectCommandsLayoutCreateInfoNV.npStreamStrides(this.address(), value);
            return this;
        }
    }
}

