/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkLayerSettingEXT;

public class VkLayerSettingsCreateInfoEXT
extends Struct<VkLayerSettingsCreateInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SETTINGCOUNT;
    public static final int PSETTINGS;

    protected VkLayerSettingsCreateInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkLayerSettingsCreateInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkLayerSettingsCreateInfoEXT(address, container);
    }

    public VkLayerSettingsCreateInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkLayerSettingsCreateInfoEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkLayerSettingsCreateInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkLayerSettingsCreateInfoEXT.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int settingCount() {
        return VkLayerSettingsCreateInfoEXT.nsettingCount(this.address());
    }

    @NativeType(value="VkLayerSettingEXT const *")
    public @Nullable VkLayerSettingEXT.Buffer pSettings() {
        return VkLayerSettingsCreateInfoEXT.npSettings(this.address());
    }

    public VkLayerSettingsCreateInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkLayerSettingsCreateInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkLayerSettingsCreateInfoEXT sType$Default() {
        return this.sType(1000496000);
    }

    public VkLayerSettingsCreateInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkLayerSettingsCreateInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkLayerSettingsCreateInfoEXT pSettings(@NativeType(value="VkLayerSettingEXT const *") @Nullable VkLayerSettingEXT.Buffer value) {
        VkLayerSettingsCreateInfoEXT.npSettings(this.address(), value);
        return this;
    }

    public VkLayerSettingsCreateInfoEXT set(int sType, long pNext, @Nullable VkLayerSettingEXT.Buffer pSettings) {
        this.sType(sType);
        this.pNext(pNext);
        this.pSettings(pSettings);
        return this;
    }

    public VkLayerSettingsCreateInfoEXT set(VkLayerSettingsCreateInfoEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkLayerSettingsCreateInfoEXT malloc() {
        return new VkLayerSettingsCreateInfoEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkLayerSettingsCreateInfoEXT calloc() {
        return new VkLayerSettingsCreateInfoEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkLayerSettingsCreateInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkLayerSettingsCreateInfoEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkLayerSettingsCreateInfoEXT create(long address) {
        return new VkLayerSettingsCreateInfoEXT(address, null);
    }

    public static @Nullable VkLayerSettingsCreateInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkLayerSettingsCreateInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkLayerSettingsCreateInfoEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkLayerSettingsCreateInfoEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkLayerSettingsCreateInfoEXT malloc(MemoryStack stack) {
        return new VkLayerSettingsCreateInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkLayerSettingsCreateInfoEXT calloc(MemoryStack stack) {
        return new VkLayerSettingsCreateInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nsettingCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SETTINGCOUNT));
    }

    public static @Nullable VkLayerSettingEXT.Buffer npSettings(long struct) {
        return VkLayerSettingEXT.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PSETTINGS)), VkLayerSettingsCreateInfoEXT.nsettingCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nsettingCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SETTINGCOUNT), (int)value);
    }

    public static void npSettings(long struct, @Nullable VkLayerSettingEXT.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PSETTINGS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkLayerSettingsCreateInfoEXT.nsettingCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        int settingCount = VkLayerSettingsCreateInfoEXT.nsettingCount(struct);
        if (settingCount != 0) {
            long pSettings = MemoryUtil.memGetAddress((long)(struct + (long)PSETTINGS));
            Checks.check((long)pSettings);
            VkLayerSettingsCreateInfoEXT.validate((long)pSettings, (int)settingCount, (int)VkLayerSettingEXT.SIZEOF, VkLayerSettingEXT::validate);
        }
    }

    static {
        Struct.Layout layout = VkLayerSettingsCreateInfoEXT.__struct((Struct.Member[])new Struct.Member[]{VkLayerSettingsCreateInfoEXT.__member((int)4), VkLayerSettingsCreateInfoEXT.__member((int)POINTER_SIZE), VkLayerSettingsCreateInfoEXT.__member((int)4), VkLayerSettingsCreateInfoEXT.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SETTINGCOUNT = layout.offsetof(2);
        PSETTINGS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkLayerSettingsCreateInfoEXT, Buffer>
    implements NativeResource {
        private static final VkLayerSettingsCreateInfoEXT ELEMENT_FACTORY = VkLayerSettingsCreateInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkLayerSettingsCreateInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkLayerSettingsCreateInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkLayerSettingsCreateInfoEXT.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int settingCount() {
            return VkLayerSettingsCreateInfoEXT.nsettingCount(this.address());
        }

        @NativeType(value="VkLayerSettingEXT const *")
        public @Nullable VkLayerSettingEXT.Buffer pSettings() {
            return VkLayerSettingsCreateInfoEXT.npSettings(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkLayerSettingsCreateInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000496000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkLayerSettingsCreateInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer pSettings(@NativeType(value="VkLayerSettingEXT const *") @Nullable VkLayerSettingEXT.Buffer value) {
            VkLayerSettingsCreateInfoEXT.npSettings(this.address(), value);
            return this;
        }
    }
}

