/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMappedMemoryRange
extends Struct<VkMappedMemoryRange>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int MEMORY;
    public static final int OFFSET;
    public static final int SIZE;

    protected VkMappedMemoryRange(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkMappedMemoryRange create(long address, @Nullable ByteBuffer container) {
        return new VkMappedMemoryRange(address, container);
    }

    public VkMappedMemoryRange(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkMappedMemoryRange.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMappedMemoryRange.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkMappedMemoryRange.npNext(this.address());
    }

    @NativeType(value="VkDeviceMemory")
    public long memory() {
        return VkMappedMemoryRange.nmemory(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long offset() {
        return VkMappedMemoryRange.noffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VkMappedMemoryRange.nsize(this.address());
    }

    public VkMappedMemoryRange sType(@NativeType(value="VkStructureType") int value) {
        VkMappedMemoryRange.nsType(this.address(), value);
        return this;
    }

    public VkMappedMemoryRange sType$Default() {
        return this.sType(6);
    }

    public VkMappedMemoryRange pNext(@NativeType(value="void const *") long value) {
        VkMappedMemoryRange.npNext(this.address(), value);
        return this;
    }

    public VkMappedMemoryRange memory(@NativeType(value="VkDeviceMemory") long value) {
        VkMappedMemoryRange.nmemory(this.address(), value);
        return this;
    }

    public VkMappedMemoryRange offset(@NativeType(value="VkDeviceSize") long value) {
        VkMappedMemoryRange.noffset(this.address(), value);
        return this;
    }

    public VkMappedMemoryRange size(@NativeType(value="VkDeviceSize") long value) {
        VkMappedMemoryRange.nsize(this.address(), value);
        return this;
    }

    public VkMappedMemoryRange set(int sType, long pNext, long memory, long offset, long size) {
        this.sType(sType);
        this.pNext(pNext);
        this.memory(memory);
        this.offset(offset);
        this.size(size);
        return this;
    }

    public VkMappedMemoryRange set(VkMappedMemoryRange src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkMappedMemoryRange malloc() {
        return new VkMappedMemoryRange(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkMappedMemoryRange calloc() {
        return new VkMappedMemoryRange(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkMappedMemoryRange create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkMappedMemoryRange(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkMappedMemoryRange create(long address) {
        return new VkMappedMemoryRange(address, null);
    }

    public static @Nullable VkMappedMemoryRange createSafe(long address) {
        return address == 0L ? null : new VkMappedMemoryRange(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkMappedMemoryRange.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMappedMemoryRange.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkMappedMemoryRange mallocStack() {
        return VkMappedMemoryRange.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMappedMemoryRange callocStack() {
        return VkMappedMemoryRange.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMappedMemoryRange mallocStack(MemoryStack stack) {
        return VkMappedMemoryRange.malloc(stack);
    }

    @Deprecated
    public static VkMappedMemoryRange callocStack(MemoryStack stack) {
        return VkMappedMemoryRange.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkMappedMemoryRange.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkMappedMemoryRange.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMappedMemoryRange.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMappedMemoryRange.calloc(capacity, stack);
    }

    public static VkMappedMemoryRange malloc(MemoryStack stack) {
        return new VkMappedMemoryRange(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkMappedMemoryRange calloc(MemoryStack stack) {
        return new VkMappedMemoryRange(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long nmemory(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)MEMORY));
    }

    public static long noffset(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)OFFSET));
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)SIZE));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nmemory(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)MEMORY), (long)value);
    }

    public static void noffset(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)OFFSET), (long)value);
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)SIZE), (long)value);
    }

    static {
        Struct.Layout layout = VkMappedMemoryRange.__struct((Struct.Member[])new Struct.Member[]{VkMappedMemoryRange.__member((int)4), VkMappedMemoryRange.__member((int)POINTER_SIZE), VkMappedMemoryRange.__member((int)8), VkMappedMemoryRange.__member((int)8), VkMappedMemoryRange.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        MEMORY = layout.offsetof(2);
        OFFSET = layout.offsetof(3);
        SIZE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkMappedMemoryRange, Buffer>
    implements NativeResource {
        private static final VkMappedMemoryRange ELEMENT_FACTORY = VkMappedMemoryRange.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkMappedMemoryRange getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMappedMemoryRange.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkMappedMemoryRange.npNext(this.address());
        }

        @NativeType(value="VkDeviceMemory")
        public long memory() {
            return VkMappedMemoryRange.nmemory(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long offset() {
            return VkMappedMemoryRange.noffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VkMappedMemoryRange.nsize(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMappedMemoryRange.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(6);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMappedMemoryRange.npNext(this.address(), value);
            return this;
        }

        public Buffer memory(@NativeType(value="VkDeviceMemory") long value) {
            VkMappedMemoryRange.nmemory(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="VkDeviceSize") long value) {
            VkMappedMemoryRange.noffset(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="VkDeviceSize") long value) {
            VkMappedMemoryRange.nsize(this.address(), value);
            return this;
        }
    }
}

