/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDedicatedAllocationMemoryAllocateInfoNV;
import org.lwjgl.vulkan.VkExportMemoryAllocateInfo;
import org.lwjgl.vulkan.VkExportMemoryAllocateInfoKHR;
import org.lwjgl.vulkan.VkExportMemoryAllocateInfoNV;
import org.lwjgl.vulkan.VkExportMemoryWin32HandleInfoKHR;
import org.lwjgl.vulkan.VkExportMemoryWin32HandleInfoNV;
import org.lwjgl.vulkan.VkExportMetalObjectCreateInfoEXT;
import org.lwjgl.vulkan.VkImportAndroidHardwareBufferInfoANDROID;
import org.lwjgl.vulkan.VkImportMemoryFdInfoKHR;
import org.lwjgl.vulkan.VkImportMemoryHostPointerInfoEXT;
import org.lwjgl.vulkan.VkImportMemoryWin32HandleInfoKHR;
import org.lwjgl.vulkan.VkImportMemoryWin32HandleInfoNV;
import org.lwjgl.vulkan.VkImportMetalBufferInfoEXT;
import org.lwjgl.vulkan.VkMemoryAllocateFlagsInfo;
import org.lwjgl.vulkan.VkMemoryAllocateFlagsInfoKHR;
import org.lwjgl.vulkan.VkMemoryDedicatedAllocateInfo;
import org.lwjgl.vulkan.VkMemoryDedicatedAllocateInfoKHR;
import org.lwjgl.vulkan.VkMemoryOpaqueCaptureAddressAllocateInfo;
import org.lwjgl.vulkan.VkMemoryOpaqueCaptureAddressAllocateInfoKHR;
import org.lwjgl.vulkan.VkMemoryPriorityAllocateInfoEXT;

public class VkMemoryAllocateInfo
extends Struct<VkMemoryAllocateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int ALLOCATIONSIZE;
    public static final int MEMORYTYPEINDEX;

    protected VkMemoryAllocateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkMemoryAllocateInfo create(long address, @Nullable ByteBuffer container) {
        return new VkMemoryAllocateInfo(address, container);
    }

    public VkMemoryAllocateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkMemoryAllocateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMemoryAllocateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkMemoryAllocateInfo.npNext(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long allocationSize() {
        return VkMemoryAllocateInfo.nallocationSize(this.address());
    }

    @NativeType(value="uint32_t")
    public int memoryTypeIndex() {
        return VkMemoryAllocateInfo.nmemoryTypeIndex(this.address());
    }

    public VkMemoryAllocateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryAllocateInfo.nsType(this.address(), value);
        return this;
    }

    public VkMemoryAllocateInfo sType$Default() {
        return this.sType(5);
    }

    public VkMemoryAllocateInfo pNext(@NativeType(value="void const *") long value) {
        VkMemoryAllocateInfo.npNext(this.address(), value);
        return this;
    }

    public VkMemoryAllocateInfo pNext(VkDedicatedAllocationMemoryAllocateInfoNV value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkMemoryAllocateInfo pNext(VkExportMemoryAllocateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkMemoryAllocateInfo pNext(VkExportMemoryAllocateInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkMemoryAllocateInfo pNext(VkExportMemoryAllocateInfoNV value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkMemoryAllocateInfo pNext(VkExportMemoryWin32HandleInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkMemoryAllocateInfo pNext(VkExportMemoryWin32HandleInfoNV value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkMemoryAllocateInfo pNext(VkExportMetalObjectCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkMemoryAllocateInfo pNext(VkImportAndroidHardwareBufferInfoANDROID value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkMemoryAllocateInfo pNext(VkImportMemoryFdInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkMemoryAllocateInfo pNext(VkImportMemoryHostPointerInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkMemoryAllocateInfo pNext(VkImportMemoryWin32HandleInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkMemoryAllocateInfo pNext(VkImportMemoryWin32HandleInfoNV value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkMemoryAllocateInfo pNext(VkImportMetalBufferInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkMemoryAllocateInfo pNext(VkMemoryAllocateFlagsInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkMemoryAllocateInfo pNext(VkMemoryAllocateFlagsInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkMemoryAllocateInfo pNext(VkMemoryDedicatedAllocateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkMemoryAllocateInfo pNext(VkMemoryDedicatedAllocateInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkMemoryAllocateInfo pNext(VkMemoryOpaqueCaptureAddressAllocateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkMemoryAllocateInfo pNext(VkMemoryOpaqueCaptureAddressAllocateInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkMemoryAllocateInfo pNext(VkMemoryPriorityAllocateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkMemoryAllocateInfo allocationSize(@NativeType(value="VkDeviceSize") long value) {
        VkMemoryAllocateInfo.nallocationSize(this.address(), value);
        return this;
    }

    public VkMemoryAllocateInfo memoryTypeIndex(@NativeType(value="uint32_t") int value) {
        VkMemoryAllocateInfo.nmemoryTypeIndex(this.address(), value);
        return this;
    }

    public VkMemoryAllocateInfo set(int sType, long pNext, long allocationSize, int memoryTypeIndex) {
        this.sType(sType);
        this.pNext(pNext);
        this.allocationSize(allocationSize);
        this.memoryTypeIndex(memoryTypeIndex);
        return this;
    }

    public VkMemoryAllocateInfo set(VkMemoryAllocateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkMemoryAllocateInfo malloc() {
        return new VkMemoryAllocateInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkMemoryAllocateInfo calloc() {
        return new VkMemoryAllocateInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkMemoryAllocateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkMemoryAllocateInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkMemoryAllocateInfo create(long address) {
        return new VkMemoryAllocateInfo(address, null);
    }

    public static @Nullable VkMemoryAllocateInfo createSafe(long address) {
        return address == 0L ? null : new VkMemoryAllocateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkMemoryAllocateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryAllocateInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkMemoryAllocateInfo mallocStack() {
        return VkMemoryAllocateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryAllocateInfo callocStack() {
        return VkMemoryAllocateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryAllocateInfo mallocStack(MemoryStack stack) {
        return VkMemoryAllocateInfo.malloc(stack);
    }

    @Deprecated
    public static VkMemoryAllocateInfo callocStack(MemoryStack stack) {
        return VkMemoryAllocateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkMemoryAllocateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkMemoryAllocateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMemoryAllocateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMemoryAllocateInfo.calloc(capacity, stack);
    }

    public static VkMemoryAllocateInfo malloc(MemoryStack stack) {
        return new VkMemoryAllocateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkMemoryAllocateInfo calloc(MemoryStack stack) {
        return new VkMemoryAllocateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long nallocationSize(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)ALLOCATIONSIZE));
    }

    public static int nmemoryTypeIndex(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MEMORYTYPEINDEX));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nallocationSize(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)ALLOCATIONSIZE), (long)value);
    }

    public static void nmemoryTypeIndex(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MEMORYTYPEINDEX), (int)value);
    }

    static {
        Struct.Layout layout = VkMemoryAllocateInfo.__struct((Struct.Member[])new Struct.Member[]{VkMemoryAllocateInfo.__member((int)4), VkMemoryAllocateInfo.__member((int)POINTER_SIZE), VkMemoryAllocateInfo.__member((int)8), VkMemoryAllocateInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        ALLOCATIONSIZE = layout.offsetof(2);
        MEMORYTYPEINDEX = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryAllocateInfo, Buffer>
    implements NativeResource {
        private static final VkMemoryAllocateInfo ELEMENT_FACTORY = VkMemoryAllocateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkMemoryAllocateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMemoryAllocateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkMemoryAllocateInfo.npNext(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long allocationSize() {
            return VkMemoryAllocateInfo.nallocationSize(this.address());
        }

        @NativeType(value="uint32_t")
        public int memoryTypeIndex() {
            return VkMemoryAllocateInfo.nmemoryTypeIndex(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryAllocateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(5);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryAllocateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkDedicatedAllocationMemoryAllocateInfoNV value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkExportMemoryAllocateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkExportMemoryAllocateInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkExportMemoryAllocateInfoNV value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkExportMemoryWin32HandleInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkExportMemoryWin32HandleInfoNV value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkExportMetalObjectCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkImportAndroidHardwareBufferInfoANDROID value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkImportMemoryFdInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkImportMemoryHostPointerInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkImportMemoryWin32HandleInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkImportMemoryWin32HandleInfoNV value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkImportMetalBufferInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkMemoryAllocateFlagsInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkMemoryAllocateFlagsInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkMemoryDedicatedAllocateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkMemoryDedicatedAllocateInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkMemoryOpaqueCaptureAddressAllocateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkMemoryOpaqueCaptureAddressAllocateInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkMemoryPriorityAllocateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer allocationSize(@NativeType(value="VkDeviceSize") long value) {
            VkMemoryAllocateInfo.nallocationSize(this.address(), value);
            return this;
        }

        public Buffer memoryTypeIndex(@NativeType(value="uint32_t") int value) {
            VkMemoryAllocateInfo.nmemoryTypeIndex(this.address(), value);
            return this;
        }
    }
}

