/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkMemoryBarrier2;

public class VkMemoryBarrier2KHR
extends VkMemoryBarrier2 {
    protected VkMemoryBarrier2KHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkMemoryBarrier2KHR create(long address, @Nullable ByteBuffer container) {
        return new VkMemoryBarrier2KHR(address, container);
    }

    public VkMemoryBarrier2KHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkMemoryBarrier2KHR sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryBarrier2KHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryBarrier2KHR sType$Default() {
        return this.sType(1000314000);
    }

    @Override
    public VkMemoryBarrier2KHR pNext(@NativeType(value="void const *") long value) {
        VkMemoryBarrier2KHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryBarrier2KHR srcStageMask(@NativeType(value="VkPipelineStageFlags2") long value) {
        VkMemoryBarrier2KHR.nsrcStageMask(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryBarrier2KHR srcAccessMask(@NativeType(value="VkAccessFlags2") long value) {
        VkMemoryBarrier2KHR.nsrcAccessMask(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryBarrier2KHR dstStageMask(@NativeType(value="VkPipelineStageFlags2") long value) {
        VkMemoryBarrier2KHR.ndstStageMask(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryBarrier2KHR dstAccessMask(@NativeType(value="VkAccessFlags2") long value) {
        VkMemoryBarrier2KHR.ndstAccessMask(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryBarrier2KHR set(int sType, long pNext, long srcStageMask, long srcAccessMask, long dstStageMask, long dstAccessMask) {
        this.sType(sType);
        this.pNext(pNext);
        this.srcStageMask(srcStageMask);
        this.srcAccessMask(srcAccessMask);
        this.dstStageMask(dstStageMask);
        this.dstAccessMask(dstAccessMask);
        return this;
    }

    public VkMemoryBarrier2KHR set(VkMemoryBarrier2KHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkMemoryBarrier2KHR malloc() {
        return new VkMemoryBarrier2KHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkMemoryBarrier2KHR calloc() {
        return new VkMemoryBarrier2KHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkMemoryBarrier2KHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkMemoryBarrier2KHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkMemoryBarrier2KHR create(long address) {
        return new VkMemoryBarrier2KHR(address, null);
    }

    public static @Nullable VkMemoryBarrier2KHR createSafe(long address) {
        return address == 0L ? null : new VkMemoryBarrier2KHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkMemoryBarrier2KHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryBarrier2KHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkMemoryBarrier2KHR malloc(MemoryStack stack) {
        return new VkMemoryBarrier2KHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkMemoryBarrier2KHR calloc(MemoryStack stack) {
        return new VkMemoryBarrier2KHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkMemoryBarrier2.Buffer {
        private static final VkMemoryBarrier2KHR ELEMENT_FACTORY = VkMemoryBarrier2KHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkMemoryBarrier2KHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryBarrier2KHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000314000);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryBarrier2KHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer srcStageMask(@NativeType(value="VkPipelineStageFlags2") long value) {
            VkMemoryBarrier2KHR.nsrcStageMask(this.address(), value);
            return this;
        }

        @Override
        public Buffer srcAccessMask(@NativeType(value="VkAccessFlags2") long value) {
            VkMemoryBarrier2KHR.nsrcAccessMask(this.address(), value);
            return this;
        }

        @Override
        public Buffer dstStageMask(@NativeType(value="VkPipelineStageFlags2") long value) {
            VkMemoryBarrier2KHR.ndstStageMask(this.address(), value);
            return this;
        }

        @Override
        public Buffer dstAccessMask(@NativeType(value="VkAccessFlags2") long value) {
            VkMemoryBarrier2KHR.ndstAccessMask(this.address(), value);
            return this;
        }
    }
}

