/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryRequirements
extends Struct<VkMemoryRequirements>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SIZE;
    public static final int ALIGNMENT;
    public static final int MEMORYTYPEBITS;

    protected VkMemoryRequirements(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkMemoryRequirements create(long address, @Nullable ByteBuffer container) {
        return new VkMemoryRequirements(address, container);
    }

    public VkMemoryRequirements(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkMemoryRequirements.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VkMemoryRequirements.nsize(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long alignment() {
        return VkMemoryRequirements.nalignment(this.address());
    }

    @NativeType(value="uint32_t")
    public int memoryTypeBits() {
        return VkMemoryRequirements.nmemoryTypeBits(this.address());
    }

    public VkMemoryRequirements size(@NativeType(value="VkDeviceSize") long value) {
        VkMemoryRequirements.nsize(this.address(), value);
        return this;
    }

    public VkMemoryRequirements alignment(@NativeType(value="VkDeviceSize") long value) {
        VkMemoryRequirements.nalignment(this.address(), value);
        return this;
    }

    public VkMemoryRequirements memoryTypeBits(@NativeType(value="uint32_t") int value) {
        VkMemoryRequirements.nmemoryTypeBits(this.address(), value);
        return this;
    }

    public VkMemoryRequirements set(long size, long alignment, int memoryTypeBits) {
        this.size(size);
        this.alignment(alignment);
        this.memoryTypeBits(memoryTypeBits);
        return this;
    }

    public VkMemoryRequirements set(VkMemoryRequirements src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkMemoryRequirements malloc() {
        return new VkMemoryRequirements(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkMemoryRequirements calloc() {
        return new VkMemoryRequirements(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkMemoryRequirements create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkMemoryRequirements(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkMemoryRequirements create(long address) {
        return new VkMemoryRequirements(address, null);
    }

    public static @Nullable VkMemoryRequirements createSafe(long address) {
        return address == 0L ? null : new VkMemoryRequirements(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkMemoryRequirements.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryRequirements.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkMemoryRequirements mallocStack() {
        return VkMemoryRequirements.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryRequirements callocStack() {
        return VkMemoryRequirements.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryRequirements mallocStack(MemoryStack stack) {
        return VkMemoryRequirements.malloc(stack);
    }

    @Deprecated
    public static VkMemoryRequirements callocStack(MemoryStack stack) {
        return VkMemoryRequirements.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkMemoryRequirements.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkMemoryRequirements.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMemoryRequirements.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMemoryRequirements.calloc(capacity, stack);
    }

    public static VkMemoryRequirements malloc(MemoryStack stack) {
        return new VkMemoryRequirements(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkMemoryRequirements calloc(MemoryStack stack) {
        return new VkMemoryRequirements(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)SIZE));
    }

    public static long nalignment(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)ALIGNMENT));
    }

    public static int nmemoryTypeBits(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MEMORYTYPEBITS));
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)SIZE), (long)value);
    }

    public static void nalignment(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)ALIGNMENT), (long)value);
    }

    public static void nmemoryTypeBits(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MEMORYTYPEBITS), (int)value);
    }

    static {
        Struct.Layout layout = VkMemoryRequirements.__struct((Struct.Member[])new Struct.Member[]{VkMemoryRequirements.__member((int)8), VkMemoryRequirements.__member((int)8), VkMemoryRequirements.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SIZE = layout.offsetof(0);
        ALIGNMENT = layout.offsetof(1);
        MEMORYTYPEBITS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryRequirements, Buffer>
    implements NativeResource {
        private static final VkMemoryRequirements ELEMENT_FACTORY = VkMemoryRequirements.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkMemoryRequirements getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VkMemoryRequirements.nsize(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long alignment() {
            return VkMemoryRequirements.nalignment(this.address());
        }

        @NativeType(value="uint32_t")
        public int memoryTypeBits() {
            return VkMemoryRequirements.nmemoryTypeBits(this.address());
        }

        public Buffer size(@NativeType(value="VkDeviceSize") long value) {
            VkMemoryRequirements.nsize(this.address(), value);
            return this;
        }

        public Buffer alignment(@NativeType(value="VkDeviceSize") long value) {
            VkMemoryRequirements.nalignment(this.address(), value);
            return this;
        }

        public Buffer memoryTypeBits(@NativeType(value="uint32_t") int value) {
            VkMemoryRequirements.nmemoryTypeBits(this.address(), value);
            return this;
        }
    }
}

