/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDeviceOrHostAddressConstKHR;
import org.lwjgl.vulkan.VkDeviceOrHostAddressKHR;
import org.lwjgl.vulkan.VkMicromapUsageEXT;

public class VkMicromapBuildInfoEXT
extends Struct<VkMicromapBuildInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int TYPE;
    public static final int FLAGS;
    public static final int MODE;
    public static final int DSTMICROMAP;
    public static final int USAGECOUNTSCOUNT;
    public static final int PUSAGECOUNTS;
    public static final int PPUSAGECOUNTS;
    public static final int DATA;
    public static final int SCRATCHDATA;
    public static final int TRIANGLEARRAY;
    public static final int TRIANGLEARRAYSTRIDE;

    protected VkMicromapBuildInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkMicromapBuildInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkMicromapBuildInfoEXT(address, container);
    }

    public VkMicromapBuildInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkMicromapBuildInfoEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMicromapBuildInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkMicromapBuildInfoEXT.npNext(this.address());
    }

    @NativeType(value="VkMicromapTypeEXT")
    public int type() {
        return VkMicromapBuildInfoEXT.ntype(this.address());
    }

    @NativeType(value="VkBuildMicromapFlagsEXT")
    public int flags() {
        return VkMicromapBuildInfoEXT.nflags(this.address());
    }

    @NativeType(value="VkBuildMicromapModeEXT")
    public int mode() {
        return VkMicromapBuildInfoEXT.nmode(this.address());
    }

    @NativeType(value="VkMicromapEXT")
    public long dstMicromap() {
        return VkMicromapBuildInfoEXT.ndstMicromap(this.address());
    }

    @NativeType(value="uint32_t")
    public int usageCountsCount() {
        return VkMicromapBuildInfoEXT.nusageCountsCount(this.address());
    }

    @NativeType(value="VkMicromapUsageEXT const *")
    public @Nullable VkMicromapUsageEXT.Buffer pUsageCounts() {
        return VkMicromapBuildInfoEXT.npUsageCounts(this.address());
    }

    @NativeType(value="VkMicromapUsageEXT const * const *")
    public @Nullable PointerBuffer ppUsageCounts() {
        return VkMicromapBuildInfoEXT.nppUsageCounts(this.address());
    }

    public VkDeviceOrHostAddressConstKHR data() {
        return VkMicromapBuildInfoEXT.ndata(this.address());
    }

    public VkDeviceOrHostAddressKHR scratchData() {
        return VkMicromapBuildInfoEXT.nscratchData(this.address());
    }

    public VkDeviceOrHostAddressConstKHR triangleArray() {
        return VkMicromapBuildInfoEXT.ntriangleArray(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long triangleArrayStride() {
        return VkMicromapBuildInfoEXT.ntriangleArrayStride(this.address());
    }

    public VkMicromapBuildInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkMicromapBuildInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkMicromapBuildInfoEXT sType$Default() {
        return this.sType(1000396000);
    }

    public VkMicromapBuildInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkMicromapBuildInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkMicromapBuildInfoEXT type(@NativeType(value="VkMicromapTypeEXT") int value) {
        VkMicromapBuildInfoEXT.ntype(this.address(), value);
        return this;
    }

    public VkMicromapBuildInfoEXT flags(@NativeType(value="VkBuildMicromapFlagsEXT") int value) {
        VkMicromapBuildInfoEXT.nflags(this.address(), value);
        return this;
    }

    public VkMicromapBuildInfoEXT mode(@NativeType(value="VkBuildMicromapModeEXT") int value) {
        VkMicromapBuildInfoEXT.nmode(this.address(), value);
        return this;
    }

    public VkMicromapBuildInfoEXT dstMicromap(@NativeType(value="VkMicromapEXT") long value) {
        VkMicromapBuildInfoEXT.ndstMicromap(this.address(), value);
        return this;
    }

    public VkMicromapBuildInfoEXT usageCountsCount(@NativeType(value="uint32_t") int value) {
        VkMicromapBuildInfoEXT.nusageCountsCount(this.address(), value);
        return this;
    }

    public VkMicromapBuildInfoEXT pUsageCounts(@NativeType(value="VkMicromapUsageEXT const *") @Nullable VkMicromapUsageEXT.Buffer value) {
        VkMicromapBuildInfoEXT.npUsageCounts(this.address(), value);
        return this;
    }

    public VkMicromapBuildInfoEXT ppUsageCounts(@NativeType(value="VkMicromapUsageEXT const * const *") @Nullable PointerBuffer value) {
        VkMicromapBuildInfoEXT.nppUsageCounts(this.address(), value);
        return this;
    }

    public VkMicromapBuildInfoEXT data(VkDeviceOrHostAddressConstKHR value) {
        VkMicromapBuildInfoEXT.ndata(this.address(), value);
        return this;
    }

    public VkMicromapBuildInfoEXT data(Consumer<VkDeviceOrHostAddressConstKHR> consumer) {
        consumer.accept(this.data());
        return this;
    }

    public VkMicromapBuildInfoEXT scratchData(VkDeviceOrHostAddressKHR value) {
        VkMicromapBuildInfoEXT.nscratchData(this.address(), value);
        return this;
    }

    public VkMicromapBuildInfoEXT scratchData(Consumer<VkDeviceOrHostAddressKHR> consumer) {
        consumer.accept(this.scratchData());
        return this;
    }

    public VkMicromapBuildInfoEXT triangleArray(VkDeviceOrHostAddressConstKHR value) {
        VkMicromapBuildInfoEXT.ntriangleArray(this.address(), value);
        return this;
    }

    public VkMicromapBuildInfoEXT triangleArray(Consumer<VkDeviceOrHostAddressConstKHR> consumer) {
        consumer.accept(this.triangleArray());
        return this;
    }

    public VkMicromapBuildInfoEXT triangleArrayStride(@NativeType(value="VkDeviceSize") long value) {
        VkMicromapBuildInfoEXT.ntriangleArrayStride(this.address(), value);
        return this;
    }

    public VkMicromapBuildInfoEXT set(int sType, long pNext, int type, int flags, int mode, long dstMicromap, int usageCountsCount, @Nullable VkMicromapUsageEXT.Buffer pUsageCounts, @Nullable PointerBuffer ppUsageCounts, VkDeviceOrHostAddressConstKHR data, VkDeviceOrHostAddressKHR scratchData, VkDeviceOrHostAddressConstKHR triangleArray, long triangleArrayStride) {
        this.sType(sType);
        this.pNext(pNext);
        this.type(type);
        this.flags(flags);
        this.mode(mode);
        this.dstMicromap(dstMicromap);
        this.usageCountsCount(usageCountsCount);
        this.pUsageCounts(pUsageCounts);
        this.ppUsageCounts(ppUsageCounts);
        this.data(data);
        this.scratchData(scratchData);
        this.triangleArray(triangleArray);
        this.triangleArrayStride(triangleArrayStride);
        return this;
    }

    public VkMicromapBuildInfoEXT set(VkMicromapBuildInfoEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkMicromapBuildInfoEXT malloc() {
        return new VkMicromapBuildInfoEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkMicromapBuildInfoEXT calloc() {
        return new VkMicromapBuildInfoEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkMicromapBuildInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkMicromapBuildInfoEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkMicromapBuildInfoEXT create(long address) {
        return new VkMicromapBuildInfoEXT(address, null);
    }

    public static @Nullable VkMicromapBuildInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkMicromapBuildInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkMicromapBuildInfoEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMicromapBuildInfoEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkMicromapBuildInfoEXT malloc(MemoryStack stack) {
        return new VkMicromapBuildInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkMicromapBuildInfoEXT calloc(MemoryStack stack) {
        return new VkMicromapBuildInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FLAGS));
    }

    public static int nmode(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MODE));
    }

    public static long ndstMicromap(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)DSTMICROMAP));
    }

    public static int nusageCountsCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)USAGECOUNTSCOUNT));
    }

    public static @Nullable VkMicromapUsageEXT.Buffer npUsageCounts(long struct) {
        return VkMicromapUsageEXT.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PUSAGECOUNTS)), VkMicromapBuildInfoEXT.nusageCountsCount(struct));
    }

    public static @Nullable PointerBuffer nppUsageCounts(long struct) {
        return MemoryUtil.memPointerBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PPUSAGECOUNTS)), (int)VkMicromapBuildInfoEXT.nusageCountsCount(struct));
    }

    public static VkDeviceOrHostAddressConstKHR ndata(long struct) {
        return VkDeviceOrHostAddressConstKHR.create(struct + (long)DATA);
    }

    public static VkDeviceOrHostAddressKHR nscratchData(long struct) {
        return VkDeviceOrHostAddressKHR.create(struct + (long)SCRATCHDATA);
    }

    public static VkDeviceOrHostAddressConstKHR ntriangleArray(long struct) {
        return VkDeviceOrHostAddressConstKHR.create(struct + (long)TRIANGLEARRAY);
    }

    public static long ntriangleArrayStride(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)TRIANGLEARRAYSTRIDE));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FLAGS), (int)value);
    }

    public static void nmode(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MODE), (int)value);
    }

    public static void ndstMicromap(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)DSTMICROMAP), (long)value);
    }

    public static void nusageCountsCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)USAGECOUNTSCOUNT), (int)value);
    }

    public static void npUsageCounts(long struct, @Nullable VkMicromapUsageEXT.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PUSAGECOUNTS), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nppUsageCounts(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PPUSAGECOUNTS), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void ndata(long struct, VkDeviceOrHostAddressConstKHR value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)DATA), (long)VkDeviceOrHostAddressConstKHR.SIZEOF);
    }

    public static void nscratchData(long struct, VkDeviceOrHostAddressKHR value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SCRATCHDATA), (long)VkDeviceOrHostAddressKHR.SIZEOF);
    }

    public static void ntriangleArray(long struct, VkDeviceOrHostAddressConstKHR value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)TRIANGLEARRAY), (long)VkDeviceOrHostAddressConstKHR.SIZEOF);
    }

    public static void ntriangleArrayStride(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)TRIANGLEARRAYSTRIDE), (long)value);
    }

    static {
        Struct.Layout layout = VkMicromapBuildInfoEXT.__struct((Struct.Member[])new Struct.Member[]{VkMicromapBuildInfoEXT.__member((int)4), VkMicromapBuildInfoEXT.__member((int)POINTER_SIZE), VkMicromapBuildInfoEXT.__member((int)4), VkMicromapBuildInfoEXT.__member((int)4), VkMicromapBuildInfoEXT.__member((int)4), VkMicromapBuildInfoEXT.__member((int)8), VkMicromapBuildInfoEXT.__member((int)4), VkMicromapBuildInfoEXT.__member((int)POINTER_SIZE), VkMicromapBuildInfoEXT.__member((int)POINTER_SIZE), VkMicromapBuildInfoEXT.__member((int)VkDeviceOrHostAddressConstKHR.SIZEOF, (int)VkDeviceOrHostAddressConstKHR.ALIGNOF), VkMicromapBuildInfoEXT.__member((int)VkDeviceOrHostAddressKHR.SIZEOF, (int)VkDeviceOrHostAddressKHR.ALIGNOF), VkMicromapBuildInfoEXT.__member((int)VkDeviceOrHostAddressConstKHR.SIZEOF, (int)VkDeviceOrHostAddressConstKHR.ALIGNOF), VkMicromapBuildInfoEXT.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        TYPE = layout.offsetof(2);
        FLAGS = layout.offsetof(3);
        MODE = layout.offsetof(4);
        DSTMICROMAP = layout.offsetof(5);
        USAGECOUNTSCOUNT = layout.offsetof(6);
        PUSAGECOUNTS = layout.offsetof(7);
        PPUSAGECOUNTS = layout.offsetof(8);
        DATA = layout.offsetof(9);
        SCRATCHDATA = layout.offsetof(10);
        TRIANGLEARRAY = layout.offsetof(11);
        TRIANGLEARRAYSTRIDE = layout.offsetof(12);
    }

    public static class Buffer
    extends StructBuffer<VkMicromapBuildInfoEXT, Buffer>
    implements NativeResource {
        private static final VkMicromapBuildInfoEXT ELEMENT_FACTORY = VkMicromapBuildInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkMicromapBuildInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMicromapBuildInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkMicromapBuildInfoEXT.npNext(this.address());
        }

        @NativeType(value="VkMicromapTypeEXT")
        public int type() {
            return VkMicromapBuildInfoEXT.ntype(this.address());
        }

        @NativeType(value="VkBuildMicromapFlagsEXT")
        public int flags() {
            return VkMicromapBuildInfoEXT.nflags(this.address());
        }

        @NativeType(value="VkBuildMicromapModeEXT")
        public int mode() {
            return VkMicromapBuildInfoEXT.nmode(this.address());
        }

        @NativeType(value="VkMicromapEXT")
        public long dstMicromap() {
            return VkMicromapBuildInfoEXT.ndstMicromap(this.address());
        }

        @NativeType(value="uint32_t")
        public int usageCountsCount() {
            return VkMicromapBuildInfoEXT.nusageCountsCount(this.address());
        }

        @NativeType(value="VkMicromapUsageEXT const *")
        public @Nullable VkMicromapUsageEXT.Buffer pUsageCounts() {
            return VkMicromapBuildInfoEXT.npUsageCounts(this.address());
        }

        @NativeType(value="VkMicromapUsageEXT const * const *")
        public @Nullable PointerBuffer ppUsageCounts() {
            return VkMicromapBuildInfoEXT.nppUsageCounts(this.address());
        }

        public VkDeviceOrHostAddressConstKHR data() {
            return VkMicromapBuildInfoEXT.ndata(this.address());
        }

        public VkDeviceOrHostAddressKHR scratchData() {
            return VkMicromapBuildInfoEXT.nscratchData(this.address());
        }

        public VkDeviceOrHostAddressConstKHR triangleArray() {
            return VkMicromapBuildInfoEXT.ntriangleArray(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long triangleArrayStride() {
            return VkMicromapBuildInfoEXT.ntriangleArrayStride(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMicromapBuildInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000396000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMicromapBuildInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer type(@NativeType(value="VkMicromapTypeEXT") int value) {
            VkMicromapBuildInfoEXT.ntype(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkBuildMicromapFlagsEXT") int value) {
            VkMicromapBuildInfoEXT.nflags(this.address(), value);
            return this;
        }

        public Buffer mode(@NativeType(value="VkBuildMicromapModeEXT") int value) {
            VkMicromapBuildInfoEXT.nmode(this.address(), value);
            return this;
        }

        public Buffer dstMicromap(@NativeType(value="VkMicromapEXT") long value) {
            VkMicromapBuildInfoEXT.ndstMicromap(this.address(), value);
            return this;
        }

        public Buffer usageCountsCount(@NativeType(value="uint32_t") int value) {
            VkMicromapBuildInfoEXT.nusageCountsCount(this.address(), value);
            return this;
        }

        public Buffer pUsageCounts(@NativeType(value="VkMicromapUsageEXT const *") @Nullable VkMicromapUsageEXT.Buffer value) {
            VkMicromapBuildInfoEXT.npUsageCounts(this.address(), value);
            return this;
        }

        public Buffer ppUsageCounts(@NativeType(value="VkMicromapUsageEXT const * const *") @Nullable PointerBuffer value) {
            VkMicromapBuildInfoEXT.nppUsageCounts(this.address(), value);
            return this;
        }

        public Buffer data(VkDeviceOrHostAddressConstKHR value) {
            VkMicromapBuildInfoEXT.ndata(this.address(), value);
            return this;
        }

        public Buffer data(Consumer<VkDeviceOrHostAddressConstKHR> consumer) {
            consumer.accept(this.data());
            return this;
        }

        public Buffer scratchData(VkDeviceOrHostAddressKHR value) {
            VkMicromapBuildInfoEXT.nscratchData(this.address(), value);
            return this;
        }

        public Buffer scratchData(Consumer<VkDeviceOrHostAddressKHR> consumer) {
            consumer.accept(this.scratchData());
            return this;
        }

        public Buffer triangleArray(VkDeviceOrHostAddressConstKHR value) {
            VkMicromapBuildInfoEXT.ntriangleArray(this.address(), value);
            return this;
        }

        public Buffer triangleArray(Consumer<VkDeviceOrHostAddressConstKHR> consumer) {
            consumer.accept(this.triangleArray());
            return this;
        }

        public Buffer triangleArrayStride(@NativeType(value="VkDeviceSize") long value) {
            VkMicromapBuildInfoEXT.ntriangleArrayStride(this.address(), value);
            return this;
        }
    }
}

