/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkOffset2D
extends Struct<VkOffset2D>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;

    protected VkOffset2D(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkOffset2D create(long address, @Nullable ByteBuffer container) {
        return new VkOffset2D(address, container);
    }

    public VkOffset2D(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkOffset2D.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="int32_t")
    public int x() {
        return VkOffset2D.nx(this.address());
    }

    @NativeType(value="int32_t")
    public int y() {
        return VkOffset2D.ny(this.address());
    }

    public VkOffset2D x(@NativeType(value="int32_t") int value) {
        VkOffset2D.nx(this.address(), value);
        return this;
    }

    public VkOffset2D y(@NativeType(value="int32_t") int value) {
        VkOffset2D.ny(this.address(), value);
        return this;
    }

    public VkOffset2D set(int x, int y) {
        this.x(x);
        this.y(y);
        return this;
    }

    public VkOffset2D set(VkOffset2D src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkOffset2D malloc() {
        return new VkOffset2D(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkOffset2D calloc() {
        return new VkOffset2D(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkOffset2D create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkOffset2D(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkOffset2D create(long address) {
        return new VkOffset2D(address, null);
    }

    public static @Nullable VkOffset2D createSafe(long address) {
        return address == 0L ? null : new VkOffset2D(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkOffset2D.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkOffset2D.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkOffset2D mallocStack() {
        return VkOffset2D.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkOffset2D callocStack() {
        return VkOffset2D.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkOffset2D mallocStack(MemoryStack stack) {
        return VkOffset2D.malloc(stack);
    }

    @Deprecated
    public static VkOffset2D callocStack(MemoryStack stack) {
        return VkOffset2D.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkOffset2D.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkOffset2D.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkOffset2D.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkOffset2D.calloc(capacity, stack);
    }

    public static VkOffset2D malloc(MemoryStack stack) {
        return new VkOffset2D(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkOffset2D calloc(MemoryStack stack) {
        return new VkOffset2D(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nx(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)X));
    }

    public static int ny(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)Y));
    }

    public static void nx(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)X), (int)value);
    }

    public static void ny(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)Y), (int)value);
    }

    static {
        Struct.Layout layout = VkOffset2D.__struct((Struct.Member[])new Struct.Member[]{VkOffset2D.__member((int)4), VkOffset2D.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkOffset2D, Buffer>
    implements NativeResource {
        private static final VkOffset2D ELEMENT_FACTORY = VkOffset2D.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkOffset2D getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="int32_t")
        public int x() {
            return VkOffset2D.nx(this.address());
        }

        @NativeType(value="int32_t")
        public int y() {
            return VkOffset2D.ny(this.address());
        }

        public Buffer x(@NativeType(value="int32_t") int value) {
            VkOffset2D.nx(this.address(), value);
            return this;
        }

        public Buffer y(@NativeType(value="int32_t") int value) {
            VkOffset2D.ny(this.address(), value);
            return this;
        }
    }
}

