/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPhysicalDeviceMemoryBudgetPropertiesEXT
extends Struct<VkPhysicalDeviceMemoryBudgetPropertiesEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int HEAPBUDGET;
    public static final int HEAPUSAGE;

    protected VkPhysicalDeviceMemoryBudgetPropertiesEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkPhysicalDeviceMemoryBudgetPropertiesEXT create(long address, @Nullable ByteBuffer container) {
        return new VkPhysicalDeviceMemoryBudgetPropertiesEXT(address, container);
    }

    public VkPhysicalDeviceMemoryBudgetPropertiesEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkPhysicalDeviceMemoryBudgetPropertiesEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.npNext(this.address());
    }

    @NativeType(value="VkDeviceSize[VK_MAX_MEMORY_HEAPS]")
    public LongBuffer heapBudget() {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.nheapBudget(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long heapBudget(int index) {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.nheapBudget(this.address(), index);
    }

    @NativeType(value="VkDeviceSize[VK_MAX_MEMORY_HEAPS]")
    public LongBuffer heapUsage() {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.nheapUsage(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long heapUsage(int index) {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.nheapUsage(this.address(), index);
    }

    public VkPhysicalDeviceMemoryBudgetPropertiesEXT sType(@NativeType(value="VkStructureType") int value) {
        VkPhysicalDeviceMemoryBudgetPropertiesEXT.nsType(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceMemoryBudgetPropertiesEXT sType$Default() {
        return this.sType(1000237000);
    }

    public VkPhysicalDeviceMemoryBudgetPropertiesEXT pNext(@NativeType(value="void *") long value) {
        VkPhysicalDeviceMemoryBudgetPropertiesEXT.npNext(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceMemoryBudgetPropertiesEXT set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkPhysicalDeviceMemoryBudgetPropertiesEXT set(VkPhysicalDeviceMemoryBudgetPropertiesEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPhysicalDeviceMemoryBudgetPropertiesEXT malloc() {
        return new VkPhysicalDeviceMemoryBudgetPropertiesEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkPhysicalDeviceMemoryBudgetPropertiesEXT calloc() {
        return new VkPhysicalDeviceMemoryBudgetPropertiesEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkPhysicalDeviceMemoryBudgetPropertiesEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkPhysicalDeviceMemoryBudgetPropertiesEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkPhysicalDeviceMemoryBudgetPropertiesEXT create(long address) {
        return new VkPhysicalDeviceMemoryBudgetPropertiesEXT(address, null);
    }

    public static @Nullable VkPhysicalDeviceMemoryBudgetPropertiesEXT createSafe(long address) {
        return address == 0L ? null : new VkPhysicalDeviceMemoryBudgetPropertiesEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkPhysicalDeviceMemoryBudgetPropertiesEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPhysicalDeviceMemoryBudgetPropertiesEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkPhysicalDeviceMemoryBudgetPropertiesEXT mallocStack() {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPhysicalDeviceMemoryBudgetPropertiesEXT callocStack() {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPhysicalDeviceMemoryBudgetPropertiesEXT mallocStack(MemoryStack stack) {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.malloc(stack);
    }

    @Deprecated
    public static VkPhysicalDeviceMemoryBudgetPropertiesEXT callocStack(MemoryStack stack) {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.calloc(capacity, stack);
    }

    public static VkPhysicalDeviceMemoryBudgetPropertiesEXT malloc(MemoryStack stack) {
        return new VkPhysicalDeviceMemoryBudgetPropertiesEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPhysicalDeviceMemoryBudgetPropertiesEXT calloc(MemoryStack stack) {
        return new VkPhysicalDeviceMemoryBudgetPropertiesEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static LongBuffer nheapBudget(long struct) {
        return MemoryUtil.memLongBuffer((long)(struct + (long)HEAPBUDGET), (int)16);
    }

    public static long nheapBudget(long struct, int index) {
        return MemoryUtil.memGetLong((long)(struct + (long)HEAPBUDGET + Checks.check((int)index, (int)16) * 8L));
    }

    public static LongBuffer nheapUsage(long struct) {
        return MemoryUtil.memLongBuffer((long)(struct + (long)HEAPUSAGE), (int)16);
    }

    public static long nheapUsage(long struct, int index) {
        return MemoryUtil.memGetLong((long)(struct + (long)HEAPUSAGE + Checks.check((int)index, (int)16) * 8L));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceMemoryBudgetPropertiesEXT.__struct((Struct.Member[])new Struct.Member[]{VkPhysicalDeviceMemoryBudgetPropertiesEXT.__member((int)4), VkPhysicalDeviceMemoryBudgetPropertiesEXT.__member((int)POINTER_SIZE), VkPhysicalDeviceMemoryBudgetPropertiesEXT.__array((int)8, (int)16), VkPhysicalDeviceMemoryBudgetPropertiesEXT.__array((int)8, (int)16)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        HEAPBUDGET = layout.offsetof(2);
        HEAPUSAGE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceMemoryBudgetPropertiesEXT, Buffer>
    implements NativeResource {
        private static final VkPhysicalDeviceMemoryBudgetPropertiesEXT ELEMENT_FACTORY = VkPhysicalDeviceMemoryBudgetPropertiesEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkPhysicalDeviceMemoryBudgetPropertiesEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPhysicalDeviceMemoryBudgetPropertiesEXT.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkPhysicalDeviceMemoryBudgetPropertiesEXT.npNext(this.address());
        }

        @NativeType(value="VkDeviceSize[VK_MAX_MEMORY_HEAPS]")
        public LongBuffer heapBudget() {
            return VkPhysicalDeviceMemoryBudgetPropertiesEXT.nheapBudget(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long heapBudget(int index) {
            return VkPhysicalDeviceMemoryBudgetPropertiesEXT.nheapBudget(this.address(), index);
        }

        @NativeType(value="VkDeviceSize[VK_MAX_MEMORY_HEAPS]")
        public LongBuffer heapUsage() {
            return VkPhysicalDeviceMemoryBudgetPropertiesEXT.nheapUsage(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long heapUsage(int index) {
            return VkPhysicalDeviceMemoryBudgetPropertiesEXT.nheapUsage(this.address(), index);
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPhysicalDeviceMemoryBudgetPropertiesEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000237000);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPhysicalDeviceMemoryBudgetPropertiesEXT.npNext(this.address(), value);
            return this;
        }
    }
}

