/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkPhysicalDeviceMemoryBudgetPropertiesEXT;
import org.lwjgl.vulkan.VkPhysicalDeviceMemoryProperties;

public class VkPhysicalDeviceMemoryProperties2
extends Struct<VkPhysicalDeviceMemoryProperties2>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int MEMORYPROPERTIES;

    protected VkPhysicalDeviceMemoryProperties2(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkPhysicalDeviceMemoryProperties2 create(long address, @Nullable ByteBuffer container) {
        return new VkPhysicalDeviceMemoryProperties2(address, container);
    }

    public VkPhysicalDeviceMemoryProperties2(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkPhysicalDeviceMemoryProperties2.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPhysicalDeviceMemoryProperties2.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkPhysicalDeviceMemoryProperties2.npNext(this.address());
    }

    public VkPhysicalDeviceMemoryProperties memoryProperties() {
        return VkPhysicalDeviceMemoryProperties2.nmemoryProperties(this.address());
    }

    public VkPhysicalDeviceMemoryProperties2 sType(@NativeType(value="VkStructureType") int value) {
        VkPhysicalDeviceMemoryProperties2.nsType(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceMemoryProperties2 sType$Default() {
        return this.sType(1000059006);
    }

    public VkPhysicalDeviceMemoryProperties2 pNext(@NativeType(value="void *") long value) {
        VkPhysicalDeviceMemoryProperties2.npNext(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceMemoryProperties2 pNext(VkPhysicalDeviceMemoryBudgetPropertiesEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkPhysicalDeviceMemoryProperties2 set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkPhysicalDeviceMemoryProperties2 set(VkPhysicalDeviceMemoryProperties2 src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPhysicalDeviceMemoryProperties2 malloc() {
        return new VkPhysicalDeviceMemoryProperties2(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkPhysicalDeviceMemoryProperties2 calloc() {
        return new VkPhysicalDeviceMemoryProperties2(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkPhysicalDeviceMemoryProperties2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkPhysicalDeviceMemoryProperties2(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkPhysicalDeviceMemoryProperties2 create(long address) {
        return new VkPhysicalDeviceMemoryProperties2(address, null);
    }

    public static @Nullable VkPhysicalDeviceMemoryProperties2 createSafe(long address) {
        return address == 0L ? null : new VkPhysicalDeviceMemoryProperties2(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkPhysicalDeviceMemoryProperties2.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPhysicalDeviceMemoryProperties2.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkPhysicalDeviceMemoryProperties2 mallocStack() {
        return VkPhysicalDeviceMemoryProperties2.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPhysicalDeviceMemoryProperties2 callocStack() {
        return VkPhysicalDeviceMemoryProperties2.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPhysicalDeviceMemoryProperties2 mallocStack(MemoryStack stack) {
        return VkPhysicalDeviceMemoryProperties2.malloc(stack);
    }

    @Deprecated
    public static VkPhysicalDeviceMemoryProperties2 callocStack(MemoryStack stack) {
        return VkPhysicalDeviceMemoryProperties2.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkPhysicalDeviceMemoryProperties2.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkPhysicalDeviceMemoryProperties2.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceMemoryProperties2.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceMemoryProperties2.calloc(capacity, stack);
    }

    public static VkPhysicalDeviceMemoryProperties2 malloc(MemoryStack stack) {
        return new VkPhysicalDeviceMemoryProperties2(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPhysicalDeviceMemoryProperties2 calloc(MemoryStack stack) {
        return new VkPhysicalDeviceMemoryProperties2(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static VkPhysicalDeviceMemoryProperties nmemoryProperties(long struct) {
        return VkPhysicalDeviceMemoryProperties.create(struct + (long)MEMORYPROPERTIES);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceMemoryProperties2.__struct((Struct.Member[])new Struct.Member[]{VkPhysicalDeviceMemoryProperties2.__member((int)4), VkPhysicalDeviceMemoryProperties2.__member((int)POINTER_SIZE), VkPhysicalDeviceMemoryProperties2.__member((int)VkPhysicalDeviceMemoryProperties.SIZEOF, (int)VkPhysicalDeviceMemoryProperties.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        MEMORYPROPERTIES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceMemoryProperties2, Buffer>
    implements NativeResource {
        private static final VkPhysicalDeviceMemoryProperties2 ELEMENT_FACTORY = VkPhysicalDeviceMemoryProperties2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkPhysicalDeviceMemoryProperties2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPhysicalDeviceMemoryProperties2.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkPhysicalDeviceMemoryProperties2.npNext(this.address());
        }

        public VkPhysicalDeviceMemoryProperties memoryProperties() {
            return VkPhysicalDeviceMemoryProperties2.nmemoryProperties(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPhysicalDeviceMemoryProperties2.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000059006);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPhysicalDeviceMemoryProperties2.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkPhysicalDeviceMemoryBudgetPropertiesEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }
    }
}

