/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent2D;

public class VkPipelineFragmentShadingRateStateCreateInfoKHR
extends Struct<VkPipelineFragmentShadingRateStateCreateInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FRAGMENTSIZE;
    public static final int COMBINEROPS;

    protected VkPipelineFragmentShadingRateStateCreateInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkPipelineFragmentShadingRateStateCreateInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkPipelineFragmentShadingRateStateCreateInfoKHR(address, container);
    }

    public VkPipelineFragmentShadingRateStateCreateInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkPipelineFragmentShadingRateStateCreateInfoKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPipelineFragmentShadingRateStateCreateInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkPipelineFragmentShadingRateStateCreateInfoKHR.npNext(this.address());
    }

    public VkExtent2D fragmentSize() {
        return VkPipelineFragmentShadingRateStateCreateInfoKHR.nfragmentSize(this.address());
    }

    @NativeType(value="VkFragmentShadingRateCombinerOpKHR[2]")
    public IntBuffer combinerOps() {
        return VkPipelineFragmentShadingRateStateCreateInfoKHR.ncombinerOps(this.address());
    }

    @NativeType(value="VkFragmentShadingRateCombinerOpKHR")
    public int combinerOps(int index) {
        return VkPipelineFragmentShadingRateStateCreateInfoKHR.ncombinerOps(this.address(), index);
    }

    public VkPipelineFragmentShadingRateStateCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkPipelineFragmentShadingRateStateCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkPipelineFragmentShadingRateStateCreateInfoKHR sType$Default() {
        return this.sType(1000226001);
    }

    public VkPipelineFragmentShadingRateStateCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkPipelineFragmentShadingRateStateCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkPipelineFragmentShadingRateStateCreateInfoKHR fragmentSize(VkExtent2D value) {
        VkPipelineFragmentShadingRateStateCreateInfoKHR.nfragmentSize(this.address(), value);
        return this;
    }

    public VkPipelineFragmentShadingRateStateCreateInfoKHR fragmentSize(Consumer<VkExtent2D> consumer) {
        consumer.accept(this.fragmentSize());
        return this;
    }

    public VkPipelineFragmentShadingRateStateCreateInfoKHR combinerOps(@NativeType(value="VkFragmentShadingRateCombinerOpKHR[2]") IntBuffer value) {
        VkPipelineFragmentShadingRateStateCreateInfoKHR.ncombinerOps(this.address(), value);
        return this;
    }

    public VkPipelineFragmentShadingRateStateCreateInfoKHR combinerOps(int index, @NativeType(value="VkFragmentShadingRateCombinerOpKHR") int value) {
        VkPipelineFragmentShadingRateStateCreateInfoKHR.ncombinerOps(this.address(), index, value);
        return this;
    }

    public VkPipelineFragmentShadingRateStateCreateInfoKHR set(int sType, long pNext, VkExtent2D fragmentSize, IntBuffer combinerOps) {
        this.sType(sType);
        this.pNext(pNext);
        this.fragmentSize(fragmentSize);
        this.combinerOps(combinerOps);
        return this;
    }

    public VkPipelineFragmentShadingRateStateCreateInfoKHR set(VkPipelineFragmentShadingRateStateCreateInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPipelineFragmentShadingRateStateCreateInfoKHR malloc() {
        return new VkPipelineFragmentShadingRateStateCreateInfoKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkPipelineFragmentShadingRateStateCreateInfoKHR calloc() {
        return new VkPipelineFragmentShadingRateStateCreateInfoKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkPipelineFragmentShadingRateStateCreateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkPipelineFragmentShadingRateStateCreateInfoKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkPipelineFragmentShadingRateStateCreateInfoKHR create(long address) {
        return new VkPipelineFragmentShadingRateStateCreateInfoKHR(address, null);
    }

    public static @Nullable VkPipelineFragmentShadingRateStateCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkPipelineFragmentShadingRateStateCreateInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkPipelineFragmentShadingRateStateCreateInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPipelineFragmentShadingRateStateCreateInfoKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkPipelineFragmentShadingRateStateCreateInfoKHR malloc(MemoryStack stack) {
        return new VkPipelineFragmentShadingRateStateCreateInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPipelineFragmentShadingRateStateCreateInfoKHR calloc(MemoryStack stack) {
        return new VkPipelineFragmentShadingRateStateCreateInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static VkExtent2D nfragmentSize(long struct) {
        return VkExtent2D.create(struct + (long)FRAGMENTSIZE);
    }

    public static IntBuffer ncombinerOps(long struct) {
        return MemoryUtil.memIntBuffer((long)(struct + (long)COMBINEROPS), (int)2);
    }

    public static int ncombinerOps(long struct, int index) {
        return MemoryUtil.memGetInt((long)(struct + (long)COMBINEROPS + Checks.check((int)index, (int)2) * 4L));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nfragmentSize(long struct, VkExtent2D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FRAGMENTSIZE), (long)VkExtent2D.SIZEOF);
    }

    public static void ncombinerOps(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)2);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((IntBuffer)value), (long)(struct + (long)COMBINEROPS), (long)(value.remaining() * 4));
    }

    public static void ncombinerOps(long struct, int index, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)COMBINEROPS + Checks.check((int)index, (int)2) * 4L), (int)value);
    }

    static {
        Struct.Layout layout = VkPipelineFragmentShadingRateStateCreateInfoKHR.__struct((Struct.Member[])new Struct.Member[]{VkPipelineFragmentShadingRateStateCreateInfoKHR.__member((int)4), VkPipelineFragmentShadingRateStateCreateInfoKHR.__member((int)POINTER_SIZE), VkPipelineFragmentShadingRateStateCreateInfoKHR.__member((int)VkExtent2D.SIZEOF, (int)VkExtent2D.ALIGNOF), VkPipelineFragmentShadingRateStateCreateInfoKHR.__array((int)4, (int)2)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FRAGMENTSIZE = layout.offsetof(2);
        COMBINEROPS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineFragmentShadingRateStateCreateInfoKHR, Buffer>
    implements NativeResource {
        private static final VkPipelineFragmentShadingRateStateCreateInfoKHR ELEMENT_FACTORY = VkPipelineFragmentShadingRateStateCreateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkPipelineFragmentShadingRateStateCreateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPipelineFragmentShadingRateStateCreateInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkPipelineFragmentShadingRateStateCreateInfoKHR.npNext(this.address());
        }

        public VkExtent2D fragmentSize() {
            return VkPipelineFragmentShadingRateStateCreateInfoKHR.nfragmentSize(this.address());
        }

        @NativeType(value="VkFragmentShadingRateCombinerOpKHR[2]")
        public IntBuffer combinerOps() {
            return VkPipelineFragmentShadingRateStateCreateInfoKHR.ncombinerOps(this.address());
        }

        @NativeType(value="VkFragmentShadingRateCombinerOpKHR")
        public int combinerOps(int index) {
            return VkPipelineFragmentShadingRateStateCreateInfoKHR.ncombinerOps(this.address(), index);
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPipelineFragmentShadingRateStateCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000226001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPipelineFragmentShadingRateStateCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer fragmentSize(VkExtent2D value) {
            VkPipelineFragmentShadingRateStateCreateInfoKHR.nfragmentSize(this.address(), value);
            return this;
        }

        public Buffer fragmentSize(Consumer<VkExtent2D> consumer) {
            consumer.accept(this.fragmentSize());
            return this;
        }

        public Buffer combinerOps(@NativeType(value="VkFragmentShadingRateCombinerOpKHR[2]") IntBuffer value) {
            VkPipelineFragmentShadingRateStateCreateInfoKHR.ncombinerOps(this.address(), value);
            return this;
        }

        public Buffer combinerOps(int index, @NativeType(value="VkFragmentShadingRateCombinerOpKHR") int value) {
            VkPipelineFragmentShadingRateStateCreateInfoKHR.ncombinerOps(this.address(), index, value);
            return this;
        }
    }
}

