/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPipelineRenderingCreateInfo
extends Struct<VkPipelineRenderingCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int VIEWMASK;
    public static final int COLORATTACHMENTCOUNT;
    public static final int PCOLORATTACHMENTFORMATS;
    public static final int DEPTHATTACHMENTFORMAT;
    public static final int STENCILATTACHMENTFORMAT;

    protected VkPipelineRenderingCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkPipelineRenderingCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new VkPipelineRenderingCreateInfo(address, container);
    }

    public VkPipelineRenderingCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkPipelineRenderingCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPipelineRenderingCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkPipelineRenderingCreateInfo.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int viewMask() {
        return VkPipelineRenderingCreateInfo.nviewMask(this.address());
    }

    @NativeType(value="uint32_t")
    public int colorAttachmentCount() {
        return VkPipelineRenderingCreateInfo.ncolorAttachmentCount(this.address());
    }

    @NativeType(value="VkFormat const *")
    public @Nullable IntBuffer pColorAttachmentFormats() {
        return VkPipelineRenderingCreateInfo.npColorAttachmentFormats(this.address());
    }

    @NativeType(value="VkFormat")
    public int depthAttachmentFormat() {
        return VkPipelineRenderingCreateInfo.ndepthAttachmentFormat(this.address());
    }

    @NativeType(value="VkFormat")
    public int stencilAttachmentFormat() {
        return VkPipelineRenderingCreateInfo.nstencilAttachmentFormat(this.address());
    }

    public VkPipelineRenderingCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkPipelineRenderingCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkPipelineRenderingCreateInfo sType$Default() {
        return this.sType(1000044002);
    }

    public VkPipelineRenderingCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkPipelineRenderingCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkPipelineRenderingCreateInfo viewMask(@NativeType(value="uint32_t") int value) {
        VkPipelineRenderingCreateInfo.nviewMask(this.address(), value);
        return this;
    }

    public VkPipelineRenderingCreateInfo colorAttachmentCount(@NativeType(value="uint32_t") int value) {
        VkPipelineRenderingCreateInfo.ncolorAttachmentCount(this.address(), value);
        return this;
    }

    public VkPipelineRenderingCreateInfo pColorAttachmentFormats(@NativeType(value="VkFormat const *") @Nullable IntBuffer value) {
        VkPipelineRenderingCreateInfo.npColorAttachmentFormats(this.address(), value);
        return this;
    }

    public VkPipelineRenderingCreateInfo depthAttachmentFormat(@NativeType(value="VkFormat") int value) {
        VkPipelineRenderingCreateInfo.ndepthAttachmentFormat(this.address(), value);
        return this;
    }

    public VkPipelineRenderingCreateInfo stencilAttachmentFormat(@NativeType(value="VkFormat") int value) {
        VkPipelineRenderingCreateInfo.nstencilAttachmentFormat(this.address(), value);
        return this;
    }

    public VkPipelineRenderingCreateInfo set(int sType, long pNext, int viewMask, int colorAttachmentCount, @Nullable IntBuffer pColorAttachmentFormats, int depthAttachmentFormat, int stencilAttachmentFormat) {
        this.sType(sType);
        this.pNext(pNext);
        this.viewMask(viewMask);
        this.colorAttachmentCount(colorAttachmentCount);
        this.pColorAttachmentFormats(pColorAttachmentFormats);
        this.depthAttachmentFormat(depthAttachmentFormat);
        this.stencilAttachmentFormat(stencilAttachmentFormat);
        return this;
    }

    public VkPipelineRenderingCreateInfo set(VkPipelineRenderingCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPipelineRenderingCreateInfo malloc() {
        return new VkPipelineRenderingCreateInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkPipelineRenderingCreateInfo calloc() {
        return new VkPipelineRenderingCreateInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkPipelineRenderingCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkPipelineRenderingCreateInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkPipelineRenderingCreateInfo create(long address) {
        return new VkPipelineRenderingCreateInfo(address, null);
    }

    public static @Nullable VkPipelineRenderingCreateInfo createSafe(long address) {
        return address == 0L ? null : new VkPipelineRenderingCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkPipelineRenderingCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPipelineRenderingCreateInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkPipelineRenderingCreateInfo malloc(MemoryStack stack) {
        return new VkPipelineRenderingCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPipelineRenderingCreateInfo calloc(MemoryStack stack) {
        return new VkPipelineRenderingCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nviewMask(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)VIEWMASK));
    }

    public static int ncolorAttachmentCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)COLORATTACHMENTCOUNT));
    }

    public static @Nullable IntBuffer npColorAttachmentFormats(long struct) {
        return MemoryUtil.memIntBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PCOLORATTACHMENTFORMATS)), (int)VkPipelineRenderingCreateInfo.ncolorAttachmentCount(struct));
    }

    public static int ndepthAttachmentFormat(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DEPTHATTACHMENTFORMAT));
    }

    public static int nstencilAttachmentFormat(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STENCILATTACHMENTFORMAT));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nviewMask(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)VIEWMASK), (int)value);
    }

    public static void ncolorAttachmentCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)COLORATTACHMENTCOUNT), (int)value);
    }

    public static void npColorAttachmentFormats(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PCOLORATTACHMENTFORMATS), (long)MemoryUtil.memAddressSafe((IntBuffer)value));
        if (value != null) {
            VkPipelineRenderingCreateInfo.ncolorAttachmentCount(struct, value.remaining());
        }
    }

    public static void ndepthAttachmentFormat(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)DEPTHATTACHMENTFORMAT), (int)value);
    }

    public static void nstencilAttachmentFormat(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STENCILATTACHMENTFORMAT), (int)value);
    }

    static {
        Struct.Layout layout = VkPipelineRenderingCreateInfo.__struct((Struct.Member[])new Struct.Member[]{VkPipelineRenderingCreateInfo.__member((int)4), VkPipelineRenderingCreateInfo.__member((int)POINTER_SIZE), VkPipelineRenderingCreateInfo.__member((int)4), VkPipelineRenderingCreateInfo.__member((int)4), VkPipelineRenderingCreateInfo.__member((int)POINTER_SIZE), VkPipelineRenderingCreateInfo.__member((int)4), VkPipelineRenderingCreateInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        VIEWMASK = layout.offsetof(2);
        COLORATTACHMENTCOUNT = layout.offsetof(3);
        PCOLORATTACHMENTFORMATS = layout.offsetof(4);
        DEPTHATTACHMENTFORMAT = layout.offsetof(5);
        STENCILATTACHMENTFORMAT = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineRenderingCreateInfo, Buffer>
    implements NativeResource {
        private static final VkPipelineRenderingCreateInfo ELEMENT_FACTORY = VkPipelineRenderingCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkPipelineRenderingCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPipelineRenderingCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkPipelineRenderingCreateInfo.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int viewMask() {
            return VkPipelineRenderingCreateInfo.nviewMask(this.address());
        }

        @NativeType(value="uint32_t")
        public int colorAttachmentCount() {
            return VkPipelineRenderingCreateInfo.ncolorAttachmentCount(this.address());
        }

        @NativeType(value="VkFormat const *")
        public @Nullable IntBuffer pColorAttachmentFormats() {
            return VkPipelineRenderingCreateInfo.npColorAttachmentFormats(this.address());
        }

        @NativeType(value="VkFormat")
        public int depthAttachmentFormat() {
            return VkPipelineRenderingCreateInfo.ndepthAttachmentFormat(this.address());
        }

        @NativeType(value="VkFormat")
        public int stencilAttachmentFormat() {
            return VkPipelineRenderingCreateInfo.nstencilAttachmentFormat(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPipelineRenderingCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000044002);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPipelineRenderingCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer viewMask(@NativeType(value="uint32_t") int value) {
            VkPipelineRenderingCreateInfo.nviewMask(this.address(), value);
            return this;
        }

        public Buffer colorAttachmentCount(@NativeType(value="uint32_t") int value) {
            VkPipelineRenderingCreateInfo.ncolorAttachmentCount(this.address(), value);
            return this;
        }

        public Buffer pColorAttachmentFormats(@NativeType(value="VkFormat const *") @Nullable IntBuffer value) {
            VkPipelineRenderingCreateInfo.npColorAttachmentFormats(this.address(), value);
            return this;
        }

        public Buffer depthAttachmentFormat(@NativeType(value="VkFormat") int value) {
            VkPipelineRenderingCreateInfo.ndepthAttachmentFormat(this.address(), value);
            return this;
        }

        public Buffer stencilAttachmentFormat(@NativeType(value="VkFormat") int value) {
            VkPipelineRenderingCreateInfo.nstencilAttachmentFormat(this.address(), value);
            return this;
        }
    }
}

