/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkPipelineViewportCoarseSampleOrderStateCreateInfoNV;
import org.lwjgl.vulkan.VkPipelineViewportDepthClampControlCreateInfoEXT;
import org.lwjgl.vulkan.VkPipelineViewportDepthClipControlCreateInfoEXT;
import org.lwjgl.vulkan.VkPipelineViewportExclusiveScissorStateCreateInfoNV;
import org.lwjgl.vulkan.VkPipelineViewportShadingRateImageStateCreateInfoNV;
import org.lwjgl.vulkan.VkPipelineViewportSwizzleStateCreateInfoNV;
import org.lwjgl.vulkan.VkPipelineViewportWScalingStateCreateInfoNV;
import org.lwjgl.vulkan.VkRect2D;
import org.lwjgl.vulkan.VkViewport;

public class VkPipelineViewportStateCreateInfo
extends Struct<VkPipelineViewportStateCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int VIEWPORTCOUNT;
    public static final int PVIEWPORTS;
    public static final int SCISSORCOUNT;
    public static final int PSCISSORS;

    protected VkPipelineViewportStateCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkPipelineViewportStateCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new VkPipelineViewportStateCreateInfo(address, container);
    }

    public VkPipelineViewportStateCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkPipelineViewportStateCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPipelineViewportStateCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkPipelineViewportStateCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkPipelineViewportStateCreateFlags")
    public int flags() {
        return VkPipelineViewportStateCreateInfo.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int viewportCount() {
        return VkPipelineViewportStateCreateInfo.nviewportCount(this.address());
    }

    @NativeType(value="VkViewport const *")
    public @Nullable VkViewport.Buffer pViewports() {
        return VkPipelineViewportStateCreateInfo.npViewports(this.address());
    }

    @NativeType(value="uint32_t")
    public int scissorCount() {
        return VkPipelineViewportStateCreateInfo.nscissorCount(this.address());
    }

    @NativeType(value="VkRect2D const *")
    public @Nullable VkRect2D.Buffer pScissors() {
        return VkPipelineViewportStateCreateInfo.npScissors(this.address());
    }

    public VkPipelineViewportStateCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkPipelineViewportStateCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkPipelineViewportStateCreateInfo sType$Default() {
        return this.sType(22);
    }

    public VkPipelineViewportStateCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkPipelineViewportStateCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkPipelineViewportStateCreateInfo pNext(VkPipelineViewportCoarseSampleOrderStateCreateInfoNV value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkPipelineViewportStateCreateInfo pNext(VkPipelineViewportDepthClampControlCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkPipelineViewportStateCreateInfo pNext(VkPipelineViewportDepthClipControlCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkPipelineViewportStateCreateInfo pNext(VkPipelineViewportExclusiveScissorStateCreateInfoNV value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkPipelineViewportStateCreateInfo pNext(VkPipelineViewportShadingRateImageStateCreateInfoNV value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkPipelineViewportStateCreateInfo pNext(VkPipelineViewportSwizzleStateCreateInfoNV value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkPipelineViewportStateCreateInfo pNext(VkPipelineViewportWScalingStateCreateInfoNV value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkPipelineViewportStateCreateInfo flags(@NativeType(value="VkPipelineViewportStateCreateFlags") int value) {
        VkPipelineViewportStateCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkPipelineViewportStateCreateInfo viewportCount(@NativeType(value="uint32_t") int value) {
        VkPipelineViewportStateCreateInfo.nviewportCount(this.address(), value);
        return this;
    }

    public VkPipelineViewportStateCreateInfo pViewports(@NativeType(value="VkViewport const *") @Nullable VkViewport.Buffer value) {
        VkPipelineViewportStateCreateInfo.npViewports(this.address(), value);
        return this;
    }

    public VkPipelineViewportStateCreateInfo scissorCount(@NativeType(value="uint32_t") int value) {
        VkPipelineViewportStateCreateInfo.nscissorCount(this.address(), value);
        return this;
    }

    public VkPipelineViewportStateCreateInfo pScissors(@NativeType(value="VkRect2D const *") @Nullable VkRect2D.Buffer value) {
        VkPipelineViewportStateCreateInfo.npScissors(this.address(), value);
        return this;
    }

    public VkPipelineViewportStateCreateInfo set(int sType, long pNext, int flags, int viewportCount, @Nullable VkViewport.Buffer pViewports, int scissorCount, @Nullable VkRect2D.Buffer pScissors) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.viewportCount(viewportCount);
        this.pViewports(pViewports);
        this.scissorCount(scissorCount);
        this.pScissors(pScissors);
        return this;
    }

    public VkPipelineViewportStateCreateInfo set(VkPipelineViewportStateCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPipelineViewportStateCreateInfo malloc() {
        return new VkPipelineViewportStateCreateInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkPipelineViewportStateCreateInfo calloc() {
        return new VkPipelineViewportStateCreateInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkPipelineViewportStateCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkPipelineViewportStateCreateInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkPipelineViewportStateCreateInfo create(long address) {
        return new VkPipelineViewportStateCreateInfo(address, null);
    }

    public static @Nullable VkPipelineViewportStateCreateInfo createSafe(long address) {
        return address == 0L ? null : new VkPipelineViewportStateCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkPipelineViewportStateCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPipelineViewportStateCreateInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkPipelineViewportStateCreateInfo mallocStack() {
        return VkPipelineViewportStateCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPipelineViewportStateCreateInfo callocStack() {
        return VkPipelineViewportStateCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPipelineViewportStateCreateInfo mallocStack(MemoryStack stack) {
        return VkPipelineViewportStateCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VkPipelineViewportStateCreateInfo callocStack(MemoryStack stack) {
        return VkPipelineViewportStateCreateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkPipelineViewportStateCreateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkPipelineViewportStateCreateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPipelineViewportStateCreateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPipelineViewportStateCreateInfo.calloc(capacity, stack);
    }

    public static VkPipelineViewportStateCreateInfo malloc(MemoryStack stack) {
        return new VkPipelineViewportStateCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPipelineViewportStateCreateInfo calloc(MemoryStack stack) {
        return new VkPipelineViewportStateCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FLAGS));
    }

    public static int nviewportCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)VIEWPORTCOUNT));
    }

    public static @Nullable VkViewport.Buffer npViewports(long struct) {
        return VkViewport.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PVIEWPORTS)), VkPipelineViewportStateCreateInfo.nviewportCount(struct));
    }

    public static int nscissorCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SCISSORCOUNT));
    }

    public static @Nullable VkRect2D.Buffer npScissors(long struct) {
        return VkRect2D.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PSCISSORS)), VkPipelineViewportStateCreateInfo.nscissorCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FLAGS), (int)value);
    }

    public static void nviewportCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)VIEWPORTCOUNT), (int)value);
    }

    public static void npViewports(long struct, @Nullable VkViewport.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PVIEWPORTS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        if (value != null) {
            VkPipelineViewportStateCreateInfo.nviewportCount(struct, value.remaining());
        }
    }

    public static void nscissorCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SCISSORCOUNT), (int)value);
    }

    public static void npScissors(long struct, @Nullable VkRect2D.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PSCISSORS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        if (value != null) {
            VkPipelineViewportStateCreateInfo.nscissorCount(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = VkPipelineViewportStateCreateInfo.__struct((Struct.Member[])new Struct.Member[]{VkPipelineViewportStateCreateInfo.__member((int)4), VkPipelineViewportStateCreateInfo.__member((int)POINTER_SIZE), VkPipelineViewportStateCreateInfo.__member((int)4), VkPipelineViewportStateCreateInfo.__member((int)4), VkPipelineViewportStateCreateInfo.__member((int)POINTER_SIZE), VkPipelineViewportStateCreateInfo.__member((int)4), VkPipelineViewportStateCreateInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        VIEWPORTCOUNT = layout.offsetof(3);
        PVIEWPORTS = layout.offsetof(4);
        SCISSORCOUNT = layout.offsetof(5);
        PSCISSORS = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineViewportStateCreateInfo, Buffer>
    implements NativeResource {
        private static final VkPipelineViewportStateCreateInfo ELEMENT_FACTORY = VkPipelineViewportStateCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkPipelineViewportStateCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPipelineViewportStateCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkPipelineViewportStateCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkPipelineViewportStateCreateFlags")
        public int flags() {
            return VkPipelineViewportStateCreateInfo.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int viewportCount() {
            return VkPipelineViewportStateCreateInfo.nviewportCount(this.address());
        }

        @NativeType(value="VkViewport const *")
        public @Nullable VkViewport.Buffer pViewports() {
            return VkPipelineViewportStateCreateInfo.npViewports(this.address());
        }

        @NativeType(value="uint32_t")
        public int scissorCount() {
            return VkPipelineViewportStateCreateInfo.nscissorCount(this.address());
        }

        @NativeType(value="VkRect2D const *")
        public @Nullable VkRect2D.Buffer pScissors() {
            return VkPipelineViewportStateCreateInfo.npScissors(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPipelineViewportStateCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(22);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPipelineViewportStateCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkPipelineViewportCoarseSampleOrderStateCreateInfoNV value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineViewportDepthClampControlCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineViewportDepthClipControlCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineViewportExclusiveScissorStateCreateInfoNV value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineViewportShadingRateImageStateCreateInfoNV value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineViewportSwizzleStateCreateInfoNV value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineViewportWScalingStateCreateInfoNV value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkPipelineViewportStateCreateFlags") int value) {
            VkPipelineViewportStateCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer viewportCount(@NativeType(value="uint32_t") int value) {
            VkPipelineViewportStateCreateInfo.nviewportCount(this.address(), value);
            return this;
        }

        public Buffer pViewports(@NativeType(value="VkViewport const *") @Nullable VkViewport.Buffer value) {
            VkPipelineViewportStateCreateInfo.npViewports(this.address(), value);
            return this;
        }

        public Buffer scissorCount(@NativeType(value="uint32_t") int value) {
            VkPipelineViewportStateCreateInfo.nscissorCount(this.address(), value);
            return this;
        }

        public Buffer pScissors(@NativeType(value="VkRect2D const *") @Nullable VkRect2D.Buffer value) {
            VkPipelineViewportStateCreateInfo.npScissors(this.address(), value);
            return this;
        }
    }
}

