/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkQueueFamilyGlobalPriorityProperties
extends Struct<VkQueueFamilyGlobalPriorityProperties>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PRIORITYCOUNT;
    public static final int PRIORITIES;

    protected VkQueueFamilyGlobalPriorityProperties(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkQueueFamilyGlobalPriorityProperties create(long address, @Nullable ByteBuffer container) {
        return new VkQueueFamilyGlobalPriorityProperties(address, container);
    }

    public VkQueueFamilyGlobalPriorityProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkQueueFamilyGlobalPriorityProperties.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkQueueFamilyGlobalPriorityProperties.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkQueueFamilyGlobalPriorityProperties.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int priorityCount() {
        return VkQueueFamilyGlobalPriorityProperties.npriorityCount(this.address());
    }

    @NativeType(value="VkQueueGlobalPriority[VK_MAX_GLOBAL_PRIORITY_SIZE]")
    public IntBuffer priorities() {
        return VkQueueFamilyGlobalPriorityProperties.npriorities(this.address());
    }

    @NativeType(value="VkQueueGlobalPriority")
    public int priorities(int index) {
        return VkQueueFamilyGlobalPriorityProperties.npriorities(this.address(), index);
    }

    public VkQueueFamilyGlobalPriorityProperties sType(@NativeType(value="VkStructureType") int value) {
        VkQueueFamilyGlobalPriorityProperties.nsType(this.address(), value);
        return this;
    }

    public VkQueueFamilyGlobalPriorityProperties sType$Default() {
        return this.sType(1000388001);
    }

    public VkQueueFamilyGlobalPriorityProperties pNext(@NativeType(value="void *") long value) {
        VkQueueFamilyGlobalPriorityProperties.npNext(this.address(), value);
        return this;
    }

    public VkQueueFamilyGlobalPriorityProperties set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkQueueFamilyGlobalPriorityProperties set(VkQueueFamilyGlobalPriorityProperties src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkQueueFamilyGlobalPriorityProperties malloc() {
        return new VkQueueFamilyGlobalPriorityProperties(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkQueueFamilyGlobalPriorityProperties calloc() {
        return new VkQueueFamilyGlobalPriorityProperties(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkQueueFamilyGlobalPriorityProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkQueueFamilyGlobalPriorityProperties(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkQueueFamilyGlobalPriorityProperties create(long address) {
        return new VkQueueFamilyGlobalPriorityProperties(address, null);
    }

    public static @Nullable VkQueueFamilyGlobalPriorityProperties createSafe(long address) {
        return address == 0L ? null : new VkQueueFamilyGlobalPriorityProperties(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkQueueFamilyGlobalPriorityProperties.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkQueueFamilyGlobalPriorityProperties.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkQueueFamilyGlobalPriorityProperties malloc(MemoryStack stack) {
        return new VkQueueFamilyGlobalPriorityProperties(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkQueueFamilyGlobalPriorityProperties calloc(MemoryStack stack) {
        return new VkQueueFamilyGlobalPriorityProperties(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int npriorityCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)PRIORITYCOUNT));
    }

    public static IntBuffer npriorities(long struct) {
        return MemoryUtil.memIntBuffer((long)(struct + (long)PRIORITIES), (int)VkQueueFamilyGlobalPriorityProperties.npriorityCount(struct));
    }

    public static int npriorities(long struct, int index) {
        return MemoryUtil.memGetInt((long)(struct + (long)PRIORITIES + Checks.check((int)index, (int)16) * 4L));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    static {
        Struct.Layout layout = VkQueueFamilyGlobalPriorityProperties.__struct((Struct.Member[])new Struct.Member[]{VkQueueFamilyGlobalPriorityProperties.__member((int)4), VkQueueFamilyGlobalPriorityProperties.__member((int)POINTER_SIZE), VkQueueFamilyGlobalPriorityProperties.__member((int)4), VkQueueFamilyGlobalPriorityProperties.__array((int)4, (int)16)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PRIORITYCOUNT = layout.offsetof(2);
        PRIORITIES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkQueueFamilyGlobalPriorityProperties, Buffer>
    implements NativeResource {
        private static final VkQueueFamilyGlobalPriorityProperties ELEMENT_FACTORY = VkQueueFamilyGlobalPriorityProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkQueueFamilyGlobalPriorityProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkQueueFamilyGlobalPriorityProperties.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkQueueFamilyGlobalPriorityProperties.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int priorityCount() {
            return VkQueueFamilyGlobalPriorityProperties.npriorityCount(this.address());
        }

        @NativeType(value="VkQueueGlobalPriority[VK_MAX_GLOBAL_PRIORITY_SIZE]")
        public IntBuffer priorities() {
            return VkQueueFamilyGlobalPriorityProperties.npriorities(this.address());
        }

        @NativeType(value="VkQueueGlobalPriority")
        public int priorities(int index) {
            return VkQueueFamilyGlobalPriorityProperties.npriorities(this.address(), index);
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkQueueFamilyGlobalPriorityProperties.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000388001);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkQueueFamilyGlobalPriorityProperties.npNext(this.address(), value);
            return this;
        }
    }
}

