/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkRenderPassAttachmentBeginInfo
extends Struct<VkRenderPassAttachmentBeginInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int ATTACHMENTCOUNT;
    public static final int PATTACHMENTS;

    protected VkRenderPassAttachmentBeginInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkRenderPassAttachmentBeginInfo create(long address, @Nullable ByteBuffer container) {
        return new VkRenderPassAttachmentBeginInfo(address, container);
    }

    public VkRenderPassAttachmentBeginInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkRenderPassAttachmentBeginInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkRenderPassAttachmentBeginInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkRenderPassAttachmentBeginInfo.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int attachmentCount() {
        return VkRenderPassAttachmentBeginInfo.nattachmentCount(this.address());
    }

    @NativeType(value="VkImageView const *")
    public @Nullable LongBuffer pAttachments() {
        return VkRenderPassAttachmentBeginInfo.npAttachments(this.address());
    }

    public VkRenderPassAttachmentBeginInfo sType(@NativeType(value="VkStructureType") int value) {
        VkRenderPassAttachmentBeginInfo.nsType(this.address(), value);
        return this;
    }

    public VkRenderPassAttachmentBeginInfo sType$Default() {
        return this.sType(1000108003);
    }

    public VkRenderPassAttachmentBeginInfo pNext(@NativeType(value="void const *") long value) {
        VkRenderPassAttachmentBeginInfo.npNext(this.address(), value);
        return this;
    }

    public VkRenderPassAttachmentBeginInfo pAttachments(@NativeType(value="VkImageView const *") @Nullable LongBuffer value) {
        VkRenderPassAttachmentBeginInfo.npAttachments(this.address(), value);
        return this;
    }

    public VkRenderPassAttachmentBeginInfo set(int sType, long pNext, @Nullable LongBuffer pAttachments) {
        this.sType(sType);
        this.pNext(pNext);
        this.pAttachments(pAttachments);
        return this;
    }

    public VkRenderPassAttachmentBeginInfo set(VkRenderPassAttachmentBeginInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkRenderPassAttachmentBeginInfo malloc() {
        return new VkRenderPassAttachmentBeginInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkRenderPassAttachmentBeginInfo calloc() {
        return new VkRenderPassAttachmentBeginInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkRenderPassAttachmentBeginInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkRenderPassAttachmentBeginInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkRenderPassAttachmentBeginInfo create(long address) {
        return new VkRenderPassAttachmentBeginInfo(address, null);
    }

    public static @Nullable VkRenderPassAttachmentBeginInfo createSafe(long address) {
        return address == 0L ? null : new VkRenderPassAttachmentBeginInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkRenderPassAttachmentBeginInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkRenderPassAttachmentBeginInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkRenderPassAttachmentBeginInfo malloc(MemoryStack stack) {
        return new VkRenderPassAttachmentBeginInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkRenderPassAttachmentBeginInfo calloc(MemoryStack stack) {
        return new VkRenderPassAttachmentBeginInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nattachmentCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)ATTACHMENTCOUNT));
    }

    public static @Nullable LongBuffer npAttachments(long struct) {
        return MemoryUtil.memLongBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PATTACHMENTS)), (int)VkRenderPassAttachmentBeginInfo.nattachmentCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nattachmentCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)ATTACHMENTCOUNT), (int)value);
    }

    public static void npAttachments(long struct, @Nullable LongBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PATTACHMENTS), (long)MemoryUtil.memAddressSafe((LongBuffer)value));
        VkRenderPassAttachmentBeginInfo.nattachmentCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkRenderPassAttachmentBeginInfo.nattachmentCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PATTACHMENTS)));
        }
    }

    static {
        Struct.Layout layout = VkRenderPassAttachmentBeginInfo.__struct((Struct.Member[])new Struct.Member[]{VkRenderPassAttachmentBeginInfo.__member((int)4), VkRenderPassAttachmentBeginInfo.__member((int)POINTER_SIZE), VkRenderPassAttachmentBeginInfo.__member((int)4), VkRenderPassAttachmentBeginInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        ATTACHMENTCOUNT = layout.offsetof(2);
        PATTACHMENTS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkRenderPassAttachmentBeginInfo, Buffer>
    implements NativeResource {
        private static final VkRenderPassAttachmentBeginInfo ELEMENT_FACTORY = VkRenderPassAttachmentBeginInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkRenderPassAttachmentBeginInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkRenderPassAttachmentBeginInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkRenderPassAttachmentBeginInfo.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int attachmentCount() {
            return VkRenderPassAttachmentBeginInfo.nattachmentCount(this.address());
        }

        @NativeType(value="VkImageView const *")
        public @Nullable LongBuffer pAttachments() {
            return VkRenderPassAttachmentBeginInfo.npAttachments(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkRenderPassAttachmentBeginInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000108003);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkRenderPassAttachmentBeginInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pAttachments(@NativeType(value="VkImageView const *") @Nullable LongBuffer value) {
            VkRenderPassAttachmentBeginInfo.npAttachments(this.address(), value);
            return this;
        }
    }
}

