/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkClearValue;
import org.lwjgl.vulkan.VkDeviceGroupRenderPassBeginInfo;
import org.lwjgl.vulkan.VkDeviceGroupRenderPassBeginInfoKHR;
import org.lwjgl.vulkan.VkMultiviewPerViewRenderAreasRenderPassBeginInfoQCOM;
import org.lwjgl.vulkan.VkRect2D;
import org.lwjgl.vulkan.VkRenderPassAttachmentBeginInfo;
import org.lwjgl.vulkan.VkRenderPassAttachmentBeginInfoKHR;
import org.lwjgl.vulkan.VkRenderPassSampleLocationsBeginInfoEXT;
import org.lwjgl.vulkan.VkRenderPassStripeBeginInfoARM;
import org.lwjgl.vulkan.VkRenderPassTransformBeginInfoQCOM;

public class VkRenderPassBeginInfo
extends Struct<VkRenderPassBeginInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int RENDERPASS;
    public static final int FRAMEBUFFER;
    public static final int RENDERAREA;
    public static final int CLEARVALUECOUNT;
    public static final int PCLEARVALUES;

    protected VkRenderPassBeginInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkRenderPassBeginInfo create(long address, @Nullable ByteBuffer container) {
        return new VkRenderPassBeginInfo(address, container);
    }

    public VkRenderPassBeginInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkRenderPassBeginInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkRenderPassBeginInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkRenderPassBeginInfo.npNext(this.address());
    }

    @NativeType(value="VkRenderPass")
    public long renderPass() {
        return VkRenderPassBeginInfo.nrenderPass(this.address());
    }

    @NativeType(value="VkFramebuffer")
    public long framebuffer() {
        return VkRenderPassBeginInfo.nframebuffer(this.address());
    }

    public VkRect2D renderArea() {
        return VkRenderPassBeginInfo.nrenderArea(this.address());
    }

    @NativeType(value="uint32_t")
    public int clearValueCount() {
        return VkRenderPassBeginInfo.nclearValueCount(this.address());
    }

    @NativeType(value="VkClearValue const *")
    public @Nullable VkClearValue.Buffer pClearValues() {
        return VkRenderPassBeginInfo.npClearValues(this.address());
    }

    public VkRenderPassBeginInfo sType(@NativeType(value="VkStructureType") int value) {
        VkRenderPassBeginInfo.nsType(this.address(), value);
        return this;
    }

    public VkRenderPassBeginInfo sType$Default() {
        return this.sType(43);
    }

    public VkRenderPassBeginInfo pNext(@NativeType(value="void const *") long value) {
        VkRenderPassBeginInfo.npNext(this.address(), value);
        return this;
    }

    public VkRenderPassBeginInfo pNext(VkDeviceGroupRenderPassBeginInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkRenderPassBeginInfo pNext(VkDeviceGroupRenderPassBeginInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkRenderPassBeginInfo pNext(VkMultiviewPerViewRenderAreasRenderPassBeginInfoQCOM value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkRenderPassBeginInfo pNext(VkRenderPassAttachmentBeginInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkRenderPassBeginInfo pNext(VkRenderPassAttachmentBeginInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkRenderPassBeginInfo pNext(VkRenderPassSampleLocationsBeginInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkRenderPassBeginInfo pNext(VkRenderPassStripeBeginInfoARM value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkRenderPassBeginInfo pNext(VkRenderPassTransformBeginInfoQCOM value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkRenderPassBeginInfo renderPass(@NativeType(value="VkRenderPass") long value) {
        VkRenderPassBeginInfo.nrenderPass(this.address(), value);
        return this;
    }

    public VkRenderPassBeginInfo framebuffer(@NativeType(value="VkFramebuffer") long value) {
        VkRenderPassBeginInfo.nframebuffer(this.address(), value);
        return this;
    }

    public VkRenderPassBeginInfo renderArea(VkRect2D value) {
        VkRenderPassBeginInfo.nrenderArea(this.address(), value);
        return this;
    }

    public VkRenderPassBeginInfo renderArea(Consumer<VkRect2D> consumer) {
        consumer.accept(this.renderArea());
        return this;
    }

    public VkRenderPassBeginInfo clearValueCount(@NativeType(value="uint32_t") int value) {
        VkRenderPassBeginInfo.nclearValueCount(this.address(), value);
        return this;
    }

    public VkRenderPassBeginInfo pClearValues(@NativeType(value="VkClearValue const *") @Nullable VkClearValue.Buffer value) {
        VkRenderPassBeginInfo.npClearValues(this.address(), value);
        return this;
    }

    public VkRenderPassBeginInfo set(int sType, long pNext, long renderPass, long framebuffer, VkRect2D renderArea, int clearValueCount, @Nullable VkClearValue.Buffer pClearValues) {
        this.sType(sType);
        this.pNext(pNext);
        this.renderPass(renderPass);
        this.framebuffer(framebuffer);
        this.renderArea(renderArea);
        this.clearValueCount(clearValueCount);
        this.pClearValues(pClearValues);
        return this;
    }

    public VkRenderPassBeginInfo set(VkRenderPassBeginInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkRenderPassBeginInfo malloc() {
        return new VkRenderPassBeginInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkRenderPassBeginInfo calloc() {
        return new VkRenderPassBeginInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkRenderPassBeginInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkRenderPassBeginInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkRenderPassBeginInfo create(long address) {
        return new VkRenderPassBeginInfo(address, null);
    }

    public static @Nullable VkRenderPassBeginInfo createSafe(long address) {
        return address == 0L ? null : new VkRenderPassBeginInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkRenderPassBeginInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkRenderPassBeginInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkRenderPassBeginInfo mallocStack() {
        return VkRenderPassBeginInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkRenderPassBeginInfo callocStack() {
        return VkRenderPassBeginInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkRenderPassBeginInfo mallocStack(MemoryStack stack) {
        return VkRenderPassBeginInfo.malloc(stack);
    }

    @Deprecated
    public static VkRenderPassBeginInfo callocStack(MemoryStack stack) {
        return VkRenderPassBeginInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkRenderPassBeginInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkRenderPassBeginInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkRenderPassBeginInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkRenderPassBeginInfo.calloc(capacity, stack);
    }

    public static VkRenderPassBeginInfo malloc(MemoryStack stack) {
        return new VkRenderPassBeginInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkRenderPassBeginInfo calloc(MemoryStack stack) {
        return new VkRenderPassBeginInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long nrenderPass(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)RENDERPASS));
    }

    public static long nframebuffer(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)FRAMEBUFFER));
    }

    public static VkRect2D nrenderArea(long struct) {
        return VkRect2D.create(struct + (long)RENDERAREA);
    }

    public static int nclearValueCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)CLEARVALUECOUNT));
    }

    public static @Nullable VkClearValue.Buffer npClearValues(long struct) {
        return VkClearValue.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PCLEARVALUES)), VkRenderPassBeginInfo.nclearValueCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nrenderPass(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)RENDERPASS), (long)value);
    }

    public static void nframebuffer(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)FRAMEBUFFER), (long)value);
    }

    public static void nrenderArea(long struct, VkRect2D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)RENDERAREA), (long)VkRect2D.SIZEOF);
    }

    public static void nclearValueCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)CLEARVALUECOUNT), (int)value);
    }

    public static void npClearValues(long struct, @Nullable VkClearValue.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PCLEARVALUES), (long)MemoryUtil.memAddressSafe((Pointer)value));
        if (value != null) {
            VkRenderPassBeginInfo.nclearValueCount(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = VkRenderPassBeginInfo.__struct((Struct.Member[])new Struct.Member[]{VkRenderPassBeginInfo.__member((int)4), VkRenderPassBeginInfo.__member((int)POINTER_SIZE), VkRenderPassBeginInfo.__member((int)8), VkRenderPassBeginInfo.__member((int)8), VkRenderPassBeginInfo.__member((int)VkRect2D.SIZEOF, (int)VkRect2D.ALIGNOF), VkRenderPassBeginInfo.__member((int)4), VkRenderPassBeginInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        RENDERPASS = layout.offsetof(2);
        FRAMEBUFFER = layout.offsetof(3);
        RENDERAREA = layout.offsetof(4);
        CLEARVALUECOUNT = layout.offsetof(5);
        PCLEARVALUES = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkRenderPassBeginInfo, Buffer>
    implements NativeResource {
        private static final VkRenderPassBeginInfo ELEMENT_FACTORY = VkRenderPassBeginInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkRenderPassBeginInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkRenderPassBeginInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkRenderPassBeginInfo.npNext(this.address());
        }

        @NativeType(value="VkRenderPass")
        public long renderPass() {
            return VkRenderPassBeginInfo.nrenderPass(this.address());
        }

        @NativeType(value="VkFramebuffer")
        public long framebuffer() {
            return VkRenderPassBeginInfo.nframebuffer(this.address());
        }

        public VkRect2D renderArea() {
            return VkRenderPassBeginInfo.nrenderArea(this.address());
        }

        @NativeType(value="uint32_t")
        public int clearValueCount() {
            return VkRenderPassBeginInfo.nclearValueCount(this.address());
        }

        @NativeType(value="VkClearValue const *")
        public @Nullable VkClearValue.Buffer pClearValues() {
            return VkRenderPassBeginInfo.npClearValues(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkRenderPassBeginInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(43);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkRenderPassBeginInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkDeviceGroupRenderPassBeginInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkDeviceGroupRenderPassBeginInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkMultiviewPerViewRenderAreasRenderPassBeginInfoQCOM value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkRenderPassAttachmentBeginInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkRenderPassAttachmentBeginInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkRenderPassSampleLocationsBeginInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkRenderPassStripeBeginInfoARM value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkRenderPassTransformBeginInfoQCOM value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer renderPass(@NativeType(value="VkRenderPass") long value) {
            VkRenderPassBeginInfo.nrenderPass(this.address(), value);
            return this;
        }

        public Buffer framebuffer(@NativeType(value="VkFramebuffer") long value) {
            VkRenderPassBeginInfo.nframebuffer(this.address(), value);
            return this;
        }

        public Buffer renderArea(VkRect2D value) {
            VkRenderPassBeginInfo.nrenderArea(this.address(), value);
            return this;
        }

        public Buffer renderArea(Consumer<VkRect2D> consumer) {
            consumer.accept(this.renderArea());
            return this;
        }

        public Buffer clearValueCount(@NativeType(value="uint32_t") int value) {
            VkRenderPassBeginInfo.nclearValueCount(this.address(), value);
            return this;
        }

        public Buffer pClearValues(@NativeType(value="VkClearValue const *") @Nullable VkClearValue.Buffer value) {
            VkRenderPassBeginInfo.npClearValues(this.address(), value);
            return this;
        }
    }
}

