/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAttachmentDescription;
import org.lwjgl.vulkan.VkRenderPassFragmentDensityMapCreateInfoEXT;
import org.lwjgl.vulkan.VkRenderPassInputAttachmentAspectCreateInfo;
import org.lwjgl.vulkan.VkRenderPassInputAttachmentAspectCreateInfoKHR;
import org.lwjgl.vulkan.VkRenderPassMultiviewCreateInfo;
import org.lwjgl.vulkan.VkRenderPassMultiviewCreateInfoKHR;
import org.lwjgl.vulkan.VkSubpassDependency;
import org.lwjgl.vulkan.VkSubpassDescription;

public class VkRenderPassCreateInfo
extends Struct<VkRenderPassCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int ATTACHMENTCOUNT;
    public static final int PATTACHMENTS;
    public static final int SUBPASSCOUNT;
    public static final int PSUBPASSES;
    public static final int DEPENDENCYCOUNT;
    public static final int PDEPENDENCIES;

    protected VkRenderPassCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkRenderPassCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new VkRenderPassCreateInfo(address, container);
    }

    public VkRenderPassCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkRenderPassCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkRenderPassCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkRenderPassCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkRenderPassCreateFlags")
    public int flags() {
        return VkRenderPassCreateInfo.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int attachmentCount() {
        return VkRenderPassCreateInfo.nattachmentCount(this.address());
    }

    @NativeType(value="VkAttachmentDescription const *")
    public @Nullable VkAttachmentDescription.Buffer pAttachments() {
        return VkRenderPassCreateInfo.npAttachments(this.address());
    }

    @NativeType(value="uint32_t")
    public int subpassCount() {
        return VkRenderPassCreateInfo.nsubpassCount(this.address());
    }

    @NativeType(value="VkSubpassDescription const *")
    public VkSubpassDescription.Buffer pSubpasses() {
        return VkRenderPassCreateInfo.npSubpasses(this.address());
    }

    @NativeType(value="uint32_t")
    public int dependencyCount() {
        return VkRenderPassCreateInfo.ndependencyCount(this.address());
    }

    @NativeType(value="VkSubpassDependency const *")
    public @Nullable VkSubpassDependency.Buffer pDependencies() {
        return VkRenderPassCreateInfo.npDependencies(this.address());
    }

    public VkRenderPassCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkRenderPassCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkRenderPassCreateInfo sType$Default() {
        return this.sType(38);
    }

    public VkRenderPassCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkRenderPassCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkRenderPassCreateInfo pNext(VkRenderPassFragmentDensityMapCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkRenderPassCreateInfo pNext(VkRenderPassInputAttachmentAspectCreateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkRenderPassCreateInfo pNext(VkRenderPassInputAttachmentAspectCreateInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkRenderPassCreateInfo pNext(VkRenderPassMultiviewCreateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkRenderPassCreateInfo pNext(VkRenderPassMultiviewCreateInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkRenderPassCreateInfo flags(@NativeType(value="VkRenderPassCreateFlags") int value) {
        VkRenderPassCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkRenderPassCreateInfo pAttachments(@NativeType(value="VkAttachmentDescription const *") @Nullable VkAttachmentDescription.Buffer value) {
        VkRenderPassCreateInfo.npAttachments(this.address(), value);
        return this;
    }

    public VkRenderPassCreateInfo pSubpasses(@NativeType(value="VkSubpassDescription const *") VkSubpassDescription.Buffer value) {
        VkRenderPassCreateInfo.npSubpasses(this.address(), value);
        return this;
    }

    public VkRenderPassCreateInfo pDependencies(@NativeType(value="VkSubpassDependency const *") @Nullable VkSubpassDependency.Buffer value) {
        VkRenderPassCreateInfo.npDependencies(this.address(), value);
        return this;
    }

    public VkRenderPassCreateInfo set(int sType, long pNext, int flags, @Nullable VkAttachmentDescription.Buffer pAttachments, VkSubpassDescription.Buffer pSubpasses, @Nullable VkSubpassDependency.Buffer pDependencies) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pAttachments(pAttachments);
        this.pSubpasses(pSubpasses);
        this.pDependencies(pDependencies);
        return this;
    }

    public VkRenderPassCreateInfo set(VkRenderPassCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkRenderPassCreateInfo malloc() {
        return new VkRenderPassCreateInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkRenderPassCreateInfo calloc() {
        return new VkRenderPassCreateInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkRenderPassCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkRenderPassCreateInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkRenderPassCreateInfo create(long address) {
        return new VkRenderPassCreateInfo(address, null);
    }

    public static @Nullable VkRenderPassCreateInfo createSafe(long address) {
        return address == 0L ? null : new VkRenderPassCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkRenderPassCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkRenderPassCreateInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkRenderPassCreateInfo mallocStack() {
        return VkRenderPassCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkRenderPassCreateInfo callocStack() {
        return VkRenderPassCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkRenderPassCreateInfo mallocStack(MemoryStack stack) {
        return VkRenderPassCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VkRenderPassCreateInfo callocStack(MemoryStack stack) {
        return VkRenderPassCreateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkRenderPassCreateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkRenderPassCreateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkRenderPassCreateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkRenderPassCreateInfo.calloc(capacity, stack);
    }

    public static VkRenderPassCreateInfo malloc(MemoryStack stack) {
        return new VkRenderPassCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkRenderPassCreateInfo calloc(MemoryStack stack) {
        return new VkRenderPassCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FLAGS));
    }

    public static int nattachmentCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)ATTACHMENTCOUNT));
    }

    public static @Nullable VkAttachmentDescription.Buffer npAttachments(long struct) {
        return VkAttachmentDescription.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PATTACHMENTS)), VkRenderPassCreateInfo.nattachmentCount(struct));
    }

    public static int nsubpassCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SUBPASSCOUNT));
    }

    public static VkSubpassDescription.Buffer npSubpasses(long struct) {
        return VkSubpassDescription.create(MemoryUtil.memGetAddress((long)(struct + (long)PSUBPASSES)), VkRenderPassCreateInfo.nsubpassCount(struct));
    }

    public static int ndependencyCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DEPENDENCYCOUNT));
    }

    public static @Nullable VkSubpassDependency.Buffer npDependencies(long struct) {
        return VkSubpassDependency.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PDEPENDENCIES)), VkRenderPassCreateInfo.ndependencyCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FLAGS), (int)value);
    }

    public static void nattachmentCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)ATTACHMENTCOUNT), (int)value);
    }

    public static void npAttachments(long struct, @Nullable VkAttachmentDescription.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PATTACHMENTS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkRenderPassCreateInfo.nattachmentCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nsubpassCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SUBPASSCOUNT), (int)value);
    }

    public static void npSubpasses(long struct, VkSubpassDescription.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PSUBPASSES), (long)value.address());
        VkRenderPassCreateInfo.nsubpassCount(struct, value.remaining());
    }

    public static void ndependencyCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)DEPENDENCYCOUNT), (int)value);
    }

    public static void npDependencies(long struct, @Nullable VkSubpassDependency.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PDEPENDENCIES), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkRenderPassCreateInfo.ndependencyCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkRenderPassCreateInfo.nattachmentCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PATTACHMENTS)));
        }
        int subpassCount = VkRenderPassCreateInfo.nsubpassCount(struct);
        long pSubpasses = MemoryUtil.memGetAddress((long)(struct + (long)PSUBPASSES));
        Checks.check((long)pSubpasses);
        VkRenderPassCreateInfo.validate((long)pSubpasses, (int)subpassCount, (int)VkSubpassDescription.SIZEOF, VkSubpassDescription::validate);
        if (VkRenderPassCreateInfo.ndependencyCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PDEPENDENCIES)));
        }
    }

    static {
        Struct.Layout layout = VkRenderPassCreateInfo.__struct((Struct.Member[])new Struct.Member[]{VkRenderPassCreateInfo.__member((int)4), VkRenderPassCreateInfo.__member((int)POINTER_SIZE), VkRenderPassCreateInfo.__member((int)4), VkRenderPassCreateInfo.__member((int)4), VkRenderPassCreateInfo.__member((int)POINTER_SIZE), VkRenderPassCreateInfo.__member((int)4), VkRenderPassCreateInfo.__member((int)POINTER_SIZE), VkRenderPassCreateInfo.__member((int)4), VkRenderPassCreateInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        ATTACHMENTCOUNT = layout.offsetof(3);
        PATTACHMENTS = layout.offsetof(4);
        SUBPASSCOUNT = layout.offsetof(5);
        PSUBPASSES = layout.offsetof(6);
        DEPENDENCYCOUNT = layout.offsetof(7);
        PDEPENDENCIES = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<VkRenderPassCreateInfo, Buffer>
    implements NativeResource {
        private static final VkRenderPassCreateInfo ELEMENT_FACTORY = VkRenderPassCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkRenderPassCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkRenderPassCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkRenderPassCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkRenderPassCreateFlags")
        public int flags() {
            return VkRenderPassCreateInfo.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int attachmentCount() {
            return VkRenderPassCreateInfo.nattachmentCount(this.address());
        }

        @NativeType(value="VkAttachmentDescription const *")
        public @Nullable VkAttachmentDescription.Buffer pAttachments() {
            return VkRenderPassCreateInfo.npAttachments(this.address());
        }

        @NativeType(value="uint32_t")
        public int subpassCount() {
            return VkRenderPassCreateInfo.nsubpassCount(this.address());
        }

        @NativeType(value="VkSubpassDescription const *")
        public VkSubpassDescription.Buffer pSubpasses() {
            return VkRenderPassCreateInfo.npSubpasses(this.address());
        }

        @NativeType(value="uint32_t")
        public int dependencyCount() {
            return VkRenderPassCreateInfo.ndependencyCount(this.address());
        }

        @NativeType(value="VkSubpassDependency const *")
        public @Nullable VkSubpassDependency.Buffer pDependencies() {
            return VkRenderPassCreateInfo.npDependencies(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkRenderPassCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(38);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkRenderPassCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkRenderPassFragmentDensityMapCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkRenderPassInputAttachmentAspectCreateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkRenderPassInputAttachmentAspectCreateInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkRenderPassMultiviewCreateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkRenderPassMultiviewCreateInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkRenderPassCreateFlags") int value) {
            VkRenderPassCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer pAttachments(@NativeType(value="VkAttachmentDescription const *") @Nullable VkAttachmentDescription.Buffer value) {
            VkRenderPassCreateInfo.npAttachments(this.address(), value);
            return this;
        }

        public Buffer pSubpasses(@NativeType(value="VkSubpassDescription const *") VkSubpassDescription.Buffer value) {
            VkRenderPassCreateInfo.npSubpasses(this.address(), value);
            return this;
        }

        public Buffer pDependencies(@NativeType(value="VkSubpassDependency const *") @Nullable VkSubpassDependency.Buffer value) {
            VkRenderPassCreateInfo.npDependencies(this.address(), value);
            return this;
        }
    }
}

