/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkRenderingAreaInfo;

public class VkRenderingAreaInfoKHR
extends VkRenderingAreaInfo {
    protected VkRenderingAreaInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkRenderingAreaInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkRenderingAreaInfoKHR(address, container);
    }

    public VkRenderingAreaInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkRenderingAreaInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkRenderingAreaInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkRenderingAreaInfoKHR sType$Default() {
        return this.sType(1000470003);
    }

    @Override
    public VkRenderingAreaInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkRenderingAreaInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkRenderingAreaInfoKHR viewMask(@NativeType(value="uint32_t") int value) {
        VkRenderingAreaInfoKHR.nviewMask(this.address(), value);
        return this;
    }

    @Override
    public VkRenderingAreaInfoKHR colorAttachmentCount(@NativeType(value="uint32_t") int value) {
        VkRenderingAreaInfoKHR.ncolorAttachmentCount(this.address(), value);
        return this;
    }

    @Override
    public VkRenderingAreaInfoKHR pColorAttachmentFormats(@NativeType(value="VkFormat const *") @Nullable IntBuffer value) {
        VkRenderingAreaInfoKHR.npColorAttachmentFormats(this.address(), value);
        return this;
    }

    @Override
    public VkRenderingAreaInfoKHR depthAttachmentFormat(@NativeType(value="VkFormat") int value) {
        VkRenderingAreaInfoKHR.ndepthAttachmentFormat(this.address(), value);
        return this;
    }

    @Override
    public VkRenderingAreaInfoKHR stencilAttachmentFormat(@NativeType(value="VkFormat") int value) {
        VkRenderingAreaInfoKHR.nstencilAttachmentFormat(this.address(), value);
        return this;
    }

    @Override
    public VkRenderingAreaInfoKHR set(int sType, long pNext, int viewMask, int colorAttachmentCount, @Nullable IntBuffer pColorAttachmentFormats, int depthAttachmentFormat, int stencilAttachmentFormat) {
        this.sType(sType);
        this.pNext(pNext);
        this.viewMask(viewMask);
        this.colorAttachmentCount(colorAttachmentCount);
        this.pColorAttachmentFormats(pColorAttachmentFormats);
        this.depthAttachmentFormat(depthAttachmentFormat);
        this.stencilAttachmentFormat(stencilAttachmentFormat);
        return this;
    }

    public VkRenderingAreaInfoKHR set(VkRenderingAreaInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkRenderingAreaInfoKHR malloc() {
        return new VkRenderingAreaInfoKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkRenderingAreaInfoKHR calloc() {
        return new VkRenderingAreaInfoKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkRenderingAreaInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkRenderingAreaInfoKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkRenderingAreaInfoKHR create(long address) {
        return new VkRenderingAreaInfoKHR(address, null);
    }

    public static @Nullable VkRenderingAreaInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkRenderingAreaInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkRenderingAreaInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkRenderingAreaInfoKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkRenderingAreaInfoKHR malloc(MemoryStack stack) {
        return new VkRenderingAreaInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkRenderingAreaInfoKHR calloc(MemoryStack stack) {
        return new VkRenderingAreaInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkRenderingAreaInfo.Buffer {
        private static final VkRenderingAreaInfoKHR ELEMENT_FACTORY = VkRenderingAreaInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkRenderingAreaInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkRenderingAreaInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000470003);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkRenderingAreaInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer viewMask(@NativeType(value="uint32_t") int value) {
            VkRenderingAreaInfoKHR.nviewMask(this.address(), value);
            return this;
        }

        @Override
        public Buffer colorAttachmentCount(@NativeType(value="uint32_t") int value) {
            VkRenderingAreaInfoKHR.ncolorAttachmentCount(this.address(), value);
            return this;
        }

        @Override
        public Buffer pColorAttachmentFormats(@NativeType(value="VkFormat const *") @Nullable IntBuffer value) {
            VkRenderingAreaInfoKHR.npColorAttachmentFormats(this.address(), value);
            return this;
        }

        @Override
        public Buffer depthAttachmentFormat(@NativeType(value="VkFormat") int value) {
            VkRenderingAreaInfoKHR.ndepthAttachmentFormat(this.address(), value);
            return this;
        }

        @Override
        public Buffer stencilAttachmentFormat(@NativeType(value="VkFormat") int value) {
            VkRenderingAreaInfoKHR.nstencilAttachmentFormat(this.address(), value);
            return this;
        }
    }
}

