/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkSRTDataNV
extends Struct<VkSRTDataNV>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SX;
    public static final int A;
    public static final int B;
    public static final int PVX;
    public static final int SY;
    public static final int C;
    public static final int PVY;
    public static final int SZ;
    public static final int PVZ;
    public static final int QX;
    public static final int QY;
    public static final int QZ;
    public static final int QW;
    public static final int TX;
    public static final int TY;
    public static final int TZ;

    protected VkSRTDataNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkSRTDataNV create(long address, @Nullable ByteBuffer container) {
        return new VkSRTDataNV(address, container);
    }

    public VkSRTDataNV(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkSRTDataNV.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float sx() {
        return VkSRTDataNV.nsx(this.address());
    }

    public float a() {
        return VkSRTDataNV.na(this.address());
    }

    public float b() {
        return VkSRTDataNV.nb(this.address());
    }

    public float pvx() {
        return VkSRTDataNV.npvx(this.address());
    }

    public float sy() {
        return VkSRTDataNV.nsy(this.address());
    }

    public float c() {
        return VkSRTDataNV.nc(this.address());
    }

    public float pvy() {
        return VkSRTDataNV.npvy(this.address());
    }

    public float sz() {
        return VkSRTDataNV.nsz(this.address());
    }

    public float pvz() {
        return VkSRTDataNV.npvz(this.address());
    }

    public float qx() {
        return VkSRTDataNV.nqx(this.address());
    }

    public float qy() {
        return VkSRTDataNV.nqy(this.address());
    }

    public float qz() {
        return VkSRTDataNV.nqz(this.address());
    }

    public float qw() {
        return VkSRTDataNV.nqw(this.address());
    }

    public float tx() {
        return VkSRTDataNV.ntx(this.address());
    }

    public float ty() {
        return VkSRTDataNV.nty(this.address());
    }

    public float tz() {
        return VkSRTDataNV.ntz(this.address());
    }

    public VkSRTDataNV sx(float value) {
        VkSRTDataNV.nsx(this.address(), value);
        return this;
    }

    public VkSRTDataNV a(float value) {
        VkSRTDataNV.na(this.address(), value);
        return this;
    }

    public VkSRTDataNV b(float value) {
        VkSRTDataNV.nb(this.address(), value);
        return this;
    }

    public VkSRTDataNV pvx(float value) {
        VkSRTDataNV.npvx(this.address(), value);
        return this;
    }

    public VkSRTDataNV sy(float value) {
        VkSRTDataNV.nsy(this.address(), value);
        return this;
    }

    public VkSRTDataNV c(float value) {
        VkSRTDataNV.nc(this.address(), value);
        return this;
    }

    public VkSRTDataNV pvy(float value) {
        VkSRTDataNV.npvy(this.address(), value);
        return this;
    }

    public VkSRTDataNV sz(float value) {
        VkSRTDataNV.nsz(this.address(), value);
        return this;
    }

    public VkSRTDataNV pvz(float value) {
        VkSRTDataNV.npvz(this.address(), value);
        return this;
    }

    public VkSRTDataNV qx(float value) {
        VkSRTDataNV.nqx(this.address(), value);
        return this;
    }

    public VkSRTDataNV qy(float value) {
        VkSRTDataNV.nqy(this.address(), value);
        return this;
    }

    public VkSRTDataNV qz(float value) {
        VkSRTDataNV.nqz(this.address(), value);
        return this;
    }

    public VkSRTDataNV qw(float value) {
        VkSRTDataNV.nqw(this.address(), value);
        return this;
    }

    public VkSRTDataNV tx(float value) {
        VkSRTDataNV.ntx(this.address(), value);
        return this;
    }

    public VkSRTDataNV ty(float value) {
        VkSRTDataNV.nty(this.address(), value);
        return this;
    }

    public VkSRTDataNV tz(float value) {
        VkSRTDataNV.ntz(this.address(), value);
        return this;
    }

    public VkSRTDataNV set(float sx, float a, float b, float pvx, float sy, float c, float pvy, float sz, float pvz, float qx, float qy, float qz, float qw, float tx, float ty, float tz) {
        this.sx(sx);
        this.a(a);
        this.b(b);
        this.pvx(pvx);
        this.sy(sy);
        this.c(c);
        this.pvy(pvy);
        this.sz(sz);
        this.pvz(pvz);
        this.qx(qx);
        this.qy(qy);
        this.qz(qz);
        this.qw(qw);
        this.tx(tx);
        this.ty(ty);
        this.tz(tz);
        return this;
    }

    public VkSRTDataNV set(VkSRTDataNV src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkSRTDataNV malloc() {
        return new VkSRTDataNV(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkSRTDataNV calloc() {
        return new VkSRTDataNV(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkSRTDataNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkSRTDataNV(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkSRTDataNV create(long address) {
        return new VkSRTDataNV(address, null);
    }

    public static @Nullable VkSRTDataNV createSafe(long address) {
        return address == 0L ? null : new VkSRTDataNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkSRTDataNV.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSRTDataNV.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkSRTDataNV malloc(MemoryStack stack) {
        return new VkSRTDataNV(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkSRTDataNV calloc(MemoryStack stack) {
        return new VkSRTDataNV(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nsx(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)SX));
    }

    public static float na(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)A));
    }

    public static float nb(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)B));
    }

    public static float npvx(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)PVX));
    }

    public static float nsy(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)SY));
    }

    public static float nc(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)C));
    }

    public static float npvy(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)PVY));
    }

    public static float nsz(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)SZ));
    }

    public static float npvz(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)PVZ));
    }

    public static float nqx(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)QX));
    }

    public static float nqy(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)QY));
    }

    public static float nqz(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)QZ));
    }

    public static float nqw(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)QW));
    }

    public static float ntx(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)TX));
    }

    public static float nty(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)TY));
    }

    public static float ntz(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)TZ));
    }

    public static void nsx(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)SX), (float)value);
    }

    public static void na(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)A), (float)value);
    }

    public static void nb(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)B), (float)value);
    }

    public static void npvx(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)PVX), (float)value);
    }

    public static void nsy(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)SY), (float)value);
    }

    public static void nc(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)C), (float)value);
    }

    public static void npvy(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)PVY), (float)value);
    }

    public static void nsz(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)SZ), (float)value);
    }

    public static void npvz(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)PVZ), (float)value);
    }

    public static void nqx(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)QX), (float)value);
    }

    public static void nqy(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)QY), (float)value);
    }

    public static void nqz(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)QZ), (float)value);
    }

    public static void nqw(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)QW), (float)value);
    }

    public static void ntx(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)TX), (float)value);
    }

    public static void nty(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)TY), (float)value);
    }

    public static void ntz(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)TZ), (float)value);
    }

    static {
        Struct.Layout layout = VkSRTDataNV.__struct((Struct.Member[])new Struct.Member[]{VkSRTDataNV.__member((int)4), VkSRTDataNV.__member((int)4), VkSRTDataNV.__member((int)4), VkSRTDataNV.__member((int)4), VkSRTDataNV.__member((int)4), VkSRTDataNV.__member((int)4), VkSRTDataNV.__member((int)4), VkSRTDataNV.__member((int)4), VkSRTDataNV.__member((int)4), VkSRTDataNV.__member((int)4), VkSRTDataNV.__member((int)4), VkSRTDataNV.__member((int)4), VkSRTDataNV.__member((int)4), VkSRTDataNV.__member((int)4), VkSRTDataNV.__member((int)4), VkSRTDataNV.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SX = layout.offsetof(0);
        A = layout.offsetof(1);
        B = layout.offsetof(2);
        PVX = layout.offsetof(3);
        SY = layout.offsetof(4);
        C = layout.offsetof(5);
        PVY = layout.offsetof(6);
        SZ = layout.offsetof(7);
        PVZ = layout.offsetof(8);
        QX = layout.offsetof(9);
        QY = layout.offsetof(10);
        QZ = layout.offsetof(11);
        QW = layout.offsetof(12);
        TX = layout.offsetof(13);
        TY = layout.offsetof(14);
        TZ = layout.offsetof(15);
    }

    public static class Buffer
    extends StructBuffer<VkSRTDataNV, Buffer>
    implements NativeResource {
        private static final VkSRTDataNV ELEMENT_FACTORY = VkSRTDataNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkSRTDataNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float sx() {
            return VkSRTDataNV.nsx(this.address());
        }

        public float a() {
            return VkSRTDataNV.na(this.address());
        }

        public float b() {
            return VkSRTDataNV.nb(this.address());
        }

        public float pvx() {
            return VkSRTDataNV.npvx(this.address());
        }

        public float sy() {
            return VkSRTDataNV.nsy(this.address());
        }

        public float c() {
            return VkSRTDataNV.nc(this.address());
        }

        public float pvy() {
            return VkSRTDataNV.npvy(this.address());
        }

        public float sz() {
            return VkSRTDataNV.nsz(this.address());
        }

        public float pvz() {
            return VkSRTDataNV.npvz(this.address());
        }

        public float qx() {
            return VkSRTDataNV.nqx(this.address());
        }

        public float qy() {
            return VkSRTDataNV.nqy(this.address());
        }

        public float qz() {
            return VkSRTDataNV.nqz(this.address());
        }

        public float qw() {
            return VkSRTDataNV.nqw(this.address());
        }

        public float tx() {
            return VkSRTDataNV.ntx(this.address());
        }

        public float ty() {
            return VkSRTDataNV.nty(this.address());
        }

        public float tz() {
            return VkSRTDataNV.ntz(this.address());
        }

        public Buffer sx(float value) {
            VkSRTDataNV.nsx(this.address(), value);
            return this;
        }

        public Buffer a(float value) {
            VkSRTDataNV.na(this.address(), value);
            return this;
        }

        public Buffer b(float value) {
            VkSRTDataNV.nb(this.address(), value);
            return this;
        }

        public Buffer pvx(float value) {
            VkSRTDataNV.npvx(this.address(), value);
            return this;
        }

        public Buffer sy(float value) {
            VkSRTDataNV.nsy(this.address(), value);
            return this;
        }

        public Buffer c(float value) {
            VkSRTDataNV.nc(this.address(), value);
            return this;
        }

        public Buffer pvy(float value) {
            VkSRTDataNV.npvy(this.address(), value);
            return this;
        }

        public Buffer sz(float value) {
            VkSRTDataNV.nsz(this.address(), value);
            return this;
        }

        public Buffer pvz(float value) {
            VkSRTDataNV.npvz(this.address(), value);
            return this;
        }

        public Buffer qx(float value) {
            VkSRTDataNV.nqx(this.address(), value);
            return this;
        }

        public Buffer qy(float value) {
            VkSRTDataNV.nqy(this.address(), value);
            return this;
        }

        public Buffer qz(float value) {
            VkSRTDataNV.nqz(this.address(), value);
            return this;
        }

        public Buffer qw(float value) {
            VkSRTDataNV.nqw(this.address(), value);
            return this;
        }

        public Buffer tx(float value) {
            VkSRTDataNV.ntx(this.address(), value);
            return this;
        }

        public Buffer ty(float value) {
            VkSRTDataNV.nty(this.address(), value);
            return this;
        }

        public Buffer tz(float value) {
            VkSRTDataNV.ntz(this.address(), value);
            return this;
        }
    }
}

