/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkPipelineShaderStageRequiredSubgroupSizeCreateInfo;
import org.lwjgl.vulkan.VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT;
import org.lwjgl.vulkan.VkPushConstantRange;
import org.lwjgl.vulkan.VkShaderRequiredSubgroupSizeCreateInfoEXT;
import org.lwjgl.vulkan.VkSpecializationInfo;
import org.lwjgl.vulkan.VkValidationFeaturesEXT;

public class VkShaderCreateInfoEXT
extends Struct<VkShaderCreateInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int STAGE;
    public static final int NEXTSTAGE;
    public static final int CODETYPE;
    public static final int CODESIZE;
    public static final int PCODE;
    public static final int PNAME;
    public static final int SETLAYOUTCOUNT;
    public static final int PSETLAYOUTS;
    public static final int PUSHCONSTANTRANGECOUNT;
    public static final int PPUSHCONSTANTRANGES;
    public static final int PSPECIALIZATIONINFO;

    protected VkShaderCreateInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkShaderCreateInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkShaderCreateInfoEXT(address, container);
    }

    public VkShaderCreateInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkShaderCreateInfoEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkShaderCreateInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkShaderCreateInfoEXT.npNext(this.address());
    }

    @NativeType(value="VkShaderCreateFlagsEXT")
    public int flags() {
        return VkShaderCreateInfoEXT.nflags(this.address());
    }

    @NativeType(value="VkShaderStageFlagBits")
    public int stage() {
        return VkShaderCreateInfoEXT.nstage(this.address());
    }

    @NativeType(value="VkShaderStageFlags")
    public int nextStage() {
        return VkShaderCreateInfoEXT.nnextStage(this.address());
    }

    @NativeType(value="VkShaderCodeTypeEXT")
    public int codeType() {
        return VkShaderCreateInfoEXT.ncodeType(this.address());
    }

    @NativeType(value="size_t")
    public long codeSize() {
        return VkShaderCreateInfoEXT.ncodeSize(this.address());
    }

    @NativeType(value="void const *")
    public ByteBuffer pCode() {
        return VkShaderCreateInfoEXT.npCode(this.address());
    }

    @NativeType(value="char const *")
    public @Nullable ByteBuffer pName() {
        return VkShaderCreateInfoEXT.npName(this.address());
    }

    @NativeType(value="char const *")
    public @Nullable String pNameString() {
        return VkShaderCreateInfoEXT.npNameString(this.address());
    }

    @NativeType(value="uint32_t")
    public int setLayoutCount() {
        return VkShaderCreateInfoEXT.nsetLayoutCount(this.address());
    }

    @NativeType(value="VkDescriptorSetLayout const *")
    public @Nullable LongBuffer pSetLayouts() {
        return VkShaderCreateInfoEXT.npSetLayouts(this.address());
    }

    @NativeType(value="uint32_t")
    public int pushConstantRangeCount() {
        return VkShaderCreateInfoEXT.npushConstantRangeCount(this.address());
    }

    @NativeType(value="VkPushConstantRange const *")
    public @Nullable VkPushConstantRange.Buffer pPushConstantRanges() {
        return VkShaderCreateInfoEXT.npPushConstantRanges(this.address());
    }

    @NativeType(value="VkSpecializationInfo const *")
    public @Nullable VkSpecializationInfo pSpecializationInfo() {
        return VkShaderCreateInfoEXT.npSpecializationInfo(this.address());
    }

    public VkShaderCreateInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkShaderCreateInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkShaderCreateInfoEXT sType$Default() {
        return this.sType(1000482002);
    }

    public VkShaderCreateInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkShaderCreateInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkShaderCreateInfoEXT pNext(VkPipelineShaderStageRequiredSubgroupSizeCreateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkShaderCreateInfoEXT pNext(VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkShaderCreateInfoEXT pNext(VkShaderRequiredSubgroupSizeCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkShaderCreateInfoEXT pNext(VkValidationFeaturesEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkShaderCreateInfoEXT flags(@NativeType(value="VkShaderCreateFlagsEXT") int value) {
        VkShaderCreateInfoEXT.nflags(this.address(), value);
        return this;
    }

    public VkShaderCreateInfoEXT stage(@NativeType(value="VkShaderStageFlagBits") int value) {
        VkShaderCreateInfoEXT.nstage(this.address(), value);
        return this;
    }

    public VkShaderCreateInfoEXT nextStage(@NativeType(value="VkShaderStageFlags") int value) {
        VkShaderCreateInfoEXT.nnextStage(this.address(), value);
        return this;
    }

    public VkShaderCreateInfoEXT codeType(@NativeType(value="VkShaderCodeTypeEXT") int value) {
        VkShaderCreateInfoEXT.ncodeType(this.address(), value);
        return this;
    }

    public VkShaderCreateInfoEXT pCode(@NativeType(value="void const *") ByteBuffer value) {
        VkShaderCreateInfoEXT.npCode(this.address(), value);
        return this;
    }

    public VkShaderCreateInfoEXT pName(@NativeType(value="char const *") @Nullable ByteBuffer value) {
        VkShaderCreateInfoEXT.npName(this.address(), value);
        return this;
    }

    public VkShaderCreateInfoEXT setLayoutCount(@NativeType(value="uint32_t") int value) {
        VkShaderCreateInfoEXT.nsetLayoutCount(this.address(), value);
        return this;
    }

    public VkShaderCreateInfoEXT pSetLayouts(@NativeType(value="VkDescriptorSetLayout const *") @Nullable LongBuffer value) {
        VkShaderCreateInfoEXT.npSetLayouts(this.address(), value);
        return this;
    }

    public VkShaderCreateInfoEXT pushConstantRangeCount(@NativeType(value="uint32_t") int value) {
        VkShaderCreateInfoEXT.npushConstantRangeCount(this.address(), value);
        return this;
    }

    public VkShaderCreateInfoEXT pPushConstantRanges(@NativeType(value="VkPushConstantRange const *") @Nullable VkPushConstantRange.Buffer value) {
        VkShaderCreateInfoEXT.npPushConstantRanges(this.address(), value);
        return this;
    }

    public VkShaderCreateInfoEXT pSpecializationInfo(@NativeType(value="VkSpecializationInfo const *") @Nullable VkSpecializationInfo value) {
        VkShaderCreateInfoEXT.npSpecializationInfo(this.address(), value);
        return this;
    }

    public VkShaderCreateInfoEXT set(int sType, long pNext, int flags, int stage, int nextStage, int codeType, ByteBuffer pCode, @Nullable ByteBuffer pName, int setLayoutCount, @Nullable LongBuffer pSetLayouts, int pushConstantRangeCount, @Nullable VkPushConstantRange.Buffer pPushConstantRanges, @Nullable VkSpecializationInfo pSpecializationInfo) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.stage(stage);
        this.nextStage(nextStage);
        this.codeType(codeType);
        this.pCode(pCode);
        this.pName(pName);
        this.setLayoutCount(setLayoutCount);
        this.pSetLayouts(pSetLayouts);
        this.pushConstantRangeCount(pushConstantRangeCount);
        this.pPushConstantRanges(pPushConstantRanges);
        this.pSpecializationInfo(pSpecializationInfo);
        return this;
    }

    public VkShaderCreateInfoEXT set(VkShaderCreateInfoEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkShaderCreateInfoEXT malloc() {
        return new VkShaderCreateInfoEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkShaderCreateInfoEXT calloc() {
        return new VkShaderCreateInfoEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkShaderCreateInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkShaderCreateInfoEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkShaderCreateInfoEXT create(long address) {
        return new VkShaderCreateInfoEXT(address, null);
    }

    public static @Nullable VkShaderCreateInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkShaderCreateInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkShaderCreateInfoEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkShaderCreateInfoEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkShaderCreateInfoEXT malloc(MemoryStack stack) {
        return new VkShaderCreateInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkShaderCreateInfoEXT calloc(MemoryStack stack) {
        return new VkShaderCreateInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FLAGS));
    }

    public static int nstage(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STAGE));
    }

    public static int nnextStage(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)NEXTSTAGE));
    }

    public static int ncodeType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)CODETYPE));
    }

    public static long ncodeSize(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)CODESIZE));
    }

    public static ByteBuffer npCode(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PCODE)), (int)((int)VkShaderCreateInfoEXT.ncodeSize(struct)));
    }

    public static @Nullable ByteBuffer npName(long struct) {
        return MemoryUtil.memByteBufferNT1Safe((long)MemoryUtil.memGetAddress((long)(struct + (long)PNAME)));
    }

    public static @Nullable String npNameString(long struct) {
        return MemoryUtil.memUTF8Safe((long)MemoryUtil.memGetAddress((long)(struct + (long)PNAME)));
    }

    public static int nsetLayoutCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SETLAYOUTCOUNT));
    }

    public static @Nullable LongBuffer npSetLayouts(long struct) {
        return MemoryUtil.memLongBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PSETLAYOUTS)), (int)VkShaderCreateInfoEXT.nsetLayoutCount(struct));
    }

    public static int npushConstantRangeCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)PUSHCONSTANTRANGECOUNT));
    }

    public static @Nullable VkPushConstantRange.Buffer npPushConstantRanges(long struct) {
        return VkPushConstantRange.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PPUSHCONSTANTRANGES)), VkShaderCreateInfoEXT.npushConstantRangeCount(struct));
    }

    public static @Nullable VkSpecializationInfo npSpecializationInfo(long struct) {
        return VkSpecializationInfo.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PSPECIALIZATIONINFO)));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FLAGS), (int)value);
    }

    public static void nstage(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STAGE), (int)value);
    }

    public static void nnextStage(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)NEXTSTAGE), (int)value);
    }

    public static void ncodeType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)CODETYPE), (int)value);
    }

    public static void ncodeSize(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CODESIZE), (long)value);
    }

    public static void npCode(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PCODE), (long)MemoryUtil.memAddress((ByteBuffer)value));
        VkShaderCreateInfoEXT.ncodeSize(struct, value.remaining());
    }

    public static void npName(long struct, @Nullable ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)PNAME), (long)MemoryUtil.memAddressSafe((ByteBuffer)value));
    }

    public static void nsetLayoutCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SETLAYOUTCOUNT), (int)value);
    }

    public static void npSetLayouts(long struct, @Nullable LongBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PSETLAYOUTS), (long)MemoryUtil.memAddressSafe((LongBuffer)value));
        if (value != null) {
            VkShaderCreateInfoEXT.nsetLayoutCount(struct, value.remaining());
        }
    }

    public static void npushConstantRangeCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)PUSHCONSTANTRANGECOUNT), (int)value);
    }

    public static void npPushConstantRanges(long struct, @Nullable VkPushConstantRange.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PPUSHCONSTANTRANGES), (long)MemoryUtil.memAddressSafe((Pointer)value));
        if (value != null) {
            VkShaderCreateInfoEXT.npushConstantRangeCount(struct, value.remaining());
        }
    }

    public static void npSpecializationInfo(long struct, @Nullable VkSpecializationInfo value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PSPECIALIZATIONINFO), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PCODE)));
        long pSpecializationInfo = MemoryUtil.memGetAddress((long)(struct + (long)PSPECIALIZATIONINFO));
        if (pSpecializationInfo != 0L) {
            VkSpecializationInfo.validate(pSpecializationInfo);
        }
    }

    static {
        Struct.Layout layout = VkShaderCreateInfoEXT.__struct((Struct.Member[])new Struct.Member[]{VkShaderCreateInfoEXT.__member((int)4), VkShaderCreateInfoEXT.__member((int)POINTER_SIZE), VkShaderCreateInfoEXT.__member((int)4), VkShaderCreateInfoEXT.__member((int)4), VkShaderCreateInfoEXT.__member((int)4), VkShaderCreateInfoEXT.__member((int)4), VkShaderCreateInfoEXT.__member((int)POINTER_SIZE), VkShaderCreateInfoEXT.__member((int)POINTER_SIZE), VkShaderCreateInfoEXT.__member((int)POINTER_SIZE), VkShaderCreateInfoEXT.__member((int)4), VkShaderCreateInfoEXT.__member((int)POINTER_SIZE), VkShaderCreateInfoEXT.__member((int)4), VkShaderCreateInfoEXT.__member((int)POINTER_SIZE), VkShaderCreateInfoEXT.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        STAGE = layout.offsetof(3);
        NEXTSTAGE = layout.offsetof(4);
        CODETYPE = layout.offsetof(5);
        CODESIZE = layout.offsetof(6);
        PCODE = layout.offsetof(7);
        PNAME = layout.offsetof(8);
        SETLAYOUTCOUNT = layout.offsetof(9);
        PSETLAYOUTS = layout.offsetof(10);
        PUSHCONSTANTRANGECOUNT = layout.offsetof(11);
        PPUSHCONSTANTRANGES = layout.offsetof(12);
        PSPECIALIZATIONINFO = layout.offsetof(13);
    }

    public static class Buffer
    extends StructBuffer<VkShaderCreateInfoEXT, Buffer>
    implements NativeResource {
        private static final VkShaderCreateInfoEXT ELEMENT_FACTORY = VkShaderCreateInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkShaderCreateInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkShaderCreateInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkShaderCreateInfoEXT.npNext(this.address());
        }

        @NativeType(value="VkShaderCreateFlagsEXT")
        public int flags() {
            return VkShaderCreateInfoEXT.nflags(this.address());
        }

        @NativeType(value="VkShaderStageFlagBits")
        public int stage() {
            return VkShaderCreateInfoEXT.nstage(this.address());
        }

        @NativeType(value="VkShaderStageFlags")
        public int nextStage() {
            return VkShaderCreateInfoEXT.nnextStage(this.address());
        }

        @NativeType(value="VkShaderCodeTypeEXT")
        public int codeType() {
            return VkShaderCreateInfoEXT.ncodeType(this.address());
        }

        @NativeType(value="size_t")
        public long codeSize() {
            return VkShaderCreateInfoEXT.ncodeSize(this.address());
        }

        @NativeType(value="void const *")
        public ByteBuffer pCode() {
            return VkShaderCreateInfoEXT.npCode(this.address());
        }

        @NativeType(value="char const *")
        public @Nullable ByteBuffer pName() {
            return VkShaderCreateInfoEXT.npName(this.address());
        }

        @NativeType(value="char const *")
        public @Nullable String pNameString() {
            return VkShaderCreateInfoEXT.npNameString(this.address());
        }

        @NativeType(value="uint32_t")
        public int setLayoutCount() {
            return VkShaderCreateInfoEXT.nsetLayoutCount(this.address());
        }

        @NativeType(value="VkDescriptorSetLayout const *")
        public @Nullable LongBuffer pSetLayouts() {
            return VkShaderCreateInfoEXT.npSetLayouts(this.address());
        }

        @NativeType(value="uint32_t")
        public int pushConstantRangeCount() {
            return VkShaderCreateInfoEXT.npushConstantRangeCount(this.address());
        }

        @NativeType(value="VkPushConstantRange const *")
        public @Nullable VkPushConstantRange.Buffer pPushConstantRanges() {
            return VkShaderCreateInfoEXT.npPushConstantRanges(this.address());
        }

        @NativeType(value="VkSpecializationInfo const *")
        public @Nullable VkSpecializationInfo pSpecializationInfo() {
            return VkShaderCreateInfoEXT.npSpecializationInfo(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkShaderCreateInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000482002);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkShaderCreateInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkPipelineShaderStageRequiredSubgroupSizeCreateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkShaderRequiredSubgroupSizeCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkValidationFeaturesEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkShaderCreateFlagsEXT") int value) {
            VkShaderCreateInfoEXT.nflags(this.address(), value);
            return this;
        }

        public Buffer stage(@NativeType(value="VkShaderStageFlagBits") int value) {
            VkShaderCreateInfoEXT.nstage(this.address(), value);
            return this;
        }

        public Buffer nextStage(@NativeType(value="VkShaderStageFlags") int value) {
            VkShaderCreateInfoEXT.nnextStage(this.address(), value);
            return this;
        }

        public Buffer codeType(@NativeType(value="VkShaderCodeTypeEXT") int value) {
            VkShaderCreateInfoEXT.ncodeType(this.address(), value);
            return this;
        }

        public Buffer pCode(@NativeType(value="void const *") ByteBuffer value) {
            VkShaderCreateInfoEXT.npCode(this.address(), value);
            return this;
        }

        public Buffer pName(@NativeType(value="char const *") @Nullable ByteBuffer value) {
            VkShaderCreateInfoEXT.npName(this.address(), value);
            return this;
        }

        public Buffer setLayoutCount(@NativeType(value="uint32_t") int value) {
            VkShaderCreateInfoEXT.nsetLayoutCount(this.address(), value);
            return this;
        }

        public Buffer pSetLayouts(@NativeType(value="VkDescriptorSetLayout const *") @Nullable LongBuffer value) {
            VkShaderCreateInfoEXT.npSetLayouts(this.address(), value);
            return this;
        }

        public Buffer pushConstantRangeCount(@NativeType(value="uint32_t") int value) {
            VkShaderCreateInfoEXT.npushConstantRangeCount(this.address(), value);
            return this;
        }

        public Buffer pPushConstantRanges(@NativeType(value="VkPushConstantRange const *") @Nullable VkPushConstantRange.Buffer value) {
            VkShaderCreateInfoEXT.npPushConstantRanges(this.address(), value);
            return this;
        }

        public Buffer pSpecializationInfo(@NativeType(value="VkSpecializationInfo const *") @Nullable VkSpecializationInfo value) {
            VkShaderCreateInfoEXT.npSpecializationInfo(this.address(), value);
            return this;
        }
    }
}

