/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkSubresourceLayout
extends Struct<VkSubresourceLayout>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OFFSET;
    public static final int SIZE;
    public static final int ROWPITCH;
    public static final int ARRAYPITCH;
    public static final int DEPTHPITCH;

    protected VkSubresourceLayout(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkSubresourceLayout create(long address, @Nullable ByteBuffer container) {
        return new VkSubresourceLayout(address, container);
    }

    public VkSubresourceLayout(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkSubresourceLayout.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceSize")
    public long offset() {
        return VkSubresourceLayout.noffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VkSubresourceLayout.nsize(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long rowPitch() {
        return VkSubresourceLayout.nrowPitch(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long arrayPitch() {
        return VkSubresourceLayout.narrayPitch(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long depthPitch() {
        return VkSubresourceLayout.ndepthPitch(this.address());
    }

    public VkSubresourceLayout offset(@NativeType(value="VkDeviceSize") long value) {
        VkSubresourceLayout.noffset(this.address(), value);
        return this;
    }

    public VkSubresourceLayout size(@NativeType(value="VkDeviceSize") long value) {
        VkSubresourceLayout.nsize(this.address(), value);
        return this;
    }

    public VkSubresourceLayout rowPitch(@NativeType(value="VkDeviceSize") long value) {
        VkSubresourceLayout.nrowPitch(this.address(), value);
        return this;
    }

    public VkSubresourceLayout arrayPitch(@NativeType(value="VkDeviceSize") long value) {
        VkSubresourceLayout.narrayPitch(this.address(), value);
        return this;
    }

    public VkSubresourceLayout depthPitch(@NativeType(value="VkDeviceSize") long value) {
        VkSubresourceLayout.ndepthPitch(this.address(), value);
        return this;
    }

    public VkSubresourceLayout set(long offset, long size, long rowPitch, long arrayPitch, long depthPitch) {
        this.offset(offset);
        this.size(size);
        this.rowPitch(rowPitch);
        this.arrayPitch(arrayPitch);
        this.depthPitch(depthPitch);
        return this;
    }

    public VkSubresourceLayout set(VkSubresourceLayout src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkSubresourceLayout malloc() {
        return new VkSubresourceLayout(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkSubresourceLayout calloc() {
        return new VkSubresourceLayout(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkSubresourceLayout create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkSubresourceLayout(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkSubresourceLayout create(long address) {
        return new VkSubresourceLayout(address, null);
    }

    public static @Nullable VkSubresourceLayout createSafe(long address) {
        return address == 0L ? null : new VkSubresourceLayout(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkSubresourceLayout.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSubresourceLayout.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkSubresourceLayout mallocStack() {
        return VkSubresourceLayout.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSubresourceLayout callocStack() {
        return VkSubresourceLayout.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSubresourceLayout mallocStack(MemoryStack stack) {
        return VkSubresourceLayout.malloc(stack);
    }

    @Deprecated
    public static VkSubresourceLayout callocStack(MemoryStack stack) {
        return VkSubresourceLayout.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkSubresourceLayout.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkSubresourceLayout.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSubresourceLayout.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSubresourceLayout.calloc(capacity, stack);
    }

    public static VkSubresourceLayout malloc(MemoryStack stack) {
        return new VkSubresourceLayout(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkSubresourceLayout calloc(MemoryStack stack) {
        return new VkSubresourceLayout(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long noffset(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)OFFSET));
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)SIZE));
    }

    public static long nrowPitch(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)ROWPITCH));
    }

    public static long narrayPitch(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)ARRAYPITCH));
    }

    public static long ndepthPitch(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)DEPTHPITCH));
    }

    public static void noffset(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)OFFSET), (long)value);
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)SIZE), (long)value);
    }

    public static void nrowPitch(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)ROWPITCH), (long)value);
    }

    public static void narrayPitch(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)ARRAYPITCH), (long)value);
    }

    public static void ndepthPitch(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)DEPTHPITCH), (long)value);
    }

    static {
        Struct.Layout layout = VkSubresourceLayout.__struct((Struct.Member[])new Struct.Member[]{VkSubresourceLayout.__member((int)8), VkSubresourceLayout.__member((int)8), VkSubresourceLayout.__member((int)8), VkSubresourceLayout.__member((int)8), VkSubresourceLayout.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OFFSET = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        ROWPITCH = layout.offsetof(2);
        ARRAYPITCH = layout.offsetof(3);
        DEPTHPITCH = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkSubresourceLayout, Buffer>
    implements NativeResource {
        private static final VkSubresourceLayout ELEMENT_FACTORY = VkSubresourceLayout.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkSubresourceLayout getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceSize")
        public long offset() {
            return VkSubresourceLayout.noffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VkSubresourceLayout.nsize(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long rowPitch() {
            return VkSubresourceLayout.nrowPitch(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long arrayPitch() {
            return VkSubresourceLayout.narrayPitch(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long depthPitch() {
            return VkSubresourceLayout.ndepthPitch(this.address());
        }

        public Buffer offset(@NativeType(value="VkDeviceSize") long value) {
            VkSubresourceLayout.noffset(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="VkDeviceSize") long value) {
            VkSubresourceLayout.nsize(this.address(), value);
            return this;
        }

        public Buffer rowPitch(@NativeType(value="VkDeviceSize") long value) {
            VkSubresourceLayout.nrowPitch(this.address(), value);
            return this;
        }

        public Buffer arrayPitch(@NativeType(value="VkDeviceSize") long value) {
            VkSubresourceLayout.narrayPitch(this.address(), value);
            return this;
        }

        public Buffer depthPitch(@NativeType(value="VkDeviceSize") long value) {
            VkSubresourceLayout.ndepthPitch(this.address(), value);
            return this;
        }
    }
}

