/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkImageCompressionPropertiesEXT;
import org.lwjgl.vulkan.VkSubresourceHostMemcpySize;
import org.lwjgl.vulkan.VkSubresourceHostMemcpySizeEXT;
import org.lwjgl.vulkan.VkSubresourceLayout;

public class VkSubresourceLayout2
extends Struct<VkSubresourceLayout2>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SUBRESOURCELAYOUT;

    protected VkSubresourceLayout2(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkSubresourceLayout2 create(long address, @Nullable ByteBuffer container) {
        return new VkSubresourceLayout2(address, container);
    }

    public VkSubresourceLayout2(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkSubresourceLayout2.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkSubresourceLayout2.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkSubresourceLayout2.npNext(this.address());
    }

    public VkSubresourceLayout subresourceLayout() {
        return VkSubresourceLayout2.nsubresourceLayout(this.address());
    }

    public VkSubresourceLayout2 sType(@NativeType(value="VkStructureType") int value) {
        VkSubresourceLayout2.nsType(this.address(), value);
        return this;
    }

    public VkSubresourceLayout2 sType$Default() {
        return this.sType(1000338002);
    }

    public VkSubresourceLayout2 pNext(@NativeType(value="void *") long value) {
        VkSubresourceLayout2.npNext(this.address(), value);
        return this;
    }

    public VkSubresourceLayout2 pNext(VkImageCompressionPropertiesEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSubresourceLayout2 pNext(VkSubresourceHostMemcpySize value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSubresourceLayout2 pNext(VkSubresourceHostMemcpySizeEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSubresourceLayout2 set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkSubresourceLayout2 set(VkSubresourceLayout2 src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkSubresourceLayout2 malloc() {
        return new VkSubresourceLayout2(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkSubresourceLayout2 calloc() {
        return new VkSubresourceLayout2(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkSubresourceLayout2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkSubresourceLayout2(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkSubresourceLayout2 create(long address) {
        return new VkSubresourceLayout2(address, null);
    }

    public static @Nullable VkSubresourceLayout2 createSafe(long address) {
        return address == 0L ? null : new VkSubresourceLayout2(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkSubresourceLayout2.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSubresourceLayout2.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkSubresourceLayout2 malloc(MemoryStack stack) {
        return new VkSubresourceLayout2(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkSubresourceLayout2 calloc(MemoryStack stack) {
        return new VkSubresourceLayout2(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static VkSubresourceLayout nsubresourceLayout(long struct) {
        return VkSubresourceLayout.create(struct + (long)SUBRESOURCELAYOUT);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    static {
        Struct.Layout layout = VkSubresourceLayout2.__struct((Struct.Member[])new Struct.Member[]{VkSubresourceLayout2.__member((int)4), VkSubresourceLayout2.__member((int)POINTER_SIZE), VkSubresourceLayout2.__member((int)VkSubresourceLayout.SIZEOF, (int)VkSubresourceLayout.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SUBRESOURCELAYOUT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkSubresourceLayout2, Buffer>
    implements NativeResource {
        private static final VkSubresourceLayout2 ELEMENT_FACTORY = VkSubresourceLayout2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkSubresourceLayout2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkSubresourceLayout2.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkSubresourceLayout2.npNext(this.address());
        }

        public VkSubresourceLayout subresourceLayout() {
            return VkSubresourceLayout2.nsubresourceLayout(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkSubresourceLayout2.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000338002);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkSubresourceLayout2.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkImageCompressionPropertiesEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkSubresourceHostMemcpySize value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkSubresourceHostMemcpySizeEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }
    }
}

