/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDeviceGroupSwapchainCreateInfoKHR;
import org.lwjgl.vulkan.VkExtent2D;
import org.lwjgl.vulkan.VkImageCompressionControlEXT;
import org.lwjgl.vulkan.VkImageFormatListCreateInfo;
import org.lwjgl.vulkan.VkImageFormatListCreateInfoKHR;
import org.lwjgl.vulkan.VkSurfaceFullScreenExclusiveInfoEXT;
import org.lwjgl.vulkan.VkSurfaceFullScreenExclusiveWin32InfoEXT;
import org.lwjgl.vulkan.VkSwapchainCounterCreateInfoEXT;
import org.lwjgl.vulkan.VkSwapchainDisplayNativeHdrCreateInfoAMD;
import org.lwjgl.vulkan.VkSwapchainLatencyCreateInfoNV;
import org.lwjgl.vulkan.VkSwapchainPresentBarrierCreateInfoNV;
import org.lwjgl.vulkan.VkSwapchainPresentModesCreateInfoEXT;
import org.lwjgl.vulkan.VkSwapchainPresentScalingCreateInfoEXT;

public class VkSwapchainCreateInfoKHR
extends Struct<VkSwapchainCreateInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int SURFACE;
    public static final int MINIMAGECOUNT;
    public static final int IMAGEFORMAT;
    public static final int IMAGECOLORSPACE;
    public static final int IMAGEEXTENT;
    public static final int IMAGEARRAYLAYERS;
    public static final int IMAGEUSAGE;
    public static final int IMAGESHARINGMODE;
    public static final int QUEUEFAMILYINDEXCOUNT;
    public static final int PQUEUEFAMILYINDICES;
    public static final int PRETRANSFORM;
    public static final int COMPOSITEALPHA;
    public static final int PRESENTMODE;
    public static final int CLIPPED;
    public static final int OLDSWAPCHAIN;

    protected VkSwapchainCreateInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkSwapchainCreateInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkSwapchainCreateInfoKHR(address, container);
    }

    public VkSwapchainCreateInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkSwapchainCreateInfoKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkSwapchainCreateInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkSwapchainCreateInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkSwapchainCreateFlagsKHR")
    public int flags() {
        return VkSwapchainCreateInfoKHR.nflags(this.address());
    }

    @NativeType(value="VkSurfaceKHR")
    public long surface() {
        return VkSwapchainCreateInfoKHR.nsurface(this.address());
    }

    @NativeType(value="uint32_t")
    public int minImageCount() {
        return VkSwapchainCreateInfoKHR.nminImageCount(this.address());
    }

    @NativeType(value="VkFormat")
    public int imageFormat() {
        return VkSwapchainCreateInfoKHR.nimageFormat(this.address());
    }

    @NativeType(value="VkColorSpaceKHR")
    public int imageColorSpace() {
        return VkSwapchainCreateInfoKHR.nimageColorSpace(this.address());
    }

    public VkExtent2D imageExtent() {
        return VkSwapchainCreateInfoKHR.nimageExtent(this.address());
    }

    @NativeType(value="uint32_t")
    public int imageArrayLayers() {
        return VkSwapchainCreateInfoKHR.nimageArrayLayers(this.address());
    }

    @NativeType(value="VkImageUsageFlags")
    public int imageUsage() {
        return VkSwapchainCreateInfoKHR.nimageUsage(this.address());
    }

    @NativeType(value="VkSharingMode")
    public int imageSharingMode() {
        return VkSwapchainCreateInfoKHR.nimageSharingMode(this.address());
    }

    @NativeType(value="uint32_t")
    public int queueFamilyIndexCount() {
        return VkSwapchainCreateInfoKHR.nqueueFamilyIndexCount(this.address());
    }

    @NativeType(value="uint32_t const *")
    public @Nullable IntBuffer pQueueFamilyIndices() {
        return VkSwapchainCreateInfoKHR.npQueueFamilyIndices(this.address());
    }

    @NativeType(value="VkSurfaceTransformFlagBitsKHR")
    public int preTransform() {
        return VkSwapchainCreateInfoKHR.npreTransform(this.address());
    }

    @NativeType(value="VkCompositeAlphaFlagBitsKHR")
    public int compositeAlpha() {
        return VkSwapchainCreateInfoKHR.ncompositeAlpha(this.address());
    }

    @NativeType(value="VkPresentModeKHR")
    public int presentMode() {
        return VkSwapchainCreateInfoKHR.npresentMode(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean clipped() {
        return VkSwapchainCreateInfoKHR.nclipped(this.address()) != 0;
    }

    @NativeType(value="VkSwapchainKHR")
    public long oldSwapchain() {
        return VkSwapchainCreateInfoKHR.noldSwapchain(this.address());
    }

    public VkSwapchainCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkSwapchainCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR sType$Default() {
        return this.sType(1000001000);
    }

    public VkSwapchainCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkSwapchainCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR pNext(VkDeviceGroupSwapchainCreateInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSwapchainCreateInfoKHR pNext(VkImageCompressionControlEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSwapchainCreateInfoKHR pNext(VkImageFormatListCreateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSwapchainCreateInfoKHR pNext(VkImageFormatListCreateInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSwapchainCreateInfoKHR pNext(VkSurfaceFullScreenExclusiveInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSwapchainCreateInfoKHR pNext(VkSurfaceFullScreenExclusiveWin32InfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSwapchainCreateInfoKHR pNext(VkSwapchainCounterCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSwapchainCreateInfoKHR pNext(VkSwapchainDisplayNativeHdrCreateInfoAMD value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSwapchainCreateInfoKHR pNext(VkSwapchainLatencyCreateInfoNV value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSwapchainCreateInfoKHR pNext(VkSwapchainPresentBarrierCreateInfoNV value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSwapchainCreateInfoKHR pNext(VkSwapchainPresentModesCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSwapchainCreateInfoKHR pNext(VkSwapchainPresentScalingCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSwapchainCreateInfoKHR flags(@NativeType(value="VkSwapchainCreateFlagsKHR") int value) {
        VkSwapchainCreateInfoKHR.nflags(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR surface(@NativeType(value="VkSurfaceKHR") long value) {
        VkSwapchainCreateInfoKHR.nsurface(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR minImageCount(@NativeType(value="uint32_t") int value) {
        VkSwapchainCreateInfoKHR.nminImageCount(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR imageFormat(@NativeType(value="VkFormat") int value) {
        VkSwapchainCreateInfoKHR.nimageFormat(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR imageColorSpace(@NativeType(value="VkColorSpaceKHR") int value) {
        VkSwapchainCreateInfoKHR.nimageColorSpace(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR imageExtent(VkExtent2D value) {
        VkSwapchainCreateInfoKHR.nimageExtent(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR imageExtent(Consumer<VkExtent2D> consumer) {
        consumer.accept(this.imageExtent());
        return this;
    }

    public VkSwapchainCreateInfoKHR imageArrayLayers(@NativeType(value="uint32_t") int value) {
        VkSwapchainCreateInfoKHR.nimageArrayLayers(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR imageUsage(@NativeType(value="VkImageUsageFlags") int value) {
        VkSwapchainCreateInfoKHR.nimageUsage(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR imageSharingMode(@NativeType(value="VkSharingMode") int value) {
        VkSwapchainCreateInfoKHR.nimageSharingMode(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR queueFamilyIndexCount(@NativeType(value="uint32_t") int value) {
        VkSwapchainCreateInfoKHR.nqueueFamilyIndexCount(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR pQueueFamilyIndices(@NativeType(value="uint32_t const *") @Nullable IntBuffer value) {
        VkSwapchainCreateInfoKHR.npQueueFamilyIndices(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR preTransform(@NativeType(value="VkSurfaceTransformFlagBitsKHR") int value) {
        VkSwapchainCreateInfoKHR.npreTransform(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR compositeAlpha(@NativeType(value="VkCompositeAlphaFlagBitsKHR") int value) {
        VkSwapchainCreateInfoKHR.ncompositeAlpha(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR presentMode(@NativeType(value="VkPresentModeKHR") int value) {
        VkSwapchainCreateInfoKHR.npresentMode(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR clipped(@NativeType(value="VkBool32") boolean value) {
        VkSwapchainCreateInfoKHR.nclipped(this.address(), value ? 1 : 0);
        return this;
    }

    public VkSwapchainCreateInfoKHR oldSwapchain(@NativeType(value="VkSwapchainKHR") long value) {
        VkSwapchainCreateInfoKHR.noldSwapchain(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR set(int sType, long pNext, int flags, long surface, int minImageCount, int imageFormat, int imageColorSpace, VkExtent2D imageExtent, int imageArrayLayers, int imageUsage, int imageSharingMode, int queueFamilyIndexCount, @Nullable IntBuffer pQueueFamilyIndices, int preTransform, int compositeAlpha, int presentMode, boolean clipped, long oldSwapchain) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.surface(surface);
        this.minImageCount(minImageCount);
        this.imageFormat(imageFormat);
        this.imageColorSpace(imageColorSpace);
        this.imageExtent(imageExtent);
        this.imageArrayLayers(imageArrayLayers);
        this.imageUsage(imageUsage);
        this.imageSharingMode(imageSharingMode);
        this.queueFamilyIndexCount(queueFamilyIndexCount);
        this.pQueueFamilyIndices(pQueueFamilyIndices);
        this.preTransform(preTransform);
        this.compositeAlpha(compositeAlpha);
        this.presentMode(presentMode);
        this.clipped(clipped);
        this.oldSwapchain(oldSwapchain);
        return this;
    }

    public VkSwapchainCreateInfoKHR set(VkSwapchainCreateInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkSwapchainCreateInfoKHR malloc() {
        return new VkSwapchainCreateInfoKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkSwapchainCreateInfoKHR calloc() {
        return new VkSwapchainCreateInfoKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkSwapchainCreateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkSwapchainCreateInfoKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkSwapchainCreateInfoKHR create(long address) {
        return new VkSwapchainCreateInfoKHR(address, null);
    }

    public static @Nullable VkSwapchainCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkSwapchainCreateInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkSwapchainCreateInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSwapchainCreateInfoKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkSwapchainCreateInfoKHR mallocStack() {
        return VkSwapchainCreateInfoKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSwapchainCreateInfoKHR callocStack() {
        return VkSwapchainCreateInfoKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSwapchainCreateInfoKHR mallocStack(MemoryStack stack) {
        return VkSwapchainCreateInfoKHR.malloc(stack);
    }

    @Deprecated
    public static VkSwapchainCreateInfoKHR callocStack(MemoryStack stack) {
        return VkSwapchainCreateInfoKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkSwapchainCreateInfoKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkSwapchainCreateInfoKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSwapchainCreateInfoKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSwapchainCreateInfoKHR.calloc(capacity, stack);
    }

    public static VkSwapchainCreateInfoKHR malloc(MemoryStack stack) {
        return new VkSwapchainCreateInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkSwapchainCreateInfoKHR calloc(MemoryStack stack) {
        return new VkSwapchainCreateInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FLAGS));
    }

    public static long nsurface(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)SURFACE));
    }

    public static int nminImageCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MINIMAGECOUNT));
    }

    public static int nimageFormat(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)IMAGEFORMAT));
    }

    public static int nimageColorSpace(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)IMAGECOLORSPACE));
    }

    public static VkExtent2D nimageExtent(long struct) {
        return VkExtent2D.create(struct + (long)IMAGEEXTENT);
    }

    public static int nimageArrayLayers(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)IMAGEARRAYLAYERS));
    }

    public static int nimageUsage(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)IMAGEUSAGE));
    }

    public static int nimageSharingMode(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)IMAGESHARINGMODE));
    }

    public static int nqueueFamilyIndexCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)QUEUEFAMILYINDEXCOUNT));
    }

    public static @Nullable IntBuffer npQueueFamilyIndices(long struct) {
        return MemoryUtil.memIntBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PQUEUEFAMILYINDICES)), (int)VkSwapchainCreateInfoKHR.nqueueFamilyIndexCount(struct));
    }

    public static int npreTransform(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)PRETRANSFORM));
    }

    public static int ncompositeAlpha(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)COMPOSITEALPHA));
    }

    public static int npresentMode(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)PRESENTMODE));
    }

    public static int nclipped(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)CLIPPED));
    }

    public static long noldSwapchain(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)OLDSWAPCHAIN));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FLAGS), (int)value);
    }

    public static void nsurface(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)SURFACE), (long)value);
    }

    public static void nminImageCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MINIMAGECOUNT), (int)value);
    }

    public static void nimageFormat(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)IMAGEFORMAT), (int)value);
    }

    public static void nimageColorSpace(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)IMAGECOLORSPACE), (int)value);
    }

    public static void nimageExtent(long struct, VkExtent2D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)IMAGEEXTENT), (long)VkExtent2D.SIZEOF);
    }

    public static void nimageArrayLayers(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)IMAGEARRAYLAYERS), (int)value);
    }

    public static void nimageUsage(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)IMAGEUSAGE), (int)value);
    }

    public static void nimageSharingMode(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)IMAGESHARINGMODE), (int)value);
    }

    public static void nqueueFamilyIndexCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)QUEUEFAMILYINDEXCOUNT), (int)value);
    }

    public static void npQueueFamilyIndices(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PQUEUEFAMILYINDICES), (long)MemoryUtil.memAddressSafe((IntBuffer)value));
        if (value != null) {
            VkSwapchainCreateInfoKHR.nqueueFamilyIndexCount(struct, value.remaining());
        }
    }

    public static void npreTransform(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)PRETRANSFORM), (int)value);
    }

    public static void ncompositeAlpha(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)COMPOSITEALPHA), (int)value);
    }

    public static void npresentMode(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)PRESENTMODE), (int)value);
    }

    public static void nclipped(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)CLIPPED), (int)value);
    }

    public static void noldSwapchain(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)OLDSWAPCHAIN), (long)value);
    }

    static {
        Struct.Layout layout = VkSwapchainCreateInfoKHR.__struct((Struct.Member[])new Struct.Member[]{VkSwapchainCreateInfoKHR.__member((int)4), VkSwapchainCreateInfoKHR.__member((int)POINTER_SIZE), VkSwapchainCreateInfoKHR.__member((int)4), VkSwapchainCreateInfoKHR.__member((int)8), VkSwapchainCreateInfoKHR.__member((int)4), VkSwapchainCreateInfoKHR.__member((int)4), VkSwapchainCreateInfoKHR.__member((int)4), VkSwapchainCreateInfoKHR.__member((int)VkExtent2D.SIZEOF, (int)VkExtent2D.ALIGNOF), VkSwapchainCreateInfoKHR.__member((int)4), VkSwapchainCreateInfoKHR.__member((int)4), VkSwapchainCreateInfoKHR.__member((int)4), VkSwapchainCreateInfoKHR.__member((int)4), VkSwapchainCreateInfoKHR.__member((int)POINTER_SIZE), VkSwapchainCreateInfoKHR.__member((int)4), VkSwapchainCreateInfoKHR.__member((int)4), VkSwapchainCreateInfoKHR.__member((int)4), VkSwapchainCreateInfoKHR.__member((int)4), VkSwapchainCreateInfoKHR.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        SURFACE = layout.offsetof(3);
        MINIMAGECOUNT = layout.offsetof(4);
        IMAGEFORMAT = layout.offsetof(5);
        IMAGECOLORSPACE = layout.offsetof(6);
        IMAGEEXTENT = layout.offsetof(7);
        IMAGEARRAYLAYERS = layout.offsetof(8);
        IMAGEUSAGE = layout.offsetof(9);
        IMAGESHARINGMODE = layout.offsetof(10);
        QUEUEFAMILYINDEXCOUNT = layout.offsetof(11);
        PQUEUEFAMILYINDICES = layout.offsetof(12);
        PRETRANSFORM = layout.offsetof(13);
        COMPOSITEALPHA = layout.offsetof(14);
        PRESENTMODE = layout.offsetof(15);
        CLIPPED = layout.offsetof(16);
        OLDSWAPCHAIN = layout.offsetof(17);
    }

    public static class Buffer
    extends StructBuffer<VkSwapchainCreateInfoKHR, Buffer>
    implements NativeResource {
        private static final VkSwapchainCreateInfoKHR ELEMENT_FACTORY = VkSwapchainCreateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkSwapchainCreateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkSwapchainCreateInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkSwapchainCreateInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkSwapchainCreateFlagsKHR")
        public int flags() {
            return VkSwapchainCreateInfoKHR.nflags(this.address());
        }

        @NativeType(value="VkSurfaceKHR")
        public long surface() {
            return VkSwapchainCreateInfoKHR.nsurface(this.address());
        }

        @NativeType(value="uint32_t")
        public int minImageCount() {
            return VkSwapchainCreateInfoKHR.nminImageCount(this.address());
        }

        @NativeType(value="VkFormat")
        public int imageFormat() {
            return VkSwapchainCreateInfoKHR.nimageFormat(this.address());
        }

        @NativeType(value="VkColorSpaceKHR")
        public int imageColorSpace() {
            return VkSwapchainCreateInfoKHR.nimageColorSpace(this.address());
        }

        public VkExtent2D imageExtent() {
            return VkSwapchainCreateInfoKHR.nimageExtent(this.address());
        }

        @NativeType(value="uint32_t")
        public int imageArrayLayers() {
            return VkSwapchainCreateInfoKHR.nimageArrayLayers(this.address());
        }

        @NativeType(value="VkImageUsageFlags")
        public int imageUsage() {
            return VkSwapchainCreateInfoKHR.nimageUsage(this.address());
        }

        @NativeType(value="VkSharingMode")
        public int imageSharingMode() {
            return VkSwapchainCreateInfoKHR.nimageSharingMode(this.address());
        }

        @NativeType(value="uint32_t")
        public int queueFamilyIndexCount() {
            return VkSwapchainCreateInfoKHR.nqueueFamilyIndexCount(this.address());
        }

        @NativeType(value="uint32_t const *")
        public @Nullable IntBuffer pQueueFamilyIndices() {
            return VkSwapchainCreateInfoKHR.npQueueFamilyIndices(this.address());
        }

        @NativeType(value="VkSurfaceTransformFlagBitsKHR")
        public int preTransform() {
            return VkSwapchainCreateInfoKHR.npreTransform(this.address());
        }

        @NativeType(value="VkCompositeAlphaFlagBitsKHR")
        public int compositeAlpha() {
            return VkSwapchainCreateInfoKHR.ncompositeAlpha(this.address());
        }

        @NativeType(value="VkPresentModeKHR")
        public int presentMode() {
            return VkSwapchainCreateInfoKHR.npresentMode(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean clipped() {
            return VkSwapchainCreateInfoKHR.nclipped(this.address()) != 0;
        }

        @NativeType(value="VkSwapchainKHR")
        public long oldSwapchain() {
            return VkSwapchainCreateInfoKHR.noldSwapchain(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkSwapchainCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000001000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkSwapchainCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkDeviceGroupSwapchainCreateInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkImageCompressionControlEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkImageFormatListCreateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkImageFormatListCreateInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkSurfaceFullScreenExclusiveInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkSurfaceFullScreenExclusiveWin32InfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkSwapchainCounterCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkSwapchainDisplayNativeHdrCreateInfoAMD value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkSwapchainLatencyCreateInfoNV value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkSwapchainPresentBarrierCreateInfoNV value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkSwapchainPresentModesCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkSwapchainPresentScalingCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkSwapchainCreateFlagsKHR") int value) {
            VkSwapchainCreateInfoKHR.nflags(this.address(), value);
            return this;
        }

        public Buffer surface(@NativeType(value="VkSurfaceKHR") long value) {
            VkSwapchainCreateInfoKHR.nsurface(this.address(), value);
            return this;
        }

        public Buffer minImageCount(@NativeType(value="uint32_t") int value) {
            VkSwapchainCreateInfoKHR.nminImageCount(this.address(), value);
            return this;
        }

        public Buffer imageFormat(@NativeType(value="VkFormat") int value) {
            VkSwapchainCreateInfoKHR.nimageFormat(this.address(), value);
            return this;
        }

        public Buffer imageColorSpace(@NativeType(value="VkColorSpaceKHR") int value) {
            VkSwapchainCreateInfoKHR.nimageColorSpace(this.address(), value);
            return this;
        }

        public Buffer imageExtent(VkExtent2D value) {
            VkSwapchainCreateInfoKHR.nimageExtent(this.address(), value);
            return this;
        }

        public Buffer imageExtent(Consumer<VkExtent2D> consumer) {
            consumer.accept(this.imageExtent());
            return this;
        }

        public Buffer imageArrayLayers(@NativeType(value="uint32_t") int value) {
            VkSwapchainCreateInfoKHR.nimageArrayLayers(this.address(), value);
            return this;
        }

        public Buffer imageUsage(@NativeType(value="VkImageUsageFlags") int value) {
            VkSwapchainCreateInfoKHR.nimageUsage(this.address(), value);
            return this;
        }

        public Buffer imageSharingMode(@NativeType(value="VkSharingMode") int value) {
            VkSwapchainCreateInfoKHR.nimageSharingMode(this.address(), value);
            return this;
        }

        public Buffer queueFamilyIndexCount(@NativeType(value="uint32_t") int value) {
            VkSwapchainCreateInfoKHR.nqueueFamilyIndexCount(this.address(), value);
            return this;
        }

        public Buffer pQueueFamilyIndices(@NativeType(value="uint32_t const *") @Nullable IntBuffer value) {
            VkSwapchainCreateInfoKHR.npQueueFamilyIndices(this.address(), value);
            return this;
        }

        public Buffer preTransform(@NativeType(value="VkSurfaceTransformFlagBitsKHR") int value) {
            VkSwapchainCreateInfoKHR.npreTransform(this.address(), value);
            return this;
        }

        public Buffer compositeAlpha(@NativeType(value="VkCompositeAlphaFlagBitsKHR") int value) {
            VkSwapchainCreateInfoKHR.ncompositeAlpha(this.address(), value);
            return this;
        }

        public Buffer presentMode(@NativeType(value="VkPresentModeKHR") int value) {
            VkSwapchainCreateInfoKHR.npresentMode(this.address(), value);
            return this;
        }

        public Buffer clipped(@NativeType(value="VkBool32") boolean value) {
            VkSwapchainCreateInfoKHR.nclipped(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer oldSwapchain(@NativeType(value="VkSwapchainKHR") long value) {
            VkSwapchainCreateInfoKHR.noldSwapchain(this.address(), value);
            return this;
        }
    }
}

