/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent2D;
import org.lwjgl.vulkan.VkExtent3D;
import org.lwjgl.vulkan.VkOffset2D;

public class VkTilePropertiesQCOM
extends Struct<VkTilePropertiesQCOM>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int TILESIZE;
    public static final int APRONSIZE;
    public static final int ORIGIN;

    protected VkTilePropertiesQCOM(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkTilePropertiesQCOM create(long address, @Nullable ByteBuffer container) {
        return new VkTilePropertiesQCOM(address, container);
    }

    public VkTilePropertiesQCOM(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkTilePropertiesQCOM.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkTilePropertiesQCOM.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkTilePropertiesQCOM.npNext(this.address());
    }

    public VkExtent3D tileSize() {
        return VkTilePropertiesQCOM.ntileSize(this.address());
    }

    public VkExtent2D apronSize() {
        return VkTilePropertiesQCOM.napronSize(this.address());
    }

    public VkOffset2D origin() {
        return VkTilePropertiesQCOM.norigin(this.address());
    }

    public VkTilePropertiesQCOM sType(@NativeType(value="VkStructureType") int value) {
        VkTilePropertiesQCOM.nsType(this.address(), value);
        return this;
    }

    public VkTilePropertiesQCOM sType$Default() {
        return this.sType(1000484001);
    }

    public VkTilePropertiesQCOM pNext(@NativeType(value="void *") long value) {
        VkTilePropertiesQCOM.npNext(this.address(), value);
        return this;
    }

    public VkTilePropertiesQCOM tileSize(VkExtent3D value) {
        VkTilePropertiesQCOM.ntileSize(this.address(), value);
        return this;
    }

    public VkTilePropertiesQCOM tileSize(Consumer<VkExtent3D> consumer) {
        consumer.accept(this.tileSize());
        return this;
    }

    public VkTilePropertiesQCOM apronSize(VkExtent2D value) {
        VkTilePropertiesQCOM.napronSize(this.address(), value);
        return this;
    }

    public VkTilePropertiesQCOM apronSize(Consumer<VkExtent2D> consumer) {
        consumer.accept(this.apronSize());
        return this;
    }

    public VkTilePropertiesQCOM origin(VkOffset2D value) {
        VkTilePropertiesQCOM.norigin(this.address(), value);
        return this;
    }

    public VkTilePropertiesQCOM origin(Consumer<VkOffset2D> consumer) {
        consumer.accept(this.origin());
        return this;
    }

    public VkTilePropertiesQCOM set(int sType, long pNext, VkExtent3D tileSize, VkExtent2D apronSize, VkOffset2D origin) {
        this.sType(sType);
        this.pNext(pNext);
        this.tileSize(tileSize);
        this.apronSize(apronSize);
        this.origin(origin);
        return this;
    }

    public VkTilePropertiesQCOM set(VkTilePropertiesQCOM src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkTilePropertiesQCOM malloc() {
        return new VkTilePropertiesQCOM(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkTilePropertiesQCOM calloc() {
        return new VkTilePropertiesQCOM(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkTilePropertiesQCOM create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkTilePropertiesQCOM(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkTilePropertiesQCOM create(long address) {
        return new VkTilePropertiesQCOM(address, null);
    }

    public static @Nullable VkTilePropertiesQCOM createSafe(long address) {
        return address == 0L ? null : new VkTilePropertiesQCOM(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkTilePropertiesQCOM.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkTilePropertiesQCOM.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkTilePropertiesQCOM malloc(MemoryStack stack) {
        return new VkTilePropertiesQCOM(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkTilePropertiesQCOM calloc(MemoryStack stack) {
        return new VkTilePropertiesQCOM(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STYPE));
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static VkExtent3D ntileSize(long struct) {
        return VkExtent3D.create(struct + (long)TILESIZE);
    }

    public static VkExtent2D napronSize(long struct) {
        return VkExtent2D.create(struct + (long)APRONSIZE);
    }

    public static VkOffset2D norigin(long struct) {
        return VkOffset2D.create(struct + (long)ORIGIN);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STYPE), (int)value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void ntileSize(long struct, VkExtent3D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)TILESIZE), (long)VkExtent3D.SIZEOF);
    }

    public static void napronSize(long struct, VkExtent2D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)APRONSIZE), (long)VkExtent2D.SIZEOF);
    }

    public static void norigin(long struct, VkOffset2D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)ORIGIN), (long)VkOffset2D.SIZEOF);
    }

    static {
        Struct.Layout layout = VkTilePropertiesQCOM.__struct((Struct.Member[])new Struct.Member[]{VkTilePropertiesQCOM.__member((int)4), VkTilePropertiesQCOM.__member((int)POINTER_SIZE), VkTilePropertiesQCOM.__member((int)VkExtent3D.SIZEOF, (int)VkExtent3D.ALIGNOF), VkTilePropertiesQCOM.__member((int)VkExtent2D.SIZEOF, (int)VkExtent2D.ALIGNOF), VkTilePropertiesQCOM.__member((int)VkOffset2D.SIZEOF, (int)VkOffset2D.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        TILESIZE = layout.offsetof(2);
        APRONSIZE = layout.offsetof(3);
        ORIGIN = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkTilePropertiesQCOM, Buffer>
    implements NativeResource {
        private static final VkTilePropertiesQCOM ELEMENT_FACTORY = VkTilePropertiesQCOM.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkTilePropertiesQCOM getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkTilePropertiesQCOM.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkTilePropertiesQCOM.npNext(this.address());
        }

        public VkExtent3D tileSize() {
            return VkTilePropertiesQCOM.ntileSize(this.address());
        }

        public VkExtent2D apronSize() {
            return VkTilePropertiesQCOM.napronSize(this.address());
        }

        public VkOffset2D origin() {
            return VkTilePropertiesQCOM.norigin(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkTilePropertiesQCOM.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000484001);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkTilePropertiesQCOM.npNext(this.address(), value);
            return this;
        }

        public Buffer tileSize(VkExtent3D value) {
            VkTilePropertiesQCOM.ntileSize(this.address(), value);
            return this;
        }

        public Buffer tileSize(Consumer<VkExtent3D> consumer) {
            consumer.accept(this.tileSize());
            return this;
        }

        public Buffer apronSize(VkExtent2D value) {
            VkTilePropertiesQCOM.napronSize(this.address(), value);
            return this;
        }

        public Buffer apronSize(Consumer<VkExtent2D> consumer) {
            consumer.accept(this.apronSize());
            return this;
        }

        public Buffer origin(VkOffset2D value) {
            VkTilePropertiesQCOM.norigin(this.address(), value);
            return this;
        }

        public Buffer origin(Consumer<VkOffset2D> consumer) {
            consumer.accept(this.origin());
            return this;
        }
    }
}

